<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('classes/ImapMailbox.php','libs/StripTagsSmart.php','libs/Server.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['CheckEmail'];
#-------------------------------------------------------------------------------
$KeyPrefix = $Config['Tasks']['Types']['TicketsMessages']['KeyPrefix'];
#-------------------------------------------------------------------------------
# проверяем необходимые для работы расширения
$Extensions = Array('imap','mailparse');
#-------------------------------------------------------------------------------
foreach($Extensions as $Extension){
	#-------------------------------------------------------------------------------
	if(!Extension_Loaded($Extension)){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/GC/CheckSoftWare]: Extensions not found: %s',$Extension));
		#-------------------------------------------------------------------------------
		$GLOBALS['TaskReturnInfo'] = SPrintF('not found php extension: %s, sleep 1 hour',$Extension);
		#-------------------------------------------------------------------------------
		return 3600;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$ExecuteTime = Comp_Load('Formats/Task/ExecuteTime',Array('ExecutePeriod'=>$Settings['ExecutePeriod']));
if(Is_Error($ExecuteTime))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return 3600;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ServerSettings = SelectServerSettingsByTemplate('EmailClient');
switch(ValueOf($ServerSettings)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'] = 'server with template: EmailClient, params: IsActive, IsDefault not found';
	#-------------------------------------------------------------------------------
	return $ExecuteTime;
	#-------------------------------------------------------------------------------
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$GLOBALS['TaskReturnInfo'] = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Count = DB_Count('Users',Array('ID'=>10));
if(Is_Error($Count))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Count){
	#-------------------------------------------------------------------------------
	Debug('[comp/Tasks/CheckEmail]: сообщения не обработаны, т.к. пользователь "Гость", идентификатор 10 не найден');
	#-------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'][] = "no message processing, because user 'Guest', ID=10 does not exists";
	#-------------------------------------------------------------------------------
	return $ExecuteTime;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Server = SPrintF("{%s/%s/%s}INBOX",$ServerSettings['Address'],$ServerSettings['Params']['Method'],($ServerSettings['Protocol'] == 'ssl')?'ssl/novalidate-cert':'notls');
#-------------------------------------------------------------------------------
$Tmp = System_Element('tmp');
if(Is_Error($Tmp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$attachmentsDir = SPrintF('%s///imap',$Tmp);
#-------------------------------------------------------------------------------
// создаём директорию для вложений. в конце она удалится
if(!File_Exists($attachmentsDir))
	MkDir($attachmentsDir, 0700, true);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
try{
	#-------------------------------------------------------------------------------
	$mailbox = new ImapMailbox($Server,$ServerSettings['Login'],$ServerSettings['Password'],$attachmentsDir);
	#-------------------------------------------------------------------------------
}catch(Exception $e){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/CheckEmail]: Exception = %s',$e->getMessage()));
	return 3600;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$GLOBALS['TaskReturnInfo'][] = SPrintF('%s messages',SizeOf($mailbox->searchMailbox()));
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/Tasks/CheckEmail]: сообщений = %s',SizeOf($mailbox->searchMailbox())));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Mails = $mailbox->searchMailbox();
#-------------------------------------------------------------------------------
foreach($Mails as $mailId){
	#-------------------------------------------------------------------------------
	// создаём директорию для вложений. в конце она удалится
	if(!File_Exists($attachmentsDir))
		MkDir($attachmentsDir, 0700, true);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$mail = $mailbox->getMail($mailId);
	#Debug(SPrintF('[comp/Tasks/CheckEmail]: mail = %s',print_r($mail,true)));
	#-------------------------------------------------------------------------------
	if(SizeOf($mailbox->searchMailbox()) < 1){
		#-------------------------------------------------------------------------------
		$mailbox->disconnect();
		#-------------------------------------------------------------------------------
		UnSet($GLOBALS['TaskReturnInfo']);
		#-------------------------------------------------------------------------------
		return $ExecuteTime;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Subject = $mail->subject;
	$fromAddress = StrToLower($mail->fromAddress);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// JBS-1402 - удаляем ссылки на авторизацию в биллинге
	$Regular = SPrintF('#((http|https)://%s/)(.*)(Password)(.*)#',HOST_ID);
	#-------------------------------------------------------------------------------
	$textPlain = Preg_Replace($Regular,'$1$3Password=***********',$mail->textPlain);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$replyTo = Array($fromAddress);
	#-------------------------------------------------------------------------------
	if(IsSet($mail->replyTo)){
		#-------------------------------------------------------------------------------
		foreach(Array_Keys($mail->replyTo) as $replyToAddr)
			if($fromAddress != StrToLower($replyToAddr))
				$replyTo[] = StrToLower($replyToAddr);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# если сообщение в html to textPlain - пустая
	if(!$textPlain)
		$textPlain = StripTagsSmart($mail->textHtml);
	#-------------------------------------------------------------------------------
	# перебираем аттачменты
	UnSet($_FILES);
	UnSet($Hash);
	#-------------------------------------------------------------------------------
	$Files = $mail->getAttachments();
	#-------------------------------------------------------------------------------
	$Hash = Array();
	#-------------------------------------------------------------------------------
	foreach($Files as $File){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/CheckEmail]: tmp_name = %s; FileName = %s',$File->filePath,$File->name));
		#-------------------------------------------------------------------------------
		if(FileSize($File->filePath) == 0){
			#-------------------------------------------------------------------------------
			// информация о файле
			$stat = stat($File->filePath);
			// выводим в дебаг
			Debug(SPrintF('[comp/Tasks/CheckEmail]: zero file, stat = %s',print_r($stat,true)));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# удаляем явно мусорные расширения
		$Array = Explode('.',$File->name);
		#-------------------------------------------------------------------------------
		$Extension = $Array[(Count($Array)-1)];
		#-------------------------------------------------------------------------------
		//if(In_Array($Extension,Array('sig')))
		//	continue;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$FileData = Array(
					'size'		=> FileSize($File->filePath),
					'error'		=> 0,
					'tmp_name'	=> $File->filePath,
					'name'		=> $File->name
				);
		#-------------------------------------------------------------------------------
		$_FILES = Array('Upload'=>$FileData);
		#-------------------------------------------------------------------------------
		global $_FILES;
		#-------------------------------------------------------------------------------
		$File = Comp_Load('www/API/Upload');
		if(Is_Error($File))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Hash[] = $File;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// если файлов нет - убираем переменную, далее по ней определяется необходимость аттачить файлы
	if(!SizeOf($Hash))
		UnSet($Hash);
	#-------------------------------------------------------------------------------

	#-------------------------------------------------------------------------------
	# надо ли вырезать цитаты из текста
	if($Settings['CutQuotes']){
		#-------------------------------------------------------------------------------
		$textPlain = Trim(Preg_Replace('#^>(.*)$#m', '',$textPlain));
		$textPlain = preg_replace("/\r/", "\n",$textPlain);
		$textPlain = trim(preg_replace('/[\n]+/m',"\n",$textPlain));
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$textPlain = Trim(Preg_Replace('/\n(\>.*(\n\>.*)*)/',"\n[quote]\\1[/quote]",$textPlain));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# надо ли отпиливать подпись из сообщения
	if($Settings['CutSign']){
		#-------------------------------------------------------------------------------
		$Texts = Explode("\n",$textPlain);
		#-------------------------------------------------------------------------------
		$textPlain = Array();
		#-------------------------------------------------------------------------------
		foreach($Texts as $Text){
			#-------------------------------------------------------------------------------
			$textPlain[] = Trim($Text);
			#-------------------------------------------------------------------------------
			if(Trim($Text) == '--')
				$SignPos = SizeOf($textPlain) - 1;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Length = (IsSet($SignPos))?$SignPos:SizeOf($textPlain);
		#-------------------------------------------------------------------------------
		$textPlain = Trim(Implode("\n",Array_Slice($textPlain,0,$Length)));
		#-------------------------------------------------------------------------------
		UnSet($SignPos);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# достаём все заголовки
	$References = FALSE;
	#-------------------------------------------------------------------------------
	$Headers = Explode("\n",Trim($mail->headers));
	#-------------------------------------------------------------------------------
	if(Is_Array($Headers) && Count($Headers)){
		foreach($Headers as $Line){
			#-------------------------------------------------------------------------------
			$HeaderLine = Explode(" ",Trim($Line));
			#-------------------------------------------------------------------------------
			if(StrToLower($HeaderLine[0]) == 'in-reply-to:')
				$References = (IsSet($HeaderLine[1])?$HeaderLine[1]:'[empty header]');
			#-------------------------------------------------------------------------------
			if(StrToLower($HeaderLine[0]) == 'references:')
				$References = (IsSet($HeaderLine[1])?$HeaderLine[1]:'[empty header]');
			#-------------------------------------------------------------------------------
			if(StrToLower($HeaderLine[0]) == 'x-autoreply:')
				$AutoReply = SPrintF('%s %s',$HeaderLine[0],(IsSet($HeaderLine[1])?$HeaderLine[1]:'[empty header]'));
			#-------------------------------------------------------------------------------
			if(StrToLower($HeaderLine[0]) == 'auto-submitted:')
				$AutoReply = SPrintF('%s %s',$HeaderLine[0],(IsSet($HeaderLine[1])?$HeaderLine[1]:'[empty header]'));
			#-------------------------------------------------------------------------------
			if(StrToLower($HeaderLine[0]) == 'x-auto-response-suppress:')
				$AutoReply = SPrintF('%s %s',$HeaderLine[0],(IsSet($HeaderLine[1])?$HeaderLine[1]:'[empty header]'));
			#-------------------------------------------------------------------------------
		}
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(StrLen($textPlain) < 2 && !IsSet($Hash)){
		#-------------------------------------------------------------------------------
		# пустое сообщение, или вместе с подписью текст выпилился
		Debug(SPrintF('[comp/Tasks/CheckEmail]: Пустое сообщение с адреса %s',$fromAddress));
		$IsDelete = FALSE;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(IsSet($AutoReply) && $Settings['DeleteAutoreply']){
		#-------------------------------------------------------------------------------
		$IsDelete = TRUE;
		#-------------------------------------------------------------------------------
		if(StrLen($Settings['DeleteAutoreplyExclude']) > 5){
			#-------------------------------------------------------------------------------
			$Emails = Explode(",",StrToLower($Settings['DeleteAutoreplyExclude']));
			#-------------------------------------------------------------------------------
			foreach($Emails as $Email){
				#-------------------------------------------------------------------------------
				if(Trim($Email) == $fromAddress){
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[comp/Tasks/CheckEmail]: Excluded AutoReply from: "%s", header: "%s"',$fromAddress,$AutoReply));
					#-------------------------------------------------------------------------------
					$IsDelete = FALSE;
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(IsSet($IsDelete) && $IsDelete){
		#-------------------------------------------------------------------------------
		# это автоответ. удаляем сообщение и продолжаем
		Debug(SPrintF('[comp/Tasks/CheckEmail]: AutoReply from: "%s", header: "%s"',$fromAddress,$AutoReply));
		#-------------------------------------------------------------------------------
		$mailbox->deleteMail($mail->id);
		#-------------------------------------------------------------------------------
		UnSet($AutoReply);
		UnSet($IsDelete);
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем наличие ссылки на тикет
	if($References){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/CheckEmail]: References %s',$References));
		#-------------------------------------------------------------------------------
		$Address = MailParse_RFC822_Parse_Addresses($References);
		$Address = Explode("@",$Address[0]['address']);
		#-------------------------------------------------------------------------------
		if(IsSet($Address[1]) && $Address[1] == HOST_ID && IntVal($Address[0]) == $Address[0]){
			#-------------------------------------------------------------------------------
			# проверяем наличие такого тикета
			$Columns = Array('*','(SELECT `UserID` FROM `Edesks` WHERE `EdesksMessagesOwners`.`EdeskID` = `Edesks`.`ID`) AS `EdeskUserID`');
			#-------------------------------------------------------------------------------
			$Edesk = DB_Select('EdesksMessagesOwners',$Columns,Array('UNIQ','ID'=>$Address[0]));
			switch(ValueOf($Edesk)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				break;
			case 'array':
				#-------------------------------------------------------------------------------
				$MessageID = $Address[0];
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/CheckEmail]: найдено по Headers: EdeskID = %s',$Edesk['EdeskID']));
				#-------------------------------------------------------------------------------
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// JBS-1064: проверяем нет ли в заголовке номера тикета
	if(!IsSet($MessageID) && $Subject){
		#-------------------------------------------------------------------------------
		if(Preg_Match(SPrintF('/\[%s\-\d+\]/',$KeyPrefix),$Subject,$Matches)){
			#-------------------------------------------------------------------------------
			$Array = Explode('-',$Matches[0]);
			#-------------------------------------------------------------------------------
			$EdeskID = IntVal($Array[1]);
			#-------------------------------------------------------------------------------
			# проверяем наличие такого тикета
			$Columns = Array('*','(SELECT `UserID` FROM `Edesks` WHERE `EdesksMessagesOwners`.`EdeskID` = `Edesks`.`ID`) AS `EdeskUserID`');
			#-------------------------------------------------------------------------------
			$Edesk = DB_Select('EdesksMessagesOwners',$Columns,Array('UNIQ','Where'=>SPrintF('EdeskID = %u',$EdeskID),'Limits'=>Array(0,1)));
			switch(ValueOf($Edesk)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				break;
			case 'array':
				#-------------------------------------------------------------------------------
				$MessageID = $Edesk['ID'];
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/CheckEmail]: найдено по Subject: EdeskID = %s',$Edesk['EdeskID']));
				#-------------------------------------------------------------------------------
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// ищщем юзера, по email отправителяa
	$IsUser = FALSE;
	$IsAdmin= FALSE;
	#-------------------------------------------------------------------------------
	foreach($replyTo as $Addr){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/CheckEmail]: processing as primay address: %s',$Addr));
		#-------------------------------------------------------------------------------
		$User = DB_Select('Users',Array('*'),Array('UNIQ','Where'=>SPrintF('`Email` = "%s"',$Addr)));
		#-------------------------------------------------------------------------------
		switch(ValueOf($User)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/CheckEmail]: user not found: %s',$Addr));
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			$IsUser = TRUE;
			#-------------------------------------------------------------------------------
			$IsAdmin = Permission_Check('/Administrator/',(integer)$User['ID']);
			switch(ValueOf($IsAdmin)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return ERROR | @Trigger_Error(400);
			case 'false':
				break;
			case 'true':
				#-------------------------------------------------------------------------------
				$IsAdmin = TRUE;
				#-------------------------------------------------------------------------------
				break 3;
				#-------------------------------------------------------------------------------
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			break 2;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// если получатель до сих пор не найден - надо проверить и таблицу Contacts
	if(!$IsUser){
		#-------------------------------------------------------------------------------
		// перебираем почты
		foreach($replyTo as $Addr){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/CheckEmail]: processing by Contacts table: %s',$Addr));
			#-------------------------------------------------------------------------------
			// если такой адрес есть - a их может быть много, выбираем с последней датой входа, наверное, и последний подтверждённый контакт
			$Where = SPrintF('`ID` IN (SELECT `UserID` FROM `Contacts` WHERE `Address` = "%s" AND `MethodID` = "Email" AND `IsHidden` = "no" ORDER BY `Confirmed` DESC)',$Addr);
			#-------------------------------------------------------------------------------
			$User = DB_Select('Users',Array('*'),Array('UNIQ','Where'=>$Where,'IsDesc'=>TRUE,'SortOn'=>'EnterDate','Limits'=>Array(0,1)));
			#-------------------------------------------------------------------------------
			switch(ValueOf($User)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/CheckEmail]: user not found in Contacts table: %s',$Addr));
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			case 'array':
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/CheckEmail]: contact found in Contacts table: %s',$Addr));
				#-------------------------------------------------------------------------------
				$IsUser = TRUE;
				#-------------------------------------------------------------------------------
				$IsAdmin = Permission_Check('/Administrator/',(integer)$User['ID']);
				switch(ValueOf($IsAdmin)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'exception':
					return ERROR | @Trigger_Error(400);
				case 'false':
					break;
				case 'true':
					#-------------------------------------------------------------------------------
					$IsAdmin = TRUE;
					#-------------------------------------------------------------------------------
					break 3;
					#-------------------------------------------------------------------------------
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
				break 2;
				#-------------------------------------------------------------------------------
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Regulars = Regulars();
	#-------------------------------------------------------------------------------
	if(!Preg_Match($Regulars['Email'],$fromAddress))
		Debug(SPrintF('[comp/Tasks/CheckEmail]: неверный fromAddress = %s',$fromAddress));
	#-------------------------------------------------------------------------------
	if($Settings['CreateNewUserAccounts'] && !$IsUser && Preg_Match($Regulars['Email'],$fromAddress)){
		#-------------------------------------------------------------------------------
		$Password = Comp_Load('Passwords/Generator');
		if(Is_Error($Password))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#Name Password Email
		$Array = Explode('@',$fromAddress);
		#-------------------------------------------------------------------------------
		$User = Comp_Load('www/API/UserRegister',Array('Name'=>$Array['0'],'Password'=>$Password,'Email'=>$fromAddress,'Message'=>'Автоматическая регистрация пользователя по почтовому сообщению','IsInternal'=>TRUE));
		#-------------------------------------------------------------------------------
		switch(ValueOf($User)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			#-------------------------------------------------------------------------------
			$GLOBALS['__USER']['ID']	= 100;
			$IsUser				= TRUE;
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# added by lissyara, 2013-09-10 in 13:50, for JBS-724
	if($Config['Interface']['Edesks']['DenyFoulLanguage']['IsEmailActive'] && $Config['Interface']['Edesks']['DenyFoulLanguage']['IsEvent']){
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Formats/Edesk/Message/CheckFoul',$textPlain);
		#-------------------------------------------------------------------------------
		switch(ValueOf($Comp)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			#-------------------------------------------------------------------------------
			$Event = Array(
					'UserID'	=> ($IsUser)?$User['ID']:10,
					'PriorityID'	=> 'Error',
					'Text'		=> SPrintF('Удалено почтовое сообщение с нецензурной лексикой (%s) c адреса (%s)',$Comp['Word'],$fromAddress),
					'IsReaded'	=> FALSE
					);
			$Event = Comp_Load('Events/EventInsert', $Event);
			if(!$Event)
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		case 'true':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		if($Subject){
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('Formats/Edesk/Message/CheckFoul',$Subject);
			#-------------------------------------------------------------------------------
			switch(ValueOf($Comp)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return ERROR | @Trigger_Error(400);
			case 'array':
				#-------------------------------------------------------------------------------
				$Event = Array(
						'UserID'	=> ($IsUser)?$User['ID']:10,
						'PriorityID'	=> 'Error',
						'Text'		=> SPrintF('Удалено почтовое сообщение с нецензурной темой (%s) c адреса (%s)',$Comp['Word'],$fromAddress),
						'IsReaded'	=> FALSE
						);
				$Event = Comp_Load('Events/EventInsert', $Event);
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			case 'true':
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($Settings['SaveHeaders'])
		$SaveHeaders = SPrintF("[hidden]\n%s[/hidden]\n",$mail->headers);
	#-------------------------------------------------------------------------------
	$Message = SPrintF("%s\n\n%s[size=10][color=gray]posted via email, from: %s[/color][/size]",Trim($textPlain),(IsSet($SaveHeaders))?$SaveHeaders:'',(($IsAdmin)?$User['Name']:$fromAddress));
	#-------------------------------------------------------------------------------
	$Message = Mb_Convert_Encoding($Message,'UTF-8');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# имеем 2 ситуации, задан или не задан $MessageID - соответственно, добавление в тикет или создание тикета
	if(IsSet($MessageID)){
		#-------------------------------------------------------------------------------
		#$NewUserID = (($IsUser)?$User['ID']:100);
		#-------------------------------------------------------------------------------
		# снимаем флаг у треда
		$IsUpdate = DB_Update('Edesks',Array('Flags'=>'No'),Array('ID'=>$Edesk['EdeskID']));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		# постим от админа, т.к. пост может идти от другого юзера в ответ на...
		$GLOBALS['__USER']['ID']	= 100;
		$GLOBALS['__USER']['IsAdmin']	= TRUE;
		$GLOBALS['__USER']['IsNoLogIP']	= 'Email';
		#-------------------------------------------------------------------------------
		$Params = Array('Message'=>$Message,'TicketID'=>$Edesk['EdeskID'],'UserID'=>(($IsUser)?$User['ID']:10));
		#-------------------------------------------------------------------------------
		if(IsSet($Hash))
			$Params['TicketMessageFile'] = $Hash;
		#-------------------------------------------------------------------------------
		$IsAdd = Comp_Load('www/API/TicketMessageEdit',$Params);
		if(Is_Error($IsAdd))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// ставим статус, так как постили по факту от админа, статус не встаёт
		$IsStatus = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Edesks','IsNotNotify'=>TRUE,'IsNoTrigger'=>TRUE,'StatusID'=>'Working','Comment'=>'Сообщение через электронную почту','RowsIDs'=>$Edesk['EdeskID']));
		if(Is_Error($IsAdd))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$GLOBALS['__USER']['ID']	= 100;
		$GLOBALS['__USER']['IsAdmin']	= FALSE;
		#-------------------------------------------------------------------------------
		$mailbox->deleteMail($mail->id);
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$Params = Array('Theme'=>($Subject)?$Subject:'[no message theme, v2]','Flags'=>'No','TargetGroupID'=>3100000);
		#-------------------------------------------------------------------------------
		# разное поведение, в зависимости от того - юзер это или нет
		if(!$IsUser){
			#-------------------------------------------------------------------------------
			$NewUserID = 10;
			#-------------------------------------------------------------------------------
			$Params['Message']	= $Message;
			$Params['NotifyEmail']	= Implode(',',$replyTo);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			if($IsAdmin && !$Settings['DeletePersonalEmails']){
				#-------------------------------------------------------------------------------
				$NewUserID = 10;
				$Message = SPrintF("[hidden]\nПисьмо от сотрудника '%s/%s'[/hidden]\n%s",$User['Name'],$User['Email'],$Message);
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$NewUserID = $User['ID'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$Params['Message'] = $Message;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		# загружаем файл
		if(IsSet($Hash))
			$Params['TicketMessageFile'] = $Hash;
		#-------------------------------------------------------------------------------
		# присваиваем себе нужный идентификатор юзера
		$GLOBALS['__USER']['ID']	= $NewUserID;
		$GLOBALS['__USER']['IsNoLogIP']	= 'Email';
		#-------------------------------------------------------------------------------
		# шлём сообщение на www/API/TicketEdit
		$IsAdd = Comp_Load('www/API/TicketEdit',$Params);
		#-------------------------------------------------------------------------------
		switch(ValueOf($IsAdd)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			Debug('[comp/Tasks/CheckEmail]: исключение при создании нового тикета по почтовому сообщению');
			#-------------------------------------------------------------------------------
			return ERROR | @Trigger_Error(400);
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			Debug('[comp/Tasks/CheckEmail]: ошибка при создании нового тикета по почтовому сообщению');
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		$GLOBALS['__USER']['ID'] = 100;
		#-------------------------------------------------------------------------------
		$mailbox->deleteMail($mail->id);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	# ампутируем переменную, чтоб в один тикет не напостило все письма
	UnSet($MessageID);
	#-------------------------------------------------------------------------------
	# удаляем файлы
	if(Is_Error(IO_RmDir($attachmentsDir)))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#if(SizeOf($mailbox->searchMailbox()) < 1)
#	UnSet($GLOBALS['TaskReturnInfo']);
#-------------------------------------------------------------------------------
#$mailbox->__destruct();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $ExecuteTime;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
