<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Params');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['GC']['CheckProfiles'];
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = Array(
		"`TemplateID` IN ('Client','Partner')",		// клиенты и партнёры
		"`StatusID` NOT IN ('Rejected')",		// отклонён
		);
#-------------------------------------------------------------------------------
$Profiles = DB_Select('ProfilesOwners',Array('*'),Array('Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($Profiles)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return TRUE;
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Profiles as $Profile){
		#-------------------------------------------------------------------------------
		// исключения, список через запятую
		if(In_Array($Profile['ID'],Explode(',',$Settings['Excludes']))){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/GC/CheckProfiles]: Профиля %s, "%s": пропущен, он в исключениях',$Number,$Profile['Name']));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Number = Comp_Load('Formats/Profile/Number',$Profile['ID']);
		if(Is_Error($Number))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/GC/CheckProfiles]: Проверка профиля %s, "%s"',$Number,$Profile['Name']));
		#-------------------------------------------------------------------------------
		// в зависимости от профиля это LogoURL или IconURL
		if(!IsSet($Profile['Attribs']['LogoURL']))
			$Profile['Attribs']['LogoURL'] = $Profile['Attribs']['IconURL'];
		#-------------------------------------------------------------------------------
		// проверяем картинку, тупо картинка ли это и размеры
		list($Width,$Height,$Type,$Attr) = @GetImageSize($Profile['Attribs']['LogoURL']);
		#-------------------------------------------------------------------------------
		if($Width < 64 || $Width > 640 || $Height < 64 || $Height > 640){
			#-------------------------------------------------------------------------------
			// отклоняем, неверные размеры картинки
			Debug(SPrintF('[comp/Tasks/GC/CheckProfiles]: отклонено, размеры картинки %ux%u',$Width,$Height));
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Profiles','StatusID'=>'Rejected','RowsIDs'=>$Profile['ID'],'Comment'=>SPrintF('Размер изображения не соответствует требованиям 200х150 (ссылка на изображение %ux%u)',$Width,$Height)));
			#-------------------------------------------------------------------------------
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// проверяем сайт - у нас он или нет $Profile['Attribs']['SiteURL']
		$Address = Parse_Url($Profile['Attribs']['SiteURL']);	// $Address['host']
		#-------------------------------------------------------------------------------
		$IP = GetHostByName($Address['host']);
		#-------------------------------------------------------------------------------
		if(ip_in_range($IP,$Settings['OurNetworks'])){
			#-------------------------------------------------------------------------------
			// если не опубликовано (StatusID != 'Checked'), вешаем алерт что надо опубликовать
			if($Profile['StatusID'] != 'Checked'){
				#-------------------------------------------------------------------------------
				$Event = Array('UserID'=>$Profile['UserID'],'PriorityID'=>'Billing','IsReaded'=>FALSE,'Text'=>SPrintF('Необходимо опубликовать профиль %s, "%s"',$Number,$Profile['Name']));
				$Event = Comp_Load('Events/EventInsert',$Event);
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/GC/CheckProfiles]: Профиля %s, "%s" соответствует требованиям, и уже опубликован',$Number,$Profile['Name']));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			// если опубликовано - вешаем алерт что IP адрес не наш
			if($Profile['StatusID'] == 'Checked'){
				#-------------------------------------------------------------------------------
				$Event = Array('UserID'=>$Profile['UserID'],'PriorityID'=>'Billing','IsReaded'=>FALSE,'Text'=>SPrintF('У профиля %s указан сайт %s не с нашим IP: %s',$Number,$Address['host'],$IP));
				$Event = Comp_Load('Events/EventInsert',$Event);
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				// если не опубликовано - ставим статус Rejected, и забываем про него
				Debug(SPrintF('[comp/Tasks/GC/CheckProfiles]: отклонено, у профиля %s указан сайт %s не с нашим IP: %s',$Number,$Address['host'],$IP));
				#-------------------------------------------------------------------------------
				$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Profiles','StatusID'=>'Rejected','RowsIDs'=>$Profile['ID'],'Comment'=>SPrintF('Указан сайт %s, размещённый не на нашем хостинге',$Address['host'])));
				#-------------------------------------------------------------------------------
				if(Is_Error($Comp))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}










#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// взято и доработано с https://gist.github.com/tott/7684443
#-------------------------------------------------------------------------------
/**
 * Check if a given ip is in a network
 * @param  string $ip    IP to check in IPV4 format eg. 127.0.0.1
 * @param  string $range IP/CIDR netmask eg. 127.0.0.0/24, also 127.0.0.1 is accepted and /32 assumed
 * @return boolean true if the ip is in this range / false if not.
 */
function ip_in_range($ip,$range){
	#-------------------------------------------------------------------------------
	// может быть перечисление через запятую сетей и адресов
	foreach(Explode(',',$range) as $Net){
		#-------------------------------------------------------------------------------
		$range = Trim($Net);
		#-------------------------------------------------------------------------------
		if(strpos($range, '/') == false)
			$range .= '/32';
		#-------------------------------------------------------------------------------
		// $range is in IP/CIDR format eg 127.0.0.1/24
		list($range,$netmask) = explode('/',$range,2);
		#-------------------------------------------------------------------------------
		$range_decimal = ip2long($range);
		#-------------------------------------------------------------------------------
		$ip_decimal = ip2long($ip);
		#-------------------------------------------------------------------------------
		$wildcard_decimal = pow(2,(32 - $netmask)) - 1;
		#-------------------------------------------------------------------------------
		$netmask_decimal = ~ $wildcard_decimal;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// если адрес есть в сети - возращаем TRUE
		if(($ip_decimal & $netmask_decimal) == ($range_decimal & $netmask_decimal))
			return TRUE;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// адрес в сетях нет
	return FALSE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
