<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Params');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['GC']['ResetOrdersDaysSettings'];
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# находим всех сотрудников - их заказы не окучиваем
$Users = DB_Select('Users',Array('ID','Name'),Array('Where'=>SPrintF("(SELECT `IsDepartment` FROM `Groups` WHERE `Groups`.`ID` = `Users`.`GroupID`) = 'yes' OR `ID` = 100")));
#-------------------------------------------------------------------------------
switch(ValueOf($Users)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	#-------------------------------------------------------------------------------
	$ExcludeIDs = Array();
	#-------------------------------------------------------------------------------
	foreach($Users as $User)
		if(!In_Array($User['ID'],$ExcludeIDs))
			$ExcludeIDs[] = $User['ID'];
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# выбираем всех у кого есть бесплатные дни
$Where = Array('`DaysRemainded` > 0','`Cost` = 0 OR `Discont` = 1');
#-------------------------------------------------------------------------------
$OrdersConsider = DB_Select('OrdersConsider',Array('OrderID','SUM(`DaysRemainded`) AS `SumDaysRemainded`',),Array('GroupBy'=>'OrderID','Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($OrdersConsider)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return TRUE;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($OrdersConsider as $OrderConsider){
	#-------------------------------------------------------------------------------
	if($OrderConsider['SumDaysRemainded'] <= IntVal($Settings['ResetDaysTo']))
		continue;
	#-------------------------------------------------------------------------------
	$OrderID = $OrderConsider['OrderID'];
	#Debug(SPrintF('[comp/Tasks/GC/ResetOrdersDays]: OrderID = %s; DaysRemainded = %s',$OrderID,$OrderConsider['SumDaysRemainded']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# Заказы этого клиента, только те для которых есть учёт в таблице OrdersConsider
	$Where = Array(SPrintF('`UserID` = (SELECT `UserID` FROM `OrdersOwners` WHERE `ID` = %u)',$OrderID),'(SELECT `OrderID` FROM `OrdersConsider` WHERE `OrdersConsider`.`OrderID` = `OrdersOwners`.`ID` LIMIT 1) IS NOT NULL');
	#-------------------------------------------------------------------------------
	$Orders = DB_Select('OrdersOwners',Array('ID','UserID','StatusID'),Array('Where'=>$Where));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Orders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Order = Current($Orders);
	#-------------------------------------------------------------------------------
	$UserID = $Order['UserID'];
	#-------------------------------------------------------------------------------
	# если сотрудник или исключение - ничего не делаем
	if(In_Array($UserID,$ExcludeIDs))
		continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Array = Array();
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		if($Order['StatusID'] == 'Suspended'){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/GC/ResetOrdersDays]: UserID = %s; OrderID = %s в статусе Suspended, все заказы пользователя пропускаются',$UserID,$Order['ID']));
			#-------------------------------------------------------------------------------
			$ExcludeIDs[] = $UserID;
			#-------------------------------------------------------------------------------
			continue 2;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Array[] = $Order['ID'];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[comp/Tasks/GC/ResetOrdersDays]: OrderIDs = %s',Implode(',',$Array)));
	#-------------------------------------------------------------------------------
	# ищщем, есть ли у него заказы за денежки
	$Where = Array('`Cost` > 0','`Discont` < 1','`DaysRemainded` > 0',SPrintF('`OrderID` IN (%s)',Implode(',',$Array)));
	#-------------------------------------------------------------------------------
	$Count = DB_Count('OrdersConsider',Array('Where'=>$Where));
	if(Is_Error($Count))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if($Count)
		continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[comp/Tasks/GC/ResetOrdersDays]: UserID = %s; OrderIDs = %s',$UserID,Implode(',',$Array)));
	#-------------------------------------------------------------------------------
	# а ещё у него могут быть домены... которые учитываются иначе ... а ещё могут быть услуги настраиваемые вручную...
	$Where = Array('`StatusID` = "Suspended" OR `StatusID` = "Active"',SPrintF('`UserID` = %u',$UserID),SPrintF('`ID` NOT IN (%s)',Implode(',',$Array)));
	#-------------------------------------------------------------------------------
	$Count = DB_Count('OrdersOwners',Array('Where'=>$Where));
	if(Is_Error($Count))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[comp/Tasks/GC/ResetOrdersDays]: OrdersOwners Count = %s',$Count));
	#-------------------------------------------------------------------------------
	if($Count)
		continue;
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/GC/ResetOrdersDays]: Изменено число оставшихся дней (%u->%u) для заказa OrderID = %s; юзер = %s',$OrderConsider['SumDaysRemainded'],$Settings['ResetDaysTo'],$OrderID,$UserID));
	#-------------------------------------------------------------------------------
	#----------------------------------TRANSACTION----------------------------------
	if(Is_Error(DB_Transaction($TransactionID = UniqID('ResetOrdersDays'))))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# удаляем весь учёт для заказа, где скидка 100% или цена 0
	$IsDelete = DB_Delete('OrdersConsider',Array('Where'=>SPrintF('`OrderID` = %u',$OrderID)));
	if(Is_Error($IsDelete))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	# втыкаем новый учёт, на нужное число дней
	$IOrdersConsider = Array('OrderID'=>$OrderID,'DaysReserved'=>IntVal($Settings['ResetDaysTo']),'Cost'=>0);
	#-------------------------------------------------------------------------------
	$OrdersConsiderID = DB_Insert('OrdersConsider',$IOrdersConsider);
	if(Is_Error($OrdersConsiderID))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$IsUpdate = DB_Update('OrdersConsider',Array('DaysConsidered'=>0),Array('ID'=>$OrdersConsiderID));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	# снимаем галку про автопродление
	$IsUpdate = DB_Update('Orders',Array('IsAutoProlong'=>FALSE),Array('ID'=>$OrderID));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(Is_Error(DB_Commit($TransactionID)))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($Settings['IsEvent']){
		#-------------------------------------------------------------------------------
		$Event = Array('Text'=>SPrintF('Изменено число оставшихся дней (%u->%u) для услуги #%u',$OrderConsider['SumDaysRemainded'],$Settings['ResetDaysTo'],$OrderID),'PriorityID'=>'Error','IsReaded'=>FALSE,'UserID'=>$UserID);
		#-------------------------------------------------------------------------------
		$Event = Comp_Load('Events/EventInsert', $Event);
		if(!$Event)
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
