<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Task');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('libs/Tree.php','libs/Upload.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// ограничение, сколько файлов за итерацию окучиваем
$Limit = 1000;
#-------------------------------------------------------------------------------
// таблицы, которые переносим
$Tables = Array('Users','EdesksMessages','Contracts','ContractsEnclosures','Invoices','Profiles','Services');
#-------------------------------------------------------------------------------
// перебираем таблицы
foreach($Tables as $Table){
	#-------------------------------------------------------------------------------
	// проверяем таблицу, перемещена или нет
	$Status = DB_Select('Config',Array('*'),Array('UNIQ','Where'=>SPrintF('`HostID` = "billing" AND `Param` = "MigrateFiles%s"',$Table)));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Status)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		#-------------------------------------------------------------------------------
		// максимальный иденфтикатор из таблицы
		$Max = DB_Select($Table,Array('MAX(`ID`) AS `ID`'),Array('UNIQ'));
		if(Is_Error($Max))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		// пихаем его в базу + 1, т.к. при работе будем на каждый файл обновлять это поле
		$IsInsert = DB_Insert('Config',Array('HostID'=>'billing','Param'=>SPrintF('MigrateFiles%s',$Table),'Value'=>($Max['ID']+1)));
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		// его же передаём дальше, для работы
		$Status = Array('Value'=>($Max['ID']+1),'ID'=>$IsInsert);
		#-------------------------------------------------------------------------------
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// если значение ноль - то все файлы окучены
	if($Status['Value'] === 0){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/MoveFiles]: все файлы из таблицы (%s) перемещены, пропускаем',$Table));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// выбираем данные из таблицы
	$Rows = DB_Select($Table,Array('*'),Array('Where'=>Array(SPrintF('`ID` < %u',$Status['Value'])),'SortOn'=>'ID','IsDesc'=>TRUE,'Limits'=>Array(0,$Limit)));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Rows)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		#-------------------------------------------------------------------------------
		// ничего не найдено. проставляем ноль как максимальный иденфтикатор, переходим к следующей таблице
		$IsUpdate = DB_Update('Config',Array('Value'=>0),Array('ID'=>$Status['ID']));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/MoveFiles]: не найдено неокученных файлов в таблице (%s), продолжаем со следущей',$Table));
		#-------------------------------------------------------------------------------
		continue 2;
		#-------------------------------------------------------------------------------
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	foreach($Rows as $Row){
		#-------------------------------------------------------------------------------
		// перебираем идентифкаторы, проверяем наличие файла
		$Path = oldGetFilePath($Table,$Row['ID']);
		#-------------------------------------------------------------------------------
		if(!File_Exists($Path['FilePath']))
			continue;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$File = Array('TableID'=>$Table,'RowID'=>$Row['ID']);
		#-------------------------------------------------------------------------------
		// имя файла, зависит от таблицы
		$File['Name'] = SPrintF('%s%s.html',$Table,$Row['ID']);
		#-------------------------------------------------------------------------------
		if($Table == 'Services' || $Table == 'Users')
			$File['Name'] = SPrintF('%s%s.jpeg',$Table,$Row['ID']);
		#-------------------------------------------------------------------------------
		if($Table == 'EdesksMessages')
			$File['Name'] = $Row['FileName'];
		#-------------------------------------------------------------------------------
		if($Table == 'Profiles')
			$File['Name'] = SPrintF('%s%s.%s',$Table,$Row['ID'],$Row['Format']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// размер файла
		$File['Size'] = FileSize($Path['FilePath']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// тип файла
		$File['Mime'] = Mime_Content_Type($Path['FilePath']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// дата создания
		$FStat = Stat($Path['FilePath']);
		#-------------------------------------------------------------------------------
		$File['CreateDate'] = $FStat['mtime'];
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// втыкаем данные в базу
		$IsInsert = DB_Insert('Files',$File);
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
                // путь куда сохраняется файл
		$FilePaths = GetFilePath($IsInsert);
		#-------------------------------------------------------------------------------
		// создаём директорию
		if(!File_Exists($FilePaths['FileDir']))
			if(!MkDir($FilePaths['FileDir'], 0700, true))
				return new gException('CANNOT_CREATE_DIRECTORY','Не удалось создать директорию для сохранения файла');
		#-------------------------------------------------------------------------------
		// перемещаем файл
		if(!ReName($Path['FilePath'],$FilePaths['FilePath']))
			return new gException('CANNOT_RENAME_FILE','Не удалось переместить файл');
		#-------------------------------------------------------------------------------
		// пробуем удалить старую директорию
		@RmDir($Path['FileDir']);
		#-------------------------------------------------------------------------------
		// и выше уровнем тоже пробуем
		@RmDir(DirName($Path['FileDir']));
		#-------------------------------------------------------------------------------
		// и ещё выше уровнем тоже пробуем
		@RmDir(DirName(DirName($Path['FileDir'])));
		#-------------------------------------------------------------------------------
		// теоретически - выше больше нет
		@RmDir(DirName(DirName(DirName($Path['FileDir']))));
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$GLOBALS['TaskReturnInfo'] = Array(SPrintF('%s/%s',$Table,$Row['ID']));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// проставляем последний проверенный идентифкатор в базу
	$IsUpdate = DB_Update('Config',Array('Value'=>$Row['ID']),Array('ID'=>$Status['ID']));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/MoveFiles]: последний окученный иденфтикатор (%s/%s)',$Table,$Row['ID']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// следущий перезапуск через
	return 20;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// все таблицы окучены, таск выполнен
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
