<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['NotConfirmedInvoices'];
#-------------------------------------------------------------------------------
$ExecuteTime = Comp_Load('Formats/Task/ExecuteTime',Array('ExecutePeriod'=>$Settings['ExecutePeriod']));
if(Is_Error($ExecuteTime))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return 3600;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Invoices = DB_Select('InvoicesOwners',Array('*','(SELECT LENGTH(`ConfirmedWas`) FROM `Users` WHERE `ID` = `InvoicesOwners`.`UserID`) AS `Confirmed`'),Array('Where'=>Array('`StatusID` = "NotConfirmed"')));
#-------------------------------------------------------------------------------
switch(ValueOf($Invoices)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $ExecuteTime;
case 'array':
	#-------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'] = Array('Confirmed'=>Array(),'NotConfirmed'=>Array(0=>0));
	#-------------------------------------------------------------------------------
	foreach($Invoices as $Invoice){
		#-----------------------------------------------------------------------------
		$Number = Comp_Load('Formats/Invoice/Number',$Invoice['ID']);
		if(Is_Error($Number))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(IntVal($Invoice['Confirmed']) < 6){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/NotConfirmedInvoices]: Счёт #%s пропущен, пользователь не подтверждён',$Number));
			#-------------------------------------------------------------------------------
			// счётчик увеличиваем
			$GLOBALS['TaskReturnInfo']['NotConfirmed'][0] ++;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			/* вставка. если три часа ночи, оповещаем юзеров, один раз. */
			if(Date('G') != 3)
				continue;
			#-------------------------------------------------------------------------------
			$CacheID = SPrintF('NotConfirmedInvoices_%s',$Number);
			#-------------------------------------------------------------------------------
			$Result = CacheManager::get($CacheID);
			#-------------------------------------------------------------------------------
			if($Result)
				continue;
			#-------------------------------------------------------------------------------
			$IsSend = NotificationManager::sendMsg(new Message('NotConfirmedInvoices',(integer)$Invoice['UserID'],Array('Theme'=>SPrintF('Неподтверждённый счёт #%d',$Invoice['ID']),'InvoiceID'=>$Invoice['ID'])));
			#-------------------------------------------------------------------------------
			switch(ValueOf($IsSend)){
			case 'true':
				#-------------------------------------------------------------------------------
				$Event = Array(
						'UserID'	=> $Invoice['UserID'],
						'PriorityID'	=> 'Billing',
						'Text'		=> SPrintF('Уведомление о неподтверждённом счёте #%d',$Invoice['ID'])
						);
				$Event = Comp_Load('Events/EventInsert',$Event);
				#-------------------------------------------------------------------------------
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			case 'exception':
				#-------------------------------------------------------------------------
				$Event = Array(
						'UserID'	=> $Invoice['UserID'],
						'PriorityID'	=> 'Billing',
						'Text'		=> SPrintF('Уведомление о неоплаченном счёте #%d не доставлено. Не удалось оповестить пользователя ни одним из методов.',$Invoice['ID'])
						);
				#-------------------------------------------------------------------------------
				$Event = Comp_Load('Events/EventInsert',$Event);
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			default:
				return ERROR | @Trigger_Error(500);
			}
			#-------------------------------------------------------------------------------
			// кэшируем на час, что уведомление о этом счёте отправлено юзеру
			CacheManager::add($CacheID,Time(),3600);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// вставка #2. если счёту более года, проверяем есть ли услуги и проводим/списываем
			if($Invoice['StatusDate'] < Time() - 365*24*60*60){
				#-------------------------------------------------------------------------------
				# проверяем наличие заказов
				$Count = DB_Count('OrdersOwners',Array('Where'=>SPrintF("`UserID` = %u",$Invoice['UserID'])));
				if($Count){
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[comp/Tasks/NotConfirmedInvoices]: Счёт #%s пропущен, у клиента есть услуги',$Number));
					#-------------------------------------------------------------------------------
				}else{
					#-------------------------------------------------------------------------------
					// ставим глобальную переменную, разрешвем проводить неподтверждённые счета
					$GLOBALS['TmpAllowNotConfirmed'] = TRUE;
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[comp/Tasks/NotConfirmedInvoices]: Проводим счёт #%s, у клиента нет услуг',$Number));
					#-------------------------------------------------------------------------------
					$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Invoices','StatusID'=>'Payed','RowsIDs'=>$Invoice['ID'],'Comment'=>'Пользователь НЕ подтверждён более года'));
					#-------------------------------------------------------------------------------
					switch(ValueOf($Comp)){
					case 'error':
						return ERROR | @Trigger_Error(500);
					case 'exception':
						return ERROR | @Trigger_Error(400);
					case 'array':
						break;
					default:
						return ERROR | @Trigger_Error(101);
					}
					#-------------------------------------------------------------------------------
					#-------------------------------------------------------------------------------
					// списываем балланс всех договоров в ноль
					# выбираем договора юзера с баллансом больше нуля
					$Where = Array(SPrintF('`UserID` = %u',$Invoice['UserID']),'`Balance` > 0');
					#-------------------------------------------------------------------------------
					$Contracts = DB_Select('Contracts',Array('ID','TypeID','Customer','Balance'),Array('Where'=>$Where));
					#-------------------------------------------------------------------------------
					switch(ValueOf($Contracts)){
					case 'error':
						return ERROR | @Trigger_Error(500);
					case 'exception':
						#-------------------------------------------------------------------------------
						Debug(SPrintF('[comp/Tasks/NotConfirmedInvoices]: Договоров с положительным баллансом не найдено'));
						#-------------------------------------------------------------------------------
						continue 2;
						#-------------------------------------------------------------------------------
					case 'array':
						break;
					default:
						return ERROR | @Trigger_Error(101);
					}
					#-------------------------------------------------------------------------------
					// перебираем договора клиента, с баллансом более нуля
					foreach($Contracts as $Contract){
						#-------------------------------------------------------------------------------
						Debug(SPrintF('[comp/Tasks/NotConfirmedInvoices]: юзер (%s), договор #%u, балланс %s',$Invoice['UserID'],$Contract['ID'],$Contract['Balance']));
						#-------------------------------------------------------------------------------
						#-------------------------------------------------------------------------------
						$IsUpdate = Comp_Load('www/Administrator/API/PostingMake',Array('ContractID'=>$Contract['ID'],'Summ'=>-$Contract['Balance'],'ServiceID'=>2100,'Comment'=>SPrintF('Хранение клиентской информации за период %s, клиент не подтверждён',Date('Y/m',MkTime(4,0,0,Date('n')-1,5,Date('Y'))))));
						#-------------------------------------------------------------------------------
						switch(ValueOf($IsUpdate)){
						case 'error':
							return ERROR | @Trigger_Error(500);
						case 'exception':
							return ERROR | @Trigger_Error(400);
						case 'array':
							break;
						default:
							return ERROR | @Trigger_Error(101);
						}
						#-------------------------------------------------------------------------------
					}
					#-------------------------------------------------------------------------------
					// убираем глобальную переменную
					UnSet($GLOBALS['TmpAllowNotConfirmed']);
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'Invoices','StatusID'=>'Payed','RowsIDs'=>$Invoice['ID'],'Comment'=>'Пользователь подтверждён'));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Comp)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return ERROR | @Trigger_Error(400);
			case 'array':
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			$GLOBALS['TaskReturnInfo']['Confirmed'][] = $Number;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:                                                
	return ERROR | @Trigger_Error(101);             
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $ExecuteTime;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
