<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('modules/Authorisation.mod')))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$OrderID	= (integer) @$Args['OrderID'];
$IsAutoProlong	= (boolean) @$Args['IsAutoProlong'];
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Columns = Array('*','(SELECT `NameShort` FROM `Services` WHERE `OrdersOwners`.`ServiceID`=`Services`.`ID`) AS `NameShort`');
#-------------------------------------------------------------------------------
$Order = DB_Select('OrdersOwners', $Columns, Array('UNIQ','ID'=>$OrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($Order)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	#---------------------------------------------------------------------------
	$IsPermission = Permission_Check('ServiceAutoProlongation',(integer)$__USER['ID'],(integer)$Order['UserID']);
	#---------------------------------------------------------------------------
	switch(ValueOf($IsPermission)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'false':
		return ERROR | @Trigger_Error(700);
	case 'true':
		#-------------------------------------------------------------------------------
		$IsUpdate = DB_Update('Orders',Array('IsAutoProlong'=>$IsAutoProlong),Array('ID'=>$OrderID));
		#-------------------------------------------------------------------------------
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Number = Comp_Load('Formats/Order/Number',$Order['ID']);
		if(Is_Error($Number))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Text = SPrintF("%s автопродление для заказа #%s (%s)",(($IsAutoProlong)?'Включено':'Отключено'),$Number,$Order['NameShort']);
		#-------------------------------------------------------------------------------
		$Event = Array(
				'UserID'        => $__USER['ID'],
				'PriorityID'    => 'Hosting',
				'Text'          => $Text
				);
		$Event = Comp_Load('Events/EventInsert',$Event);
		if(!$Event)
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return Array('Status'=>'Ok');
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------


?>
