<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
#-------------------------------------------------------------------------------
#if(Is_Error(System_Load('modules/Authorisation.mod')))
#	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$ContactID	= (integer) @$Args['ContactID'];
$TypeID		=  (string) @$Args['TypeID'];
$Code		=  (string) @$Args['Code'];
$IsConfirm	= (boolean) @$Args['IsConfirm'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Code || !$TypeID || !$ContactID)
	return new gException('NO_SUBSCRIBE_PARAMS','Отсутствуют параметры отключения уведомлений');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём даные, по контакту
$Contact = DB_Select('Contacts',Array('UserID','MethodID','Address','(SELECT `UniqID` FROM `Users` WHERE `Users`.`ID` = `Contacts`.`UserID`) AS `UniqID`'),Array('UNIQ','ID'=>$ContactID));
switch(ValueOf($Contact)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(100);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// проверяем подтверждение
$uCode = Hash('sha256',SPrintF('%s%s%s',Hash('sha256',$ContactID),Hash('sha256',$TypeID),Hash('sha256',$Contact['UniqID'])));
#-------------------------------------------------------------------------------
if($uCode != $Code)
	return new gException('OLD_SUBSCRIBE_LINK','Неверные параметры. Вероятно, ссылка уже устарела');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// проверяем наличие такого типа уведомления
$Config = Config();
#-------------------------------------------------------------------------------
$Types = $Config['Notifies']['Types'];
#-------------------------------------------------------------------------------
if(!IsSet($Types[$TypeID]) || !$Types[$TypeID]['IsActive'])
	return new gException('SUBSCRIBE_TYPE_NOT_FOUND_OR_DISABLED','Тип оповещения не существует, или отключён');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// проверяем, не отписан ли от этого уведомления
$Count = DB_Count('Notifies',Array('Where'=>SPrintF('`ContactID` = %u AND `TypeID` = "%s"',$ContactID,DB_Escape($TypeID))));
if(Is_Error($Count))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($Count)
	return new gException('ALREADY_UNSUBSCRIBED',SPrintF("Вы уже отписаны от оповещений %s / %s",$Contact['Address'],$Types[$TypeID]['Name']));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$IsConfirm){
	#-------------------------------------------------------------------------------
	// было: первый заход, показываем подтверждение отписки
	return new gException('NO_UNSUBSCRIBE_PARAMS','Не переданы параметры отписки от уведомлений');
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	// отпарвка формы, всё проверно выше, вставляем данные в БД
	$INotify = Array('ContactID'=>$ContactID,'TypeID'=>DB_Escape($TypeID));
	#-------------------------------------------------------------------------------
	$IsInsert = DB_Insert('Notifies',$INotify);
	if(Is_Error($IsInsert))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Types) as $Key){
		#-------------------------------------------------------------------------------
		if(IsSet($Types[$Key]['Title']))
			$Title = $Types[$Key]['Title'];
		#-------------------------------------------------------------------------------
		$Name = $Types[$Key]['Name'];
		#-------------------------------------------------------------------------------
		if($Key == $TypeID)
			break;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Event = Array('UserID'=>$Contact['UserID'],'PriorityID'=>'Billing','Text'=>SPrintF('Отключены оповещения для %s / %s / %s',$Contact['Address'],$Title,$Name));
	#-------------------------------------------------------------------------------
	$Event = Comp_Load('Events/EventInsert',$Event);
	if(!$Event)
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Array('Status'=>'Ok');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------


?>
