<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
// используется в отключении проверки каптчи
$IsInternal = IsSet($Args);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$Email		=  (string) @$Args['Email'];
$Password	=  (string) @$Args['Password'];
$Name		=  (string) @$Args['Name'];
$Protect	= (integer) @$Args['Protect'];
$Message	=  (string) @$Args['Message'];
$RemoteIP	=  (string) @$Args['RemoteIP'];
#$IsInternal	= (boolean) @$Args['IsInternal'];
$ExternalID	=  (string) @$Args['ExternalID'];
$Eval		=  (string) @$Args['Eval'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('classes/Session.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Debug(SPrintF('[www/API/UserRegister]: IsInternal = %s; ExternalID = %s',($IsInternal)?'TRUE':'FALSE',$ExternalID));
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Interface']['User']['Register'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Regulars = Regulars();
#-------------------------------------------------------------------------------
$Email = StrToLower(Trim($Email));
#-------------------------------------------------------------------------------
if(!Preg_Match($Regulars['Email'],$Email))
	return new gException('WRONG_EMAIL','Неверно указан электронный адрес');
#-------------------------------------------------------------------------------
// причёсываем имя - лезут абдурахманы всякие со спецсимволами
$Name  = Preg_Replace('#[^\\pL\pP\pPo\d]+#u', ' ', $Name);
#-------------------------------------------------------------------------------
if(!Preg_Match($Regulars['UserName'],$Name))
	return new gException('WRONG_USER_NAME','Вы ввели неверное имя');
#-------------------------------------------------------------------------------
$Count = DB_Count('Users',Array('Where'=>SPrintF("`Email` = '%s'",$Email)));
if(Is_Error($Count))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($Count)
	return new gException('USER_EXISTS','Пользователь с таким электронным адресом уже существует в системе');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!Preg_Match($Regulars['Password'],$Password))
	return new gException('WRONG_PASSWORD','Неверно указан новый пароль');
#-------------------------------------------------------------------------------
$IsCheck = Comp_Load('Passwords/Checker',$Password,'Register');
if(Is_Error($IsCheck))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(Is_Exception($IsCheck))
	return $IsCheck;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if((!IsSet($GLOBALS['__USER']) && $_SERVER['REMOTE_ADDR'] != $_SERVER['SERVER_ADDR']) && $Settings['Captcha']['IsActive'] && !$IsInternal){
	#-------------------------------------------------------------------------------
	$Array = Explode(',',$Settings['Captcha']['ExcludeIPs']);
	#-------------------------------------------------------------------------------
	foreach($Array as $IP)
		if(Trim($IP) == $_SERVER['REMOTE_ADDR'])
			$Exclude = TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/API/UserRegister]: REMOTE_ADDR = %s; SERVER_ADDR = %s',$_SERVER['REMOTE_ADDR'],$_SERVER['SERVER_ADDR']));
	#-------------------------------------------------------------------------------
	if(!IsSet($Exclude)){
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Protect',$Protect);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if(!$Comp)
			return new gException('WRONG_PROTECT_CODE','Введенный Вами защитный код неверен, либо устарел. Пожалуйста, введите его заново.');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Params = Array('IsAutoRegistered'=>($IsInternal)?TRUE:FALSE);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$IUser = Array(
		'Name'			=> $Name,
		'Sign'			=> SPrintF('%s %s.',$Settings['Sign'],$Name),
		'Watchword'		=> Md5($Password),
		'UniqID'		=> Md5(UniqID()),
		'Email'			=> $Email,
		'LayPayMaxDays'		=> $Settings['LayPayMaxDays'],
		'LayPayMaxSumm'		=> $Settings['LayPayMaxSumm'],
		'LayPayThreshold'	=> $Settings['LayPayThreshold'],
		'Params'		=> $Params,
		'ConfirmedWas'		=> Array(),
		);
#-------------------------------------------------------------------------------
$Group = DB_Select('Groups','ID',Array('UNIQ','Where'=>"`IsDefault` = 'yes'"));
#-------------------------------------------------------------------------------
switch(ValueOf($Group)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('DEFAULT_GROUP_NOT_FOUND','Группа по умолчанию не найдена');
case 'array':
	#-------------------------------------------------------------------------------
	$IUser['GroupID'] = $Group['ID'];
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(DB_Transaction($TransactionID = UniqID('UserRegister'))))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$UserID = DB_Insert('Users',$IUser);
if(Is_Error($UserID))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// вносим даные в таблицу контактов
$IContact = Array(
		'CreateDate'	=> Time(),
		'UserID'	=> $UserID,
		'MethodID'	=> 'Email',
		'Address'	=> $Email,
		'IsPrimary'	=> TRUE,
		'IsActive'	=> TRUE,
		'ExternalID'	=> $ExternalID
		);
#-------------------------------------------------------------------------------
$ContactID = DB_Insert('Contacts',$IContact);
if(Is_Error($ContactID))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# TODO исправляем юзера - проверить что это реально надо, и надо тут
$Comp = Comp_Load('Tasks/RecoveryUsers',NULL,$UserID);
#-------------------------------------------------------------------------------
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$OwnerID = 0;
#-------------------------------------------------------------------------------
if(IsSet($_COOKIE['OwnerID']))
	$OwnerID = $_COOKIE['OwnerID'];
#-------------------------------------------------------------------------------
if($OwnerID){
	#-------------------------------------------------------------------------------
	$Owner = DB_Select('Users',Array('ID','GroupID','IsInheritGroup'),Array('UNIQ','ID'=>$OwnerID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Owner)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$UUpdate = Array(
				'OwnerID'	=> $OwnerID,
				'IsManaged'	=> IsSet($_COOKIE['IsManaged'])
				);
		#-------------------------------------------------------------------------------
		if($Owner['IsInheritGroup'])
			$UUpdate['GroupID'] = $Owner['GroupID'];
		#-------------------------------------------------------------------------------
		$IsUpdate = DB_Update('Users',$UUpdate,Array('ID'=>$UserID));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Init = Comp_Load('Users/Init',$UserID);
if(Is_Error($Init))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('www/API/ContractMake',Array('TypeID'=>'Default'));
#-------------------------------------------------------------------------------
switch(ValueOf($Comp)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$ContractID = $Comp['ContractID'];
#-------------------------------------------------------------------------------
$IsSend = NotificationManager::sendMsg(new Message('UserRegister',(integer)$UserID,Array('Password'=>$Password)));
#-------------------------------------------------------------------------------
switch(ValueOf($IsSend)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$Event = Array('UserID'=>1,'Text'=>SPrintF('%s (%s)',($Message)?$Message:'Зарегистрирован пользователь',$Email));
$Event = Comp_Load('Events/EventInsert',$Event);
if(!$Event)
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(Is_Error(DB_Commit($TransactionID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// JBS-1300 - высылаем письмо о подтверждении контактного почтового адреса, если это не по письму регистрация
// нефига ботам друг с другом переписываться
$IsConfirm = TRUE;
#-------------------------------------------------------------------------------
if($IsInternal)
	$IsConfirm = FALSE;
#-------------------------------------------------------------------------------
if($ExternalID)
	$IsConfirm = FALSE;
#-------------------------------------------------------------------------------
if($IsConfirm){
	#-------------------------------------------------------------------------------
	$Confirm = Array('Value'=>$Email,'ContactID'=>$ContactID,'Method'=>'Email','UserID'=>$UserID);
	#-------------------------------------------------------------------------------
	$Confirm = Comp_Load('www/API/Confirm',$Confirm);
	if(!$Confirm)
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	// внутренний запрос, возвращаем ОК и всё
	return Array('Status'=>'Ok','UserID'=>$UserID,'ID'=>$UserID);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$SessionID = (IsSet($_COOKIE['SessionID']) && StrLen($_COOKIE['SessionID'])?$_COOKIE['SessionID']:UniqID('SESSION'));
#-------------------------------------------------------------------------------
$Session = new Session($SessionID);
#-------------------------------------------------------------------------------
$IsLoad = $Session->Load();
if(Is_Error($IsLoad))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$IsLoad){
	#-------------------------------------------------------------------------------
	$Session->Data['UsersIDs'] = Array();
	#-------------------------------------------------------------------------------
	if(!SetCookie('SessionID',$SessionID,Time() + 2678400,'/',SPrintF('.%s',HOST_ID)))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if(!SetCookie('Email',$Email,Time() + 2678400,'/',SPrintF('.%s',HOST_ID)))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// вход через IP где без каптчи - вероятно сайт, может быть передан реальный IP
$IP = (In_Array(@$_SERVER['REMOTE_ADDR'],Explode(',',$Settings['Captcha']['ExcludeIPs'])) && $RemoteIP)?$RemoteIP:@$_SERVER['REMOTE_ADDR'];
#-------------------------------------------------------------------------------
// логгируем IP
$Comp = Comp_Load('Users/LogIP',$UserID,$IP,IsSet($GLOBALS['_SERVER']['HTTP_USER_AGENT'])?$GLOBALS['_SERVER']['HTTP_USER_AGENT']:'');
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(IsSet($GLOBALS['__USER']['IsEmulate']) && $GLOBALS['__USER']['IsEmulate']){
	#-------------------------------------------------------------------------------
	$IsUpdated = DB_Update('Users',Array('EnterDate'=>Time(),'EnterIP'=>$IP),Array('ID'=>$UserID));
	if(Is_Error($IsUpdated))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$GLOBALS['__USER']['service_aaa']['NpiIpAddress'] = $IP;
#-------------------------------------------------------------------------------
if(!SORM_add('user',$GLOBALS['__USER']['service_aaa'],Array('ContractID'=>$ContractID,'ActionTypeId'=>'UserRegister','UserId'=>$UserID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Array_UnShift($Session->Data['UsersIDs'],$UserID);
#-------------------------------------------------------------------------------
if(Is_Error($Session->Save()))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','SessionID'=>$SessionID,'User'=>$Init,'Home'=>SPrintF('/%s/Home',$Init['InterfaceID']),'ContractID'=>$ContractID,'UserID'=>$UserID,'ID'=>$UserID,'Home'=>($Eval?SPrintF('/v2/Home?Eval=%s',$Eval):'/v2/Home'));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
