<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$Sign		= (string) @$Args['sig'];	// секретный ключ
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/HTTP.php','libs/Server.php','libs/Viber.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = SelectServerSettingsByTemplate('Viber');
#-------------------------------------------------------------------------------
switch(ValueOf($Settings)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('NO_VIBER_SERVERS','Отсуствует настроенный сервер Viber');
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Viber = new Viber($Settings['Params']['Token']);
#-------------------------------------------------------------------------------
//$Viber->set_webhook();
#-------------------------------------------------------------------------------
// вайбер на вебхук шлёт данные постом, json. читаем их.
$Body = File_Get_Contents('php://input');
#-------------------------------------------------------------------------------
#Debug(SPrintF('[comp/www/API/Viber]: Body = %s',print_r($Body,true)));
// проверяем наличие подписи
if(!$Sign)
	return new gException('SIGN_EMPTY','Подпись ключ отсутствует');
#-------------------------------------------------------------------------------
// убеждаемся что сообщение пришло от вибера
if(!$Viber->CheckSign($Body,$Sign))
	return new gException('SECRET_KEY_NOT_MATCH','Секретный ключ не совпадает с ключом из настроек');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Data = Json_Decode($Body,TRUE);
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/www/API/Viber]: Data = %s',print_r($Data,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// смотрим что пришло
if($Data['event'] != 'message'){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/API/Viber]: Data[event] = %s, пропускаем',$Data['event']));
	#-------------------------------------------------------------------------------
	return Array('Status'=>'Ok');
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём сообщение или примечание, если оно есть
if(IsSet($Data['message']['text']) && $Data['message']['text']){
	#-------------------------------------------------------------------------------
	$Message = $Data['message']['text'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Message = 'сообщение без текста';
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$SenderID = $Data['sender']['id']; // вернет ID отправителя
#-------------------------------------------------------------------------------
if(!$SenderID)
	return new gException('NO_SENDER_ID','Не удалось определить отправителя сообщения');
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/www/API/Viber]: входящее сообщение от SenderID = %s; name = %s',$SenderID,(IsSet($Data['sender']['name'])?$Data['sender']['name']:'')));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// возможно это код подтверждения, разбираем текст на слова, слова проверяем как код подтверждения
$Words = Explode(" ",$Message);
$wCount = 0;
#-------------------------------------------------------------------------------
foreach($Words as $Word){
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[comp/www/API/Viber]: Word = %s',$Word));
	#-------------------------------------------------------------------------------
	// удаляем дефисы
	$Word = Preg_Replace('/\D/','',$Word);
	#-------------------------------------------------------------------------------
	if(StrLen($Word) < 6 || StrLen($Word) > 10)
		continue;
	#-------------------------------------------------------------------------------
	// если это число - ищем по базе
	if(IntVal($Word) != 0){
		#-------------------------------------------------------------------------------
		// могут быть ведущие нули в коде
		$Count = DB_Count('Contacts',Array('Where'=>SPrintF('`Confirmation` = "%s"',$Word)));
		if(Is_Error($Count))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if($Count){
			#-------------------------------------------------------------------------------
			$Contact = DB_Select('Contacts',Array('UserID','Address','ExternalID'),Array('UNIQ','Where'=>SPrintF('`Confirmation` = "%s"',$Word)));
			if(!Is_Array($Contact))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			// код найден в базе, проставляем что контакт подтверждён
			$IsUpdated = DB_Update('Contacts',Array('Confirmed'=>Time(),'Confirmation'=>'','ExternalID'=>$SenderID,'IsActive'=>TRUE),Array('Where'=>SPrintF('`Confirmation` = "%s"',$Word)));
			if(Is_Error($IsUpdated))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Event = Array('UserID'=>$Contact['UserID'],'PriorityID'=>'Billing','Text'=>SPrintF('Контактный адрес (%s/%s) подтверждён через "%s"',$Contact['Address'],$SenderID,$Config['Notifies']['Methods']['Viber']['Name']));
			#-------------------------------------------------------------------------------
			$Event = Comp_Load('Events/EventInsert',$Event);
			if(!$Event)
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// шлём сообщение о успешной активации
			if(!$Viber->MessageSend($SenderID,$Settings['Params']['ConfirmSuccess']))
				return new gException('ERROR_SEND_SUCCESS_ACTIVATE_MESSAGE','Ошибка отправки сообщения о успешной активации на сервер Viber');
			#-------------------------------------------------------------------------------
			// шлём сообщение со справочной информацией
			if(!$Viber->MessageSend($SenderID,$Settings['Params']['StubMessage']))
				return new gException('ERROR_SEND_START_MESSAGE','Ошибка отправки сообщения-затычки на сервер Viber');
			#-------------------------------------------------------------------------------
			// вываливаемся из скрипта, вообще
			return Array('Status'=>'Ok');
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// всё перебирать бессмысленно, достаточно первого десятка слов
	if($wCount > 9)
		break;
	#-------------------------------------------------------------------------------
	$wCount++;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// сюда мы попали если ничего не найдено
if(!$Viber->MessageSend($SenderID,$Settings['Params']['StubMessage']))
	return new gException('ERROR_SEND_START_MESSAGE','Ошибка отправки сообщения-затычки на сервер Viber');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------


?>
