<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru 
 *
 * какие услуги могут быть заказаны дополнительно к указанным 
 * сервису, группе серверов, или конркетному серверу
 *
 * */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ServiceID	= (integer) @$Args['ServiceID'];
$ServersGroupID	= (integer) @$Args['ServersGroupID'];
$ServerID	= (integer) @$Args['ServerID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','libs/Upload.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Services = DB_Select('Services',Array('*'),Array('SortOn'=>'SortID'));
#-------------------------------------------------------------------------------
switch(ValueOf($Services)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $Out;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($Services as $Service){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[www/API/v2/DependServices]: processing ServiceID = %u',$Service['ID']));
	// пропускаем, если тегов нет
	if(!IsSet($Service['Params']['Tags']) || !SizeOf($Service['Params']['Tags']))
		continue;
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[www/API/v2/DependServices]: processing ServiceID = %u',$Service['ID']));
	// перебираем Tags
	$Tags = $Service['Params']['Tags'];
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Tags) as $Key){
		#-------------------------------------------------------------------------------
		switch($Key){
		case 'Services':
			#-------------------------------------------------------------------------------
			// сервисы просто докидываем (если найденный сервис содержит в зависимостях присланный)
			foreach($Tags[$Key] as $iService){
				#-------------------------------------------------------------------------------
				//Debug(SPrintF('[www/API/v2/DependServices]: iService = %u',$iService));
				#-------------------------------------------------------------------------------
				if($iService == $ServiceID){
					#-------------------------------------------------------------------------------
					if(!In_Array($Service['ID'],$Out)){
						#-------------------------------------------------------------------------------
						$Out[] = $Service['ID'];
						#-------------------------------------------------------------------------------
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'Servers':
			#-------------------------------------------------------------------------------
			// перебираем сервера, ищем услуги к которым они относятся
			foreach($Tags[$Key] as $iServer){
				#-------------------------------------------------------------------------------
				if($iServer == $ServerID){
					#-------------------------------------------------------------------------------
					$Server = DB_Select('ServersGroups','ServiceID',Array('UNIQ','Where'=>SPrintF('`ID` = (SELECT `ServersGroupID` FROM `Servers` WHERE `ID` = %u)',$ServerID)));
					#-------------------------------------------------------------------------------
					switch(ValueOf($Server)){
					case 'error':
						return ERROR | @Trigger_Error(500);
					case 'exception':
						break;
					case 'array':
						#-------------------------------------------------------------------------------
						if(!In_Array($Server['ServiceID'],$Out))
							$Out[] = $Server['ServiceID'];
						#-------------------------------------------------------------------------------
						break;
						#-------------------------------------------------------------------------------
					default:
						return ERROR | @Trigger_Error(101);
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'ServersGroups':
			#-------------------------------------------------------------------------------
			// перебираем группы серверов
			foreach($Tags[$Key] as $iServersGroup){
				#-------------------------------------------------------------------------------
				if($iServersGroup == $ServersGroupID){
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[www/API/v2/DependServices]: iServersGroup = %u',$iServersGroup));
					#-------------------------------------------------------------------------------
					$ServersGroup = DB_Select('ServersGroups','ServiceID',Array('UNIQ','ID'=>$ServersGroupID));
					#-------------------------------------------------------------------------------
					switch(ValueOf($ServersGroup)){
					case 'error':
						return ERROR | @Trigger_Error(500);
					case 'exception':
						break;
					case 'array':
						#-------------------------------------------------------------------------------
						if(!In_Array($Service['ID'],$Out))
							$Out[] = $Service['ID'];
						#-------------------------------------------------------------------------------
						break;
						#-------------------------------------------------------------------------------
					default:
						return ERROR | @Trigger_Error(101);
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Out;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
