<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args	= IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$ID	= (integer) @$Args['ID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','libs/Upload.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$PaymentSystems = $Config['Invoices']['PaymentSystems'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// првоеряем, можно ли условно счета проводить
$ShowButton = TRUE;
#-------------------------------------------------------------------------------
$AllowConditionally = $Config['Invoices']['AllowConditionally'];
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['GC']['NotifyConditionallyInvoiceSettings'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($AllowConditionally){
	#-------------------------------------------------------------------------------
	# проверяем нету ли у юзера условных счетов
	$Count = DB_Count('InvoicesOwners',Array('Where'=>SPrintF("`StatusID` = 'Conditionally' AND `UserID` = %u",$GLOBALS['__USER']['ID'])));
	if($Count)
		$ShowButton = FALSE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# проверяем не отрицательный ли у него балланс, на каком-либо договоре
	$Count = DB_Count('ContractsOwners',Array('Where'=>SPrintF("`Balance` < 0 AND `UserID` = %u",$GLOBALS['__USER']['ID'])));
	if($Count)
		$ShowButton = FALSE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# проверяем что он наоплачивал на ту сумму, начиная с которой можно проводить счета условно
	$PayedSumm = DB_Select('InvoicesOwners',Array('SUM(Summ) AS `Summ`'),Array('UNIQ','Where'=>SPrintF("`StatusID` = 'Payed' AND `UserID` = %u",$GLOBALS['__USER']['ID'])));
	#-------------------------------------------------------------------------------
	switch(ValueOf($PayedSumm)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
        if($PayedSumm['Summ'] < $GLOBALS['__USER']['LayPayThreshold'])
		$ShowButton = FALSE;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = Array('`UserID` = @local.__USER_ID');
#-------------------------------------------------------------------------------
if($ID > 0)
	$Where[] = SPrintF('`ID` = %s',$ID);
#-------------------------------------------------------------------------------
$Invoices = DB_Select('InvoicesOwners','*',Array('Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($Invoices)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $Out;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
foreach($Invoices as $Invoice){
	#-------------------------------------------------------------------------------
	// добавляем имя платёжной системы к выводу (которой может уже и не быть)
	$Invoice['PaymentSystemName'] = IsSet($PaymentSystems[$Invoice['PaymentSystemID']]['Name'])?$PaymentSystems[$Invoice['PaymentSystemID']]['Name']:SPrintF('%s [удалена]',$Invoice['PaymentSystemID']);
	#-------------------------------------------------------------------------------
	// достаём элементы счёта
	$InvoicesItems = DB_Select('InvoicesItems','*',Array('Where'=>SPrintF('`InvoiceID` = %u',$Invoice['ID'])));
	#-------------------------------------------------------------------------------
	switch(ValueOf($InvoicesItems)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		$InvoiceItems = Array();
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	// добавляем элементы счёта
	$Invoice['InvoicesItems'] = $InvoicesItems;
	#-------------------------------------------------------------------------------
	// можно ли условно
	$Invoice['AllowConditionally'] = ($ShowButton && $AllowConditionally && In_Array($Invoice['StatusID'],Array('Waiting','Rejected')))?TRUE:FALSE;
	$Invoice['AllowConditionallyMessage'] = SPrintF("Вы действительно хотите воспользоваться услугами в долг? Данный счёт всё равно придётся оплачивать, иначе услуги будут заблокированы. В случае если счёт не будет оплачен в течении %u дней то ваш балланс станет отрицательным. В этом случае, вы не сможете оплатить другие услуги до того как он не станет нулевым или положительным",$Settings['DaysBeforeRejectConditionallyInvoice']);
	#-------------------------------------------------------------------------------
	$Out[$Invoice['ID']] = $Invoice;
	#-------------------------------------------------------------------------------
	// докУменты
	$Files = GetUploadedFilesInfo('Invoices',$Invoice['ID']);
	#-------------------------------------------------------------------------------
	if(SizeOf($Files)){
		#-------------------------------------------------------------------------------
		$Out[$Invoice['ID']]['Files'] = Array();
		#-------------------------------------------------------------------------------
		foreach($Files as $File)
			$Out[$Invoice['ID']]['Files'][$File['ID']] = $File;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return ($ID > 0)?Current($Out):$Out;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

