<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$FileID		= (integer) @$Args['FileID'];
$IsPrintOut	= (boolean) @$Args['IsPrintOut'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','libs/Upload.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём данные файла
$File = DB_Select('FilesOwners','*',Array('UNIQ','ID'=>$FileID));
#-------------------------------------------------------------------------------
switch(ValueOf($File)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// есть типы файлов которые скачиваются через свой интерфейс, т.к. там пост-обработка
if(In_Array($File['TableID'],Array('Contracts','Invoices')))
	return new gException('NOT_FOR_THIS_FILE_TYPE','Этот интерфейс не предназначен для файлов этого типа');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$FileData = DB_Select(SPrintF('%sOwners',$File['TableID']),'*',Array('UNIQ','ID'=>$File['RowID']));
#-------------------------------------------------------------------------------
switch(ValueOf($FileData)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// для тикетов: проверяем владельца самого тикета, если смотрит владелец или админ - то отдаём файл
if($File['TableID'] == 'EdesksMessages'){
	#-------------------------------------------------------------------------------
	$Edesk = DB_Select('Edesks','UserID',Array('UNIQ','Where'=>SPrintF('`ID` = (SELECT `EdeskID` FROM `EdesksMessages` WHERE `ID` = %u)',$File['RowID'])));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Edesk)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		#-------------------------------------------------------------------------------
		// если это не владелец тикета или не админ - файл не отдаём
		if($__USER['ID'] != $Edesk['UserID'])
			if(!$__USER['IsAdmin'])
				return new gException('NOT_TICKET_OWNER','Вы не являетесь владельцем этого тикета');
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}elseif(In_Array($File['TableID'],Array('Users','Clauses'))){
	#-------------------------------------------------------------------------------
	// таблица юзеров, статей автарки и картинки можно смотреть всем авторизованным
}else{
	#-------------------------------------------------------------------------------
	// проверяем права на чтение
	$Permission = Permission_Check(SPrintF('%sRead',$File['TableID']),(integer)$__USER['ID'],(integer)$FileData['UserID']);
	#-------------------------------------------------------------------------------
	switch(ValueOf($Permission)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'false':
		return ERROR | @Trigger_Error(700);
	case 'true':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// стандартной функцией достаём все файлы, лень писать отдельную
$Datas = GetUploadedFiles($File['TableID'],$File['RowID']);
#-------------------------------------------------------------------------------
// если ничего не найдено, и таблица - Users, выдаём стандартную аватарку
if(SizeOf($Datas) < 1 && $File['TableID'] == 'Users'){
	#-------------------------------------------------------------------------------
	$Path = Styles_Element('Images/UserFoto.jpg');
	if(Is_Error($Path))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Foto = IO_Read($Path);
	if(Is_Error($Foto))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Datas = Array(Array('ID'=>$FileID,'Mime'=>'image/jpeg','Size'=>Mb_StrLen($Foto,'8bit'),'Name'=>'UserFoto.jpg','Data'=>$Foto));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// перебором ищем нужный файл
foreach($Datas as $Data){
	#-------------------------------------------------------------------------------
	// все не подходящие - пропускаем
	if($Data['ID'] != $FileID)
		continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
/*	$FileName = SPrintF('%s.bin',$FileData['ID']);
	if($TypeID == 'Profiles')	{$FileName = SPrintF('document_%s.%s',$FileData['ID'],$FileData['Format']);}
	if(IsSet($FileData['FileName'])){$FileName = $FileData['FileName'];}
*/
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// обратная совместимость с ./hosts/billing/comp/www/ClauseFileDownload.comp.php
	if(!$IsPrintOut){
		#-------------------------------------------------------------------------------
		Header(SPrintF('Content-Type: %s; charset=utf-8',$Data['Mime']));
		Header(SPrintF('Content-Length: %u',$Data['Size']));
		Header(SPrintF('Content-Disposition: attachment; filename="%s";',$Data['Name']));
		Header('Pragma: nocache');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	return $Data['Data'];
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// внезапно... тут мы никак оказатсья не должны, но всё же
return ERROR | @Trigger_Error(105);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
