<?php

#-------------------------------------------------------------------------------
// основано на https://github.com/akunich/umka-api-php-example
// допилено Alex Keda, for www.host-food.ru
/******************************************************************************/
/******************************************************************************/

class umkaApiModel {
	#-------------------------------------------------------------------------------
	// url кассы
	public $Cpp		= 'http://office.isp.su:8088/';
	// логин и пароль кассира (по-умолчанию в умке логины от 1 до 99, пароль совпадает с логином). Юзер 99 - администратор
	public $Login		= '1';
	// Особенность. При смене паролей выяснилось, что умка принимает только цифровые пароли не более 8 символов
	public $Password	= '1';
	// налогообложение
	public $TaxationSystem	= 'SIMPLIFIED_IN_OUT';
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// 0 - каcса не отвечает, 1 - отвечает. смена закрыта, 2 - отвечает и смена открыта
	private $kktStatus	= 0;
	private $kktStatusDetail;
	private $Summ		= 0;
	// надо ли реально печатать чеки
	private $Print		= 0;
	// используется при формировании sessionid. У каждого магазина должен быть уникальнм от нуля до 9999, для разработки используем id > 9000
	private $shopId		= 1;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	//конструктор выполнится при инициализации
	public function __construct($Cpp,$Login,$Password,$TaxationSystem) {
		$this->Cpp		= $Cpp;
		$this->Login		= $Login;
		$this->Password		= $Password;
		$this->TaxationSystem	= $TaxationSystem;
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public function init(){
		#-------------------------------------------------------------------------------
		// достаём статус кассы
		$Status = $this->getKktStatus();
		#-------------------------------------------------------------------------------
		// если смена открыта, всё хорошо
		if($Status == 2)
			return TRUE;
		#-------------------------------------------------------------------------------
		// если смена закрыта, открываем
		if($Status == 1){
			#-------------------------------------------------------------------------------
			// смена открылась нормально
			if($this->cycleOpen())
				return TRUE;
			#-------------------------------------------------------------------------------
			// возможно смена не откроется
			// {"document":{"message":{"resultDescription":"ККТ не фискализирована"},"result":168},"protocol":1,"version":"1.0"}
			if(!$this->cycleOpen())
				return FALSE;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// какая-то ошибка, касса не вернула ответ или т.п.
		return FALSE;
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	private function getKktStatus(){
		#-------------------------------------------------------------------------------
		$Status = $this->cashboxStatus(); 
		#-------------------------------------------------------------------------------
		if(Is_Array($Status)){
			#-------------------------------------------------------------------------------
			$this->kktStatusDetail = $Status;
			#-------------------------------------------------------------------------------
			if(IsSet($Status['cashboxStatus']['fsStatus']['cycleIsOpen']) && $Status['cashboxStatus']['fsStatus']['cycleIsOpen'] == 1){
				#-------------------------------------------------------------------------------
				$Result = 2;
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$Result = 1;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			$Result = 0;
			#-------------------------------------------------------------------------------
		}
      		#-------------------------------------------------------------------------------
		$this->kktStatus = $Result;
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/UMKA.php/getKktStatus]: this->kktStatus = %s',$Result));
		#-------------------------------------------------------------------------------
		return $Result;
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	private function cashboxStatus(){
		return $this->API('/cashboxStatus.json');
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	private function cycleOpen(){
		#-------------------------------------------------------------------------------
		$Result = $this->API(SPrintF('/cycleopen.json?print=%u',$this->Print));
		#-------------------------------------------------------------------------------
		if(IsSet($Result['document']['result']) && $Result['document']['result'] == 0){
			#-------------------------------------------------------------------------------
			return TRUE;
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[system/libs/UMKA.php/cycleOpen]: Result = %s',print_r($Result,true)));
			#-------------------------------------------------------------------------------
			return FALSE;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}


	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// а нету вызовов этой функции
	private function cycleClose() {
		return @$this->API(SPrintF('/cycleclose.json?print=%u',$this->Print));
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	private function makeSessionId($checkNumber) {
		/* если чек залип и не проходит, хаменить первый 0 на 1 перезапустить, птом вернуть */
		return SPrintF('%s%s',Str_Pad($this->shopId,4,'0',STR_PAD_LEFT),Str_Pad($checkNumber,16,'0',STR_PAD_LEFT));
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	private function makeSessionIdCancel($checkNumber) {
		return Str_Pad($this->shopId,4,'0',STR_PAD_LEFT).'5'.Str_Pad($checkNumber,15,'0',STR_PAD_LEFT);
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// а нету вызовов этой функции
	private function makeSessionIdCorrect($checkNumber) {
		return Str_Pad($this->shopId, 4, '0', STR_PAD_LEFT).'7'.Str_Pad($checkNumber, 15, '0', STR_PAD_LEFT);
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	private function makeFiscProp($Data,$Tag = FALSE){
		#-------------------------------------------------------------------------------
		$Result = Array('fiscprops'=>Array());
		#-------------------------------------------------------------------------------
		foreach($Data as $Item)
			$Result['fiscprops'][] = $Item;
		#-------------------------------------------------------------------------------
		if($Tag)
			$Result['tag'] = $Tag;
		#-------------------------------------------------------------------------------
		return $Result;
		#-------------------------------------------------------------------------------
	}
 
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перечисление позиций в чеке
	private function makeFiscPropPosition($Position){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/UMKA.php/makeFiscPropPosition]: Position = %s',print_r($Position,true)));
		#-------------------------------------------------------------------------------
		$Data = Array();
		#-------------------------------------------------------------------------------
		// признак способа расчёта 
	 	// 1 - Полная предварительная оплата до момента передачи предмета расчета «ПРЕДОПЛАТА 100%»
	 	// 2 - Частичная предварительная оплата до момента передачи предмета расчета «ПРЕДОПЛАТА»
	 	// 3 - аванс «АВАНС»
	 	// 4 - Полная оплата, в том числе с учетом аванса (предварительной оплаты) в момент передачи предмета расчета «ПОЛНЫЙ РАСЧЕТ»
	 	// есть ещё 5, 6, 7 (см. таблицу 28 в спецификации ФФД)
		$Data[] = Array('tag'=>1214,'value'=>1);
 		#-------------------------------------------------------------------------------
		// признак предмета расчёта 
 		// 1 - товар, 3 - работа, 4 - услуга (таблица 29)
		$Data[] = Array('tag'=>1212,'value'=>4);
		#-------------------------------------------------------------------------------
		// наименование предмета расчета (текст. до 128 символов)
		$Data[] = Array('tag' => 1030, 'value' => $Position['Name']);
		#-------------------------------------------------------------------------------
		// цена за единицу предмета расчета с учетом скидок и наценок
		// Передавать обязательно. В копейках
		$summPos = Ceil(($Position['Summ']/$Position['Amount'])*100);
		$Data[] = Array('tag'=>1079,'value'=>$summPos);
		#-------------------------------------------------------------------------------
		// количество предмета расчета
		// Передавать обязательно. Строкой с 3 знаками после запятой.
		$Data[] = Array('tag'=>1023,'value'=>Number_Format($Position['Amount'], 3, '.',''));
		#-------------------------------------------------------------------------------
		// ставка НДС  ( таблица 24) 
		$TaxationSystems = Array('COMMON'=>1,'SIMPLIFIED_IN'=>6,'SIMPLIFIED_IN_OUT'=>6,'UTOII'=>6,'PATENT'=>6);
		// 1 - «НДС 18%», 2 - «НДС 10%», 3 - «НДС 18/118», 4 - «НДС 10/110», 5 - «НДС 0%», 6 - НДС не облагается
		$Data[] = Array('tag'=>1199,'value'=>$TaxationSystems[$this->TaxationSystem]);
		#-------------------------------------------------------------------------------
		// единица измерения предмета расчета (текст , до 16 символов)
		$Data[] = Array('tag'=>1197,'value'=>$Position['Measure']);
		#-------------------------------------------------------------------------------
		// тег признака "Предмет расчёта" - 1059
		$Result = $this->makeFiscProp($Data,1059);
		#-------------------------------------------------------------------------------
		$this->Summ = $this->Summ + ($summPos*$Position['Amount']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return $Result;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public function fiscalCheck($Invoice,$Positions,$Number,$moneyType = 2){
		#-------------------------------------------------------------------------------
		$Query = Array('document'=>Array());
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$this->Summ = 0;
		#-------------------------------------------------------------------------------
		$sessionId = $this->makeSessionId($Invoice['ID']);
		#-------------------------------------------------------------------------------
		// Уникальное ИД сессии (генерируется самостоятельно и должно быть уникальным для каждого чека)
		$Query['document']['sessionId'] = $sessionId;
		#-------------------------------------------------------------------------------
		// Флаг необходимости печати чека
		$Query['document']['print'] = $this->Print;
		#-------------------------------------------------------------------------------
		$Query['document']['data']['docName'] = 'Бланк строгой отчетности';
		#-------------------------------------------------------------------------------
		// Тип документа (1. Продажа, 2.Возврат продажи, 4. Покупка, 5. Возврат покупки, 7. Коррекция прихода, 9. Коррекция расхода)
		$Query['document']['data']['type'] = 1;
		#-------------------------------------------------------------------------------
		// ТИП ОПЛАТЫ (1. Наличным, 2. Электронными, 3. Предоплата, 4. Постоплата, 5. Встречное предоставление)
		$Query['document']['data']['moneyType'] = 2;
		#-------------------------------------------------------------------------------
		// Сумма закрытия чека (может быть 0, если без сдачи) в копейках
		$Query['document']['data']['sum'] = $Invoice['Summ']*100;
		#-------------------------------------------------------------------------------
//		$Query['document']['result'] = 0;
		#-------------------------------------------------------------------------------
		// применяемая система налогообложения (применяется битовое значение) См. (номер бита - значение)
		$TaxationSystems = Array('COMMON'=>1,'SIMPLIFIED_IN'=>2,'SIMPLIFIED_IN_OUT'=>4,'UTOII'=>8,'PATENT'=>32);
		// (0 - 1) - ОСН, (1 - 2) - УСН доход, (2 - 4) - УСН доход - расход, (3 - 8) - ЕНВД, (4 - 16) - ЕСН, (5 - 32) - Патент
		$Query['document']['data']['fiscprops'][] = Array('tag'=>1055,'value'=>$TaxationSystems[$this->TaxationSystem]);
		#-------------------------------------------------------------------------------
		// признак расчета. 1 - <ПРИХОД>, 3 - <РАСХОД>, 2 - <ВОЗВРАТ ПРИХОДА>, 4 - <ВОЗВРАТ РАСХОДА>
		$Query['document']['data']['fiscprops'][] = Array('tag'=>1054,'value'=>1);
		#-------------------------------------------------------------------------------
		// телефон или электронный адрес покупателя
		$Query['document']['data']['fiscprops'][] = Array('tag'=>1008,'value'=>$Invoice['Email']);
		#-------------------------------------------------------------------------------
		// адрес сайта ФНС
		$Query['document']['data']['fiscprops'][] = Array('tag'=>1060,'value'=>$this->kktStatusDetail['cashboxStatus']['fnsSite']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// наименование дополнительного реквизита пользователя
//		$Data[] = Array('tag' =>1085,'value'=>'Служба поддержки');
		// значение дополнительного реквизита пользователя
//		$Data[] = Array('tag'=>1086,'value'=>$this->kktStatusDetail['cashboxStatus']['email']);
		#-------------------------------------------------------------------------------
		// упаковка фискального свойства с тегом 
		// дополнительный реквизит пользователя (тег 1084)
//		$Query['document']['data']['fiscprops'][] = $this->makeFiscProp($Data,1084);
		#-------------------------------------------------------------------------------
//		unset($Data);
		#-------------------------------------------------------------------------------
		$Data[] = Array('tag' =>1085,'value'=>'Номер счёта');
		$Data[] = Array('tag'=>1086,'value'=>$Number);
		#-------------------------------------------------------------------------------
		$Query['document']['data']['fiscprops'][] = $this->makeFiscProp($Data,1084);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		foreach($Positions as $Position)
			$Query['document']['data']['fiscprops'][] = $this->makeFiscPropPosition($Position);
		#-------------------------------------------------------------------------------
		// проверка, что подсчитанная сумма не превышает реальную более чем на 10%
		if($this->Summ <= ($Query['document']['data']['sum']*1.1))
			$Query['document']['data']['sum'] = $this->Summ;
		#-------------------------------------------------------------------------------
		$Query = Json_Encode($Query, JSON_UNESCAPED_UNICODE);
		#-------------------------------------------------------------------------------
		$Answer = $this->API('/fiscalcheck.json', $Query);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// возможны ошибки, например
		// {"document":{"message":{"resultDescription":"Начисление налога на последнюю операцию невозможно"},"result":224,"sessionId":"00010000000000469031"},"protocol":1,"version":"1.0"}
		if(IsSet($Answer['document']['result']) && $Answer['document']['result'] > 0)
			return FALSE;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[system/libs/UMKA.php]: Answer = %s',print_r($Answer,true)));
		// сохраняем соответсвтие номера счёта и номера чека
		$this->SaveDocNumber($sessionId,$Answer['document']['data']['docNumber']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return $Answer;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}


	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	/* пока не используется
   
   function fiscalcheckCancel($Invoice, $Positions, $moneyType = 2) {
       
        $this->Summ = 0;
        $sessionId = $this->makeSessionIdCancel($Invoice['ID']);
        
        # Уникальное ИД сессии (генерируется самостоятельно и должно быть уникальным для каждого чека)
        $Query['document']['sessionId'] = $sessionId;
        # Флаг необходимости печати чека
        $Query['document']['print'] = $this->Print;
        $Query['document']['data']['docName'] = 'Бланк строгой отчетности';
        # Тип документа (1. Продажа, 2.Возврат продажи, 4. Покупка, 5. Возврат покупки, 7. Коррекция прихода, 9. Коррекция расхода)
        $Query['document']['data']['type'] = 2;
        # ТИП ОПЛАТЫ (1. Наличным, 2. Электронными, 3. Предоплата, 4. Постоплата, 5. Встречное предоставление)
        $Query['document']['data']['moneyType'] = $moneyType;
        # Сумма закрытия чека (может быть 0, если без сдачи) в копейках
        $Query['document']['data']['sum'] = $Invoice['Summ']*100;
        $Query['document']['result'] = 0;
        
        # тег отмены. Берём данные ФПД из ранее выписанного чека
        if(file_exists('/tmp/'.$Invoice['ID'].'-export-fs-answer.txt')) {
            $jsonFiscalCheck = Json_Decode(file_get_contents('/tmp/'.$Invoice['ID'].'-export-fs-answer.txt'), true);
            $result = $this->findFiscProps($jsonFiscalCheck, 1077, 0);
            if(count($result)==1) {
                $Query['document']['data']['fiscprops'][] = Array('tag' => 1192, 'value' => $result['0']);
            } else {
                return false;
            }
        } else {
            return false;
        }
        
        
        # применяемая система налогообложения (применяется битовое значение) См. (номер бита - значение)
        # (0 - 1) - ОСН, (1 - 2) - УСН доход, (2 - 4) - УСН доход - расход, (3 - 8) - ЕНВД, (4 - 16) - ЕСН, (5 - 32) - Патент
        $Query['document']['data']['fiscprops'][] = Array('tag' => 1055, 'value' => 2);
        # признак расчета. 1 - <ПРИХОД>, 3 - <РАСХОД>, 2 - <ВОЗВРАТ ПРИХОДА>, 4 - <ВОЗВРАТ РАСХОДА>
        $Query['document']['data']['fiscprops'][] = Array('tag' => 1054, 'value' => 2);
        # телефон или электронный адрес покупателя
        $Query['document']['data']['fiscprops'][] = Array('tag' => 1008, 'value' => $Invoice['Email']);
        # адрес сайта ФНС
        $Query['document']['data']['fiscprops'][] = Array('tag' => 1060, 'value' => $this->kktStatusDetail['cashboxStatus']['fnsSite']);
        
        # наименование дополнительного реквизита пользователя
        $Data[] = Array('tag' => 1085, 'value' => 'Служба поддержки ');
        # значение дополнительного реквизита пользователя
        $Data[] = Array('tag' => 1086, 'value' => '8 800 ..........');
        # упаковка фискального свойства с тегом 
        # дополнительный реквизит пользователя (тег 1084)
        $Query['document']['data']['fiscprops'][] = $this->makeFiscProp($Data, 1084);
        unset($Data);
        
        
        foreach($Positions as $Position) {
            $Query['document']['data']['fiscprops'][] = $this->makeFiscPropPosition($Position);
        }
        
        
        # проверка, что подсчитанная сумма не превышает реальную более чем на 10%
        file_put_contents('/tmp/'.$Invoice['ID'].'-export-fsc-summ.txt', $this->Summ."\n".$Query['document']['data']['sum']);
        if($this->Summ <= ($Query['document']['data']['sum']*1.1))
		$Query['document']['data']['sum'] = $this->Summ;
        
        
      $Query = Json_Encode($Query, JSON_UNESCAPED_UNICODE);
      
      $Answer = $this->API('/fiscalcheck.json', $Query);
      
      # для логирования на всякий случай
      file_put_contents('/tmp/'.$Invoice['ID'].'-export-fsc-Query.txt', $Query);
      file_put_contents('/tmp/'.$Invoice['ID'].'-export-fsc-answer.txt', Json_Encode($answer, JSON_UNESCAPED_UNICODE));
      
      return $Answer;
   }
   
	*/

	#-------------------------------------------------------------------------------   
	#-------------------------------------------------------------------------------
	// АПИ
	private function API($Url = '',$Post = ''){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/UMKA.php/API]: Post = %s',print_r(Json_Decode($Post,true),true)));
		#-------------------------------------------------------------------------------
		// разбираем URL АПИ
		$ParseUrl = Parse_Url($this->Cpp);
		//Debug(SPrintF('[system/libs/UMKA.php]: ParseUrl = %s',print_r($ParseUrl,true)));
		#-------------------------------------------------------------------------------
		if(!IsSet($ParseUrl['scheme']))
			$ParseUrl['scheme'] = 'http';
		#-------------------------------------------------------------------------------
		$Protocol = (In_Array(StrToLower($ParseUrl['scheme']),Array('ssl','tls','https')))?'ssl':'tcp';
		#-------------------------------------------------------------------------------
		$Address = $ParseUrl['host'];
		#-------------------------------------------------------------------------------
		if(!IsSet($ParseUrl['port'])){
			#-------------------------------------------------------------------------------
			$Port = ($Protocol == 'ssl')?443:80;
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			$Port = $ParseUrl['port'];
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$HTTP = Array(
				'Address'	=> $Address,
				'Port'		=> $Port,
				'Host'		=> $Address,
				'Protocol'	=> $Protocol,
				'Basic'		=> SPrintF('%s:%s',$this->Login,$this->Password),
				);
		#-------------------------------------------------------------------------------
		$Result = HTTP_Send($Url,$HTTP,Array(),$Post/*,$Headers*/);
		#-------------------------------------------------------------------------------
		if(Is_Error($Result))
			return ERROR | @Trigger_Error('[API]: не удалось выполнить запрос к серверу');
		#-------------------------------------------------------------------------------
		$Result = Trim($Result['Body']);
		#-------------------------------------------------------------------------------
		$Result = Json_Decode($Result,TRUE);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(Is_Array($Result) && Count($Result)> 0){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[system/libs/UMKA.php/API]: Result = %s',print_r($Result,true)));
			#-------------------------------------------------------------------------------
			return $Result;
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			$this->error("API :: $Post");
			#-------------------------------------------------------------------------------
			return false;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// сохранение сопоставления между номером чека и иденфтикатором SessionId, может когда-то понадобится
	private function SaveDocNumber($SessionId,$docNumber){
		#-------------------------------------------------------------------------------
		// сохраняем переданные данные
		$IsInsert = DB_Insert('TmpData',Array('AppID'=>'Taxation','Col1'=>$docNumber,'Col2'=>$SessionId));
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}

	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// достаём сохранённый номер чека, по номеру счёта
	private function FindDocNumber($SessionId){
		#-------------------------------------------------------------------------------
		$DocNumber = DB_Select('TmpData','Col1',Array('UNIQ','Where'=>Array('`AppID` = "Taxation"',SPrintF('`Col2` = "%s"',$SessionId)),'SortOn'=>'CreateDate','Limits'=>Array(0,1)));
		#-------------------------------------------------------------------------------
		switch(ValueOf($DocNumber)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return FALSE;
		case 'array':
			#-------------------------------------------------------------------------------
			return $DocNumber['Col1'];
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
	}
   
   
    # функция рекурсивно ищет в массиве массив в котором есть ключ tag с искомым значением  $tag и возвращает 
    # при $parrent == 0 значение value из найденного массива
    # при $parrent == 1 значение весь найденный массив
    # при $parrent == 2 весь вешестоящий массив, в котором найден искомый массив (с нужным тегом)
    # ввиду того, что некоторые теги в чеке могут быть встречены ни один раз, найденные результаты помещаются в массив с числовыми ключами (от ноля и далее)   
    function findFiscProps($Data, $tag, $parrent=0) {  
    	$result = Array();
        
        if(Is_Array($Data)) foreach ($Data as $key=>$value) {
     	      if(isset($value['tag']) && $value['tag'] == $tag) {
                  if($parrent==2) $result = Array_merge($result, Array($Data));
                  elseif($parrent==1) $result = Array_merge($result, Array($value));
                  else $result = Array_merge($result, Array($value['value']));
              } else {
                  $tmp = $this->findFiscProps($value, $tag, $parrent);
                  if(count($tmp)>0) $result = Array_merge($result, $tmp);
              }
        }
        return $result;
    } 
    
    
   
   function error($info) {
       
       return;
   }
   
 

}
 
