<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Task');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['DSCalculateNumServers'];
#-------------------------------------------------------------------------------
$ExecuteTime = Comp_Load('Formats/Task/ExecuteTime',Array('ExecutePeriod'=>$Settings['ExecutePeriod']));
if(Is_Error($ExecuteTime))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
# если неактивна, то через день запуск
if(!$Settings['IsActive']){
	#-------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'][] = 'Task not active';
	#-------------------------------------------------------------------------------
	return 24*3600;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
# достаём все тарифы с несломанными серверами
$Schemes = DB_Select('DSSchemes',Array('`ID` AS `SchemeID`'),Array('Where'=>Array('`IsBroken` = "no"')));
#-------------------------------------------------------------------------------
switch(ValueOf($Schemes)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	# no servers ...
	$GLOBALS['TaskReturnInfo'][] = 'No servers...';
	#-------------------------------------------------------------------------------
	return (Time() + 3600);
	#-------------------------------------------------------------------------------
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$GLOBALS['TaskReturnInfo'] = Array('Used'=>Array(0),'UnUsed'=>Array(0));
#-------------------------------------------------------------------------------
foreach($Schemes as $Scheme){
	#-------------------------------------------------------------------------------
	# достаём число юзающихся серверов
	$Where = Array(SPrintF('`SchemeID` = %u AND `StatusID` IN ("OnCreate","Active","Suspended","OnService")',$Scheme['SchemeID']));
	#-------------------------------------------------------------------------------
	$Count = DB_Count('DSOrders',Array('Where'=>$Where));
	if(Is_Error($Count))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	# если чё-то насчитали - сервер используется.
	$IsActive = ($Count)?FALSE:TRUE;
	#-------------------------------------------------------------------------------
	# устанавливаем статус тарифа
	$IsUpdate = DB_Update('DSSchemes',Array('IsActive'=>$IsActive),Array('ID'=>$Scheme['SchemeID']));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	// выхлоп таска
	if($Count){
		#-------------------------------------------------------------------------------
		$GLOBALS['TaskReturnInfo']['Used'][0]++;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$GLOBALS['TaskReturnInfo']['UnUsed'][0]++;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// все что сломанные, ставим неактивными
$IsUpdate = DB_Update('DSSchemes',Array('IsActive'=>FALSE),Array('Where'=>'`IsBroken` = "yes"'));
if(Is_Error($IsUpdate))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $ExecuteTime;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
