<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Params');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('classes/HostingServer.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['GC']['DiskUsageNotifiesSettings'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Servers = DB_Select('Servers','*',Array('Where'=>'(SELECT `ServiceID` FROM `ServersGroups` WHERE `Servers`.`ServersGroupID` = `ServersGroups`.`ID`) = 10000','SortOn'=>'Address'));
#-------------------------------------------------------------------------------
switch(ValueOf($Servers)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: не найдено серверов хостинга'));
	#-------------------------------------------------------------------------------
	# No more...
	return TRUE;
	#-------------------------------------------------------------------------------
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($Servers as $Server){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: обработка аккаунтов на сервере %s',$Server['Address']));
	#-------------------------------------------------------------------------------
	#if($Server['Address'] != 'brainy.test-hf.su')
	#	continue;
	#-------------------------------------------------------------------------------
	if(!$Server['IsActive']){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: сервер %s не активен, пропускаем',$Server['Address']));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$ClassHostingServer = new HostingServer();
	#-------------------------------------------------------------------------------
	$IsSelected = $ClassHostingServer->Select((integer)$Server['ID']);
	#-------------------------------------------------------------------------------
	switch(ValueOf($IsSelected)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'true':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Accounts = $ClassHostingServer->GetDiskUsage();
	#-------------------------------------------------------------------------------
	switch(ValueOf($Accounts)){
	case 'error':
		# No more...
	case 'exception':
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: не удалось получить данные о использовании диска с сервера %s',$Server['Address']));
		#-------------------------------------------------------------------------------
		# No more...
		continue 2;
		#-------------------------------------------------------------------------------
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: Accounts = %s',print_r($Accounts,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Array = Array();
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Accounts) as $UserID)
		if(!$Accounts[$UserID]['Disabled'])
			$Array[] = SPrintF("'%s'",$UserID);
	#-------------------------------------------------------------------------------
	# нет аккаутов - ничё не делаем
	if(SizeOf($Array) == 0){
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: на сервере %s не найдено аккаунтов',$Server['Address']));
		#-------------------------------------------------------------------------------
		continue;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$HostingOrders = DB_Select('HostingOrdersOwners',Array('ID','OrderID','UserID','Login'),Array('Where'=>SPrintF('`Login` IN (%s)',Implode(',',$Array))));
	#-------------------------------------------------------------------------------
	switch(ValueOf($HostingOrders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		continue 2;
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	foreach($HostingOrders as $Order){
		#-------------------------------------------------------------------------------
		# выбираем тех кто лимит имеет, и лимит этот не микроскопический
		if($Accounts[$Order['Login']]['Limit'] > 4){
			#-------------------------------------------------------------------------------
			#Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: account %s/%s used %s/%s',$Order['Login'],$Server['Address'],$Accounts[$Order['Login']]['Used'],$Accounts[$Order['Login']]['Limit']));
			#-------------------------------------------------------------------------------
			# лимит есть, но используется больше чем ограничение
			if($Accounts[$Order['Login']]['Limit'] < $Accounts[$Order['Login']]['Used']){
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: избыточное использование диска аккаунтом %s/%s, используется %s/%s',$Order['Login'],$Server['Address'],$Accounts[$Order['Login']]['Used'],$Accounts[$Order['Login']]['Limit']));
				#-------------------------------------------------------------------------------
				if($Settings['IsEventForOverLimits']){
					#-------------------------------------------------------------------------------
					$Event = Array(
							'UserID'        => $Order['UserID'],
							'PriorityID'    => 'Warning',
							'Text'          => SPrintF('Обнаружен заказ хостинга (%s/%s) с превышением (%s/%s) использования дискового пространства',$Order['Login'],$Server['Address'],$Accounts[$Order['Login']]['Used'],$Accounts[$Order['Login']]['Limit']),
							'IsReaded'      => FALSE
							);
					$Event = Comp_Load('Events/EventInsert',$Event);
					if(!$Event)
						return ERROR | @Trigger_Error(500);
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			# шлём оповещения, если процент использования больше чем в настройках
			if(Ceil(($Accounts[$Order['Login']]['Used']/$Accounts[$Order['Login']]['Limit'])*100) > IntVal($Settings['DiskUsageNotifiesPercent'])){
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: аккаунт %s/%s, использование %s/%s',$Order['Login'],$Server['Address'],$Accounts[$Order['Login']]['Used'],$Accounts[$Order['Login']]['Limit']));
				#-------------------------------------------------------------------------------
				if(!$Settings['IsNotify'])
					continue;
				#-------------------------------------------------------------------------------
				#-------------------------------------------------------------------------------
				// ссылка на смену тарифа
				$SchemeChangeLink = SPrintF('%s://%s/v2/HostingOrders/%u/SchemeChange/',URL_SCHEME,HOST_ID,$Order['OrderID']);
				#-------------------------------------------------------------------------------
				#-------------------------------------------------------------------------------
				// параметры для передачи в шаблон сообщения
				$Array = Array('Login'=>$Order['Login'],'Used'=>$Accounts[$Order['Login']]['Used'],'Limit'=>$Accounts[$Order['Login']]['Limit'],'SchemeChangeLink'=>$SchemeChangeLink);
				#-------------------------------------------------------------------------------
				// отправляем сообщение
				$IsSend = NotificationManager::sendMsg(new Message('DiskUsageNotice',(integer)$Order['UserID'],Array('Order'=>$Array)));
				#-------------------------------------------------------------------------------
				switch(ValueOf($IsSend)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'exception':
					# No more...
				case 'true':
					# No more...
					break;
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# аккаунты без ограничений на место
		if($Accounts[$Order['Login']]['Limit'] < 1 ){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/GC/DiskUsageNotifies]: аккаунт %s/%s не имеет ограничения на использование диска',$Order['Login'],$Server['Address']));
			#-------------------------------------------------------------------------------
			if($Settings['IsEventForNoLimits']){
				#-------------------------------------------------------------------------------
				$Event = Array(
						'UserID'        => $Order['UserID'],
						'PriorityID'    => 'Warning',
						'Text'          => SPrintF('Обнаружен заказ хостинга (%s/%s) с отсутствующим лимитом на дисковое пространство',$Order['Login'],$Server['Address']),
						'IsReaded'      => FALSE
						);
				$Event = Comp_Load('Events/EventInsert',$Event);
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
	#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
