<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Params');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Where = Array(
		'UNIX_TIMESTAMP() - `CreateDate` > 31 * 24 * 3600',
		"`TypeID` = 'DomainPathRegister'",
		"`IsExecuted` = 'no'"
		);
#-------------------------------------------------------------------------------
$Tasks = DB_Select('Tasks',Array('ID','Params','UserID'),Array('Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($Tasks)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	Debug('[comp/Tasks/GC/DomainPathRegisterNotify]: нет доменов где владелец не определён более 30 дней');
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Tasks as $Task){
		#-------------------------------------------------------------------------------
		$Params = (array)$Task['Params'];
		#-------------------------------------------------------------------------------
		$Columns = Array('ID','DomainName','StatusID','(SELECT `Name` FROM `DomainSchemes` WHERE `DomainSchemes`.`ID` = `DomainOrdersOwners`.`SchemeID`) as `DomainZone`','UserID');
		#-------------------------------------------------------------------------------
		$DomainOrder = DB_Select('DomainOrdersOwners',$Columns,Array('UNIQ','ID'=>$Params['ID']));
		switch(ValueOf($DomainOrder)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			# TODO проверить, может быть имеет смысл вешать событие, с указанием номера таска...
			return new gException('DOMAIN_ORDER_NOT_FOUND','Заказ домена не найден');
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			if($DomainOrder['StatusID'] == 'Deleted'){
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/GC/DomainPathRegisterNotify]: домен %s.%s уже удалён, пропускаем',$DomainOrder['DomainName'],$DomainOrder['DomainZone']));
				#-------------------------------------------------------------------------------
				return TRUE;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			# ставим домену статус "удалён"
			$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'DomainOrders','StatusID'=>'Deleted','RowsIDs'=>$DomainOrder['ID'],'Comment'=>'Владелец домена не определён более 30 дней'));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Comp)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return ERROR | @Trigger_Error(400);
			case 'array':
				# No more...
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$Event = Array(
					'UserID'        => $DomainOrder['UserID'],
					'PriorityID'    => 'Hosting',
					'Text'          => SPrintF('Владелец домена %s.%s не определён более 30 дней, заказ автоматически удалён',$DomainOrder['DomainName'],$DomainOrder['DomainZone'])
					);
			$Event = Comp_Load('Events/EventInsert',$Event);
			#-------------------------------------------------------------------------------
			if(!$Event)
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
