<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Params');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('classes/HostingServer.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['GC']['EmailBoxesNotifiesSettings'];
#-------------------------------------------------------------------------------
$Regulars = Regulars();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Settings['IsActive'])
	return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Servers = DB_Select('Servers','*',Array('Where'=>'(SELECT `ServiceID` FROM `ServersGroups` WHERE `Servers`.`ServersGroupID` = `ServersGroups`.`ID`) = 10000','SortOn'=>'Address'));
#-------------------------------------------------------------------------------
switch(ValueOf($Servers)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	# No more...
	return TRUE;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
foreach($Servers as $Server){
	#-------------------------------------------------------------------------------
	#if($Server['Address'] != 'brainy.test-hf.su')
	#	continue;
	#-------------------------------------------------------------------------------
	if(!$Server['IsActive'])
		continue;
	#-------------------------------------------------------------------------------
	$ClassHostingServer = new HostingServer();
	#-------------------------------------------------------------------------------
	$IsSelected = $ClassHostingServer->Select((integer)$Server['ID']);
	#-------------------------------------------------------------------------------
	switch(ValueOf($IsSelected)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'true':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Users = $ClassHostingServer->GetEmailBoxes();
	#-------------------------------------------------------------------------------
	switch(ValueOf($Users)){
	case 'error':
		# No more...
	case 'exception':
		# No more...
		continue 2;
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!Count($Users))
		continue;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Array = Array();
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Users) as $UserID)
		$Array[] = SPrintF("'%s'",$UserID);
	#-------------------------------------------------------------------------------
	$Where = SPrintF('`ServerID` = %u AND `Login` IN (%s)',$Server['ID'],Implode(',',$Array));
	#-------------------------------------------------------------------------------
	$HostingOrders = DB_Select('HostingOrdersOwners',Array('ID','UserID','Login'),Array('Where'=>$Where));
	#-------------------------------------------------------------------------------
	switch(ValueOf($HostingOrders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		continue 2;
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	foreach($HostingOrders as $HostingOrder){
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[comp/Tasks/GC/EmailBoxesNotifies] HostingOrder.Login = %s',$HostingOrder['Login']));
		#-------------------------------------------------------------------------------
		$Boxes = $Users[$HostingOrder['Login']];
		#-------------------------------------------------------------------------------
		foreach($Boxes as $Email=>$Box){
			#-------------------------------------------------------------------------------
			$Total = Next($Box);
			if(!$Total)
				continue;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			#Debug(SPrintF('[comp/Tasks/GC/EmailBoxesNotifies] HostingOrder.Login = %s; Email = %s',$HostingOrder['Login'],$Email));
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$Pieces = Explode('@',$Email);
			#-------------------------------------------------------------------------------
			$IDNA = new Net_IDNA();
			#-------------------------------------------------------------------------------
			$Email = SPrintF('%s@%s',$Pieces[0],$IDNA->encode($Pieces[1]));
			#-------------------------------------------------------------------------------
			if(!Preg_Match($Regulars['Email'],$Email))
				continue;
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$Used = Prev($Box);
			#-------------------------------------------------------------------------------
			$Usage = Round(($Used/$Total)*100,2);
			#-------------------------------------------------------------------------------
			if($Usage > $Settings['EmailBoxesNotifiesPercent'] && $Usage < 100 /*&& 1 == 2*/){
				#-------------------------------------------------------------------------------
				// готовим сообщение и отпрaвляем
				// TODO подумать над настройками. сейчас это на ящики уходят, если передалать на NotificationManager - будет уходить владельцам аккаунтов, но, они смогут это отключать
				$Params = Array();
				#-------------------------------------------------------------------------------
				$Params[] = $Email;
				$Params[] = TemplateReplace('Tasks.GC.EmailBoxesNotifies',Array('Email'=>$Email,'Usage'=>$Usage),FALSE);
				$Params[] = Array(
						'Theme'		=> 'Квота почтового ящика',
						'From'		=> Array('Email'=>SPrintF('admin@%s',$Server['Address']),'Name'=>'Системный Администратор'),
						'Attachments'	=> Array(),
						'UserID'	=> $HostingOrder['UserID'],
						//'Contact'	=> Array('UserID'=>$HostingOrder['UserID'],'Address'=>,'MethodID'=>'Email','TimeBegin'=>0,'TimeEnd'=>0),
						'IsImmediately'	=> TRUE,	// не проверять время отправки, чтобы не искал данные контакта
						'ChargeFree'	=> FALSE,
						//'ExternalID'	=> '',
						//'ContactID'	=> 0,		// в отпрaвке почты не юзается
						'UserName'	=> 'владелец почтового ящика'
						);
				#-------------------------------------------------------------------------------
				$taskParams = Array(
							'UserID'	=> $HostingOrder['UserID'],
							'TypeID'	=> 'Email',
							'Params'	=> $Params
							);
				#-------------------------------------------------------------------------------
				#-------------------------------------------------------------------------------
				$IsAdd = Comp_Load('www/Administrator/API/TaskEdit',$taskParams);
				#-------------------------------------------------------------------------------
				switch(ValueOf($IsAdd)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'exception':
					return ERROR | @Trigger_Error(400);
				case 'array':
					# No more...
					break;
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
