<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Task');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
#-------------------------------------------------------------------------------
#------------------------------------------------------------------------------
$Config = Config();
#------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['ServersAutoBalance'];
#------------------------------------------------------------------------------
$ExecuteTime = Comp_Load('Formats/Task/ExecuteTime',Array('ExecutePeriod'=>$Settings['ExecutePeriod']));
if(Is_Error($ExecuteTime))
	return ERROR | @Trigger_Error(500);
#------------------------------------------------------------------------------
# если неактивна, то через день запуск
if(!$Settings['IsActive'])
	return MkTime(2,50,0,Date('n'),Date('j')+1,Date('Y'));
#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
# проверяем наличие серверов хостинга с включенной автобалансировкой
$Servers = DB_Select('Servers',Array('ID','Params'),Array('Where'=>'`ServersGroupID` IS NOT NULL','SortOn'=>Array('ServersGroupID','Address')));
#------------------------------------------------------------------------------
switch(ValueOf($Servers)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#------------------------------------------------------------------------------
	Debug('[comp/Tasks/ServersAutoBalance]: no servers in servers groups, go to next day');
	#------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'] = 'No servers in groups';
	#------------------------------------------------------------------------------
	return MkTime(2,50,0,Date('n'),Date('j')+1,Date('Y'));
	#------------------------------------------------------------------------------
	break;
	#------------------------------------------------------------------------------
case 'array':
	#------------------------------------------------------------------------------
	$Count = 0;
	#------------------------------------------------------------------------------
	foreach($Servers as $Server)
		if(IsSet($Server['Params']['IsAutoBalancing']) && $Server['Params']['IsAutoBalancing'])
			$Count++;
	#-------------------------------------------------------------------------------
	if($Count < 1){
		#-------------------------------------------------------------------------------
		Debug('[comp/Tasks/ServersAutoBalance]: вообще нет серверов для автобалансировки');
		#------------------------------------------------------------------------------
		$GLOBALS['TaskReturnInfo'] = 'No servers for AutoBalance';
		#-------------------------------------------------------------------------------
		return MkTime(2,50,0,Date('n'),Date('j')+1,Date('Y'));
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: для автобалансировки: %u сервер(-ов)',$Count));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# перебираем группы серверов, ищщем те где автобалансировка не отключена
$ServersGroups = DB_Select('ServersGroups',Array('*'),Array('Where'=>'`FunctionID` != "NotDefined"'));
switch(ValueOf($ServersGroups)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	Debug('[comp/Tasks/ServersAutoBalance]: no groups with enabled autobalasing, go to next day');
	#-------------------------------------------------------------------------------
	$GLOBALS['TaskReturnInfo'] = 'No servers groups with enabled AutoBalance';
	#-------------------------------------------------------------------------------
	return MkTime(2,50,0,Date('n'),Date('j')+1,Date('Y'));
	#-------------------------------------------------------------------------------
case 'array':
	# All OK, servers found
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$GLOBALS['TaskReturnInfo'] = Array();
#-------------------------------------------------------------------------------
foreach($ServersGroups as $ServersGroup){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: обработка группы #%s, %s',$ServersGroup['ID'],$ServersGroup['Name']));
	#-------------------------------------------------------------------------------
	# выбираем все активные сервера этой группы
	$Columns = Array(
			'ID','Address','IsDefault','Params','IsOK',
			'(SELECT COUNT(*) FROM `OrdersOwners` WHERE `ServerID` = `Servers`.`ID` AND `StatusID` = "Active") AS `AccountsActive`',
			'(SELECT COUNT(*) FROM `OrdersOwners` WHERE `ServerID` = `Servers`.`ID` AND (`StatusID` = "Active" OR `StatusID` = "Suspended")) AS `AccountsAll`'
			);
	#-------------------------------------------------------------------------------
	$Servers = DB_Select('Servers',$Columns,Array('Where'=>SPrintF('`IsActive` = "yes" AND `ServersGroupID` = %u',$ServersGroup['ID'])));
	switch(ValueOf($Servers)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		#-------------------------------------------------------------------------------
		# в этой группе нет активных сервeров, ничего не делаем
		Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: группа #%u (%s) не имеет активных серверов',$ServersGroup['ID'],$ServersGroup['Name']));
		break;
		#-------------------------------------------------------------------------------
	case 'array':
		#-------------------------------------------------------------------------------
		# убираем из массива сервера, у которых не стоит галка про автобалансировку
		foreach(Array_Keys($Servers) as $Key)
			if(!IsSet($Servers[$Key]['Params']['IsAutoBalancing']) || !$Servers[$Key]['Params']['IsAutoBalancing'])
				UnSet($Servers[$Key]);
		#-------------------------------------------------------------------------------
		#Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: Servers = %s',print_r($Servers,true)));
		#-------------------------------------------------------------------------------
		if(SizeOf($Servers) < 1){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: группа #%u (%s) не имеет серверов с включённой автобалансировкой',$ServersGroup['ID'],$ServersGroup['Name']));
			#-------------------------------------------------------------------------------
			continue 2;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# убираем из массива сервера, у которых не 100% аптайм
		foreach(Array_Keys($Servers) as $Key){
			#-------------------------------------------------------------------------------
			if(Is_Null($Servers[$Key]['IsOK']) || $Servers[$Key]['IsOK'] != 100){
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: сервер %s исключён из автобалансировки, аптайм = %s%%',$Servers[$Key]['Address'],$Servers[$Key]['IsOK']));
				#-------------------------------------------------------------------------------
				UnSet($Servers[$Key]);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: Servers = %s',print_r($Servers,true)));
		#-------------------------------------------------------------------------------
		if(SizeOf($Servers) < 1){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: группа #%u (%s) не имеет сереров со 100%% аптайма',$ServersGroup['ID'],$ServersGroup['Name']));
			#-------------------------------------------------------------------------------
			continue 2;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# высчитываем Primary сервер, в зависимости от алгоритма
		$LA = Array();	// Load Averrage
		$SN = Array();	// Servers Names
		#-------------------------------------------------------------------------------
		if($ServersGroup['FunctionID'] == 'ByAllCapacity'){
			#-------------------------------------------------------------------------------
			foreach($Servers as $Server){
				#-------------------------------------------------------------------------------
				$LA[$Server['ID']] =  $Server['AccountsAll'] / $Server['Params']['BalancingFactor'];
				#-------------------------------------------------------------------------------
				$SN[$Server['ID']] =  $Server['Address'];
				#-------------------------------------------------------------------------------
				# remember primary server
				if($Server['IsDefault'])
					$IsDefault = $Server['Address'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$MaxLA    = Max($LA);
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[comp/Tasks/ServersAutoBalance]: %s / MaxLA = %s',$ServersGroup['Name'],$MaxLA));
			#-------------------------------------------------------------------------------
			foreach ($LA as $key => $value)
			{
				#-------------------------------------------------------------------------------
				Debug("[comp/Tasks/ServersAutoBalance]: $key => $value");
				#-------------------------------------------------------------------------------
		        	if($value <= $MaxLA){
					#-------------------------------------------------------------------------------
					$ServerID = $key;
					#-------------------------------------------------------------------------------
					$MaxLA = $value;
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}elseif($ServersGroup['FunctionID'] == 'ByActiveCapacity'){
			#-------------------------------------------------------------------------------
			foreach($Servers as $Server){
				#-------------------------------------------------------------------------------
				$LA[$Server['ID']] =  $Server['AccountsActive'] / $Server['Params']['BalancingFactor'];
				#-------------------------------------------------------------------------------
				$SN[$Server['ID']] =  $Server['Address'];
				#-------------------------------------------------------------------------------
				# remember primary server
				if($Server['IsDefault'])
					$IsDefault = $Server['Address'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$MaxLA    = Max($LA);
			Debug("[comp/Tasks/ServersAutoBalance]: MaxLA = $MaxLA");
			#-------------------------------------------------------------------------------
			foreach ($LA as $key => $value)
			{
				#-------------------------------------------------------------------------------
				Debug("[comp/Tasks/ServersAutoBalance]: $key => $value");
		        	if($value <= $MaxLA){
					#-------------------------------------------------------------------------------
					$ServerID = $key;
					#-------------------------------------------------------------------------------
					$MaxLA = $value;
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}elseif($ServersGroup['FunctionID'] == 'ByRandom'){
			#-------------------------------------------------------------------------------
			foreach($Servers as $Server){
				#-------------------------------------------------------------------------------
				$LA[$Server['ID']] = $Server['AccountsAll'] / $Server['Params']['BalancingFactor'];
				#-------------------------------------------------------------------------------
				$SN[$Server['ID']] =  $Server['Address'];
				#-------------------------------------------------------------------------------
				# remember primary server
				if($Server['IsDefault'])
					$IsDefault = $Server['Address'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$ServerID = Array_Rand($LA,1);
			#-------------------------------------------------------------------------------
			#Debug(SPrintF("[comp/Tasks/ServersAutoBalance]: ServerKey = %s",$ServerKey));
			#-------------------------------------------------------------------------------
			#$ServerID = $LA[$ServerKey];
			Debug(SPrintF("[comp/Tasks/ServersAutoBalance]: ServerID = %s",$ServerID));
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			# неизвестный алгоритм / отключено
			Debug(SPrintF("[comp/Tasks/ServersAutoBalance]: группа #%u (%s) имеет неиспользуемый алгоритм: %s",$ServersGroup['ID'],$ServersGroup['Name'],$ServersGroup['FunctionID']));
			break;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		# проверяем - сменился ли сервер
		if(!IsSet($IsDefault) || $IsDefault != $SN[$ServerID]){
			#-------------------------------------------------------------------------------
			Debug(SPrintF("[comp/Tasks/ServersAutoBalance]: группа #%u (%s), первичный сервер %s, с использованием алгоритма '%s'",$ServersGroup['ID'],$ServersGroup['Name'],$SN[$ServerID],$ServersGroup['FunctionID']));
			#-------------------------------------------------------------------------------
			# обновляем таблицу серверов, выставляем первичный сервер
			$IsUpdate = DB_Update('Servers',Array('IsDefault'=>FALSE),Array('Where'=>SPrintF('`ServersGroupID` = %u',$ServersGroup['ID'])));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------
			$IsUpdate = DB_Update('Servers',Array('IsDefault'=>TRUE),Array('ID'=>$ServerID));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------
			if($Settings['IsEvent']){
				#-------------------------------------------------------------------------------
				$Event = Array(
						'UserID'        => 1,
						'PriorityID'    => 'Hosting',
						'Text'          => SPrintF('Замена основного сервера группы %s (%s=>%s)',$ServersGroup['Name'],(IsSet($IsDefault)?$IsDefault:'UnSeted'),$SN[$ServerID])
						);
				#-------------------------------------------------------------------------------
				$Event = Comp_Load('Events/EventInsert',$Event);
				if(!$Event)
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$GLOBALS['TaskReturnInfo'][$ServersGroup['Name']] = Array($SN[$ServerID]);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		Debug(SPrintF("[comp/Tasks/ServersAutoBalance]: LA = %s",print_r($LA,true)));
		# JBS-888
		foreach ($LA as $key => $value){
			#-------------------------------------------------------------------------------
			Debug("[comp/Tasks/ServersAutoBalance]: LA $key => $value");
			#-------------------------------------------------------------------------------
			$Server = DB_Select('Servers',Array('ID','Params'),Array('UNIQ','ID'=>$key));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Server)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return new gException('SERVER_NOT_FOUND','Сервер не найден');
			case 'array':
				# No more...
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			$Server['Params']['BalancingFactorAuto'] = $value;
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('Servers',Array('Params'=>$Server['Params']),Array('ID'=>$Server['ID']));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	UnSet($IsDefault);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $ExecuteTime;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
