<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$ISPswOrderID	= (integer) @$Args['ISPswOrderID'];
$LicenseID	= (integer) @$Args['LicenseID'];
$remoteip	=  (string) @$Args['remoteip'];
$IP		=  (string) @$Args['IP'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','libs/BillManager.php','libs/Server.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
# get config values
$Config = Config();
#-------------------------------------------------------------------------------
$Regulars = Regulars();
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Settings = SelectServerSettingsByService(51000);
#-------------------------------------------------------------------------------
if(!Is_Array($Settings))
	return SelectServerErrorMessage(51000);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$IP && $remoteip)
	$IP = $remoteip;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/www/API/ISPswChangeIP]: IP = %s; remoteip = %s',$IP,$remoteip));
#-------------------------------------------------------------------------------
if(!Preg_Match($Regulars['IP'],$IP))
	return new gException('WRONG_IP','Неверно указан новый IP адрес лицензии');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!Preg_Match($Regulars['IP'],$remoteip))
	return new gException('WRONG_REMOTEIP','Неверно указан IP адрес сервера');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Columns = Array(
		'ID','OrderID','UserID','StatusID','IP',
		'(SELECT `pricelist_id` FROM `ISPswSchemes` WHERE `ISPswOrdersOwners`.`SchemeID`=`ISPswSchemes`.`ID`) AS `pricelist_id`',
		'(SELECT `period` FROM `ISPswSchemes` WHERE `ISPswOrdersOwners`.`SchemeID`=`ISPswSchemes`.`ID`) AS `period`',
		'(SELECT `Email` FROM `Users` WHERE `ISPswOrdersOwners`.`UserID` = `Users`.`ID` ) AS `OwnerEmail`'
		);
#-------------------------------------------------------------------------------
$ISPswOrder = DB_Select('ISPswOrdersOwners',$Columns,Array('UNIQ','ID'=>$ISPswOrderID));
#-------------------------------------------------------------------------------
switch(ValueOf($ISPswOrder)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
if($ISPswOrder['StatusID'] != 'Active')
	return new gException('HOSTING_ORDER_NOT_ACTIVE','Заказ ПО не активен');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ISPswOrder['IP'] == $IP && $IP == $remoteip)
	return new gException('OLD_IP_MATCH_WITH_NEW_IP','IP адрес совпадает со старым IP адресом');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$IsPermission = Permission_Check('ISPswManage',(integer)$__USER['ID'],(integer)$ISPswOrder['UserID']);
#-------------------------------------------------------------------------------
switch(ValueOf($IsPermission)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'false':
	return ERROR | @Trigger_Error(700);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
# проверяем, можно ли менять IP для этой лицензии
# 1. внутренним, могут менять только сотрудники
# 2. время - прошёл ли 31 день от последней смены адреса
$ISPswLicense = DB_Select('ISPswLicenses',Array('*'),Array('UNIQ','ID'=>$LicenseID));
switch(ValueOf($ISPswLicense)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	# license found
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
if(!$__USER['IsAdmin'] && $ISPswLicense['IsInternal'])
	return new gException('INTERNAL_LICENSE','Данная лицензия предназначена для использования на заказах VPS и выделенных серверов. Вы не можете изменить её IP адрес. Если вам нужна лицензия для другого заказа VPS или выделенного сервера - сделайте заказ на новую лицензию.');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$m_time = $ISPswLicense['ip_change_date'] + 31 * 24 * 3600 - Time();
#-------------------------------------------------------------------------------
if($m_time > 0){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Formats/Date/Remainder', $m_time);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	return new gException('LICENSE_PERIOD_NOT_EXCESSED',SPrintF('IP адрес лицензии можно менять один раз в месяц. До момента когда его можно будет сменить, осталось %s',$Comp));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(DB_Transaction($TransactionID = UniqID('ISPswChangeIP'))))
	return ERROR | @Trigger_Error(500);
#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
if($ISPswLicense['IsInternal']){
	#-------------------------------------------------------------------------------
	$LicComment = "INTERNAL, order #" . $ISPswOrder['OrderID'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$LicComment = "EXTERNAL, order #" . $ISPswOrder['OrderID'] . ", for " . $ISPswOrder['OwnerEmail'];
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$ISPswScheme = Array(
			'pricelist_id'	=> $ISPswOrder['pricelist_id'],
			'period'	=> $ISPswOrder['period'],
			'IP'		=> $IP,
			'remoteip'	=> (($remoteip == $IP)?'':$remoteip),
			'LicComment'	=> $LicComment,
			'IsInternal'	=> $ISPswLicense['IsInternal']
		);
#-------------------------------------------------------------------------------
# если лицензия внутренняя - ищщем свободную, или заказываем новую
if($ISPswLicense['IsInternal']){
	#-------------------------------------------------------------------------------
	$License = BillManager_Find_Free_License($ISPswScheme);
	#-------------------------------------------------------------------------------
	if($License){
		#-------------------------------------------------------------------------------
		$elid = $License['elid'];
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[comp/Tasks/ISPswCreate]: found free license, elid = %u',$elid));
		#-------------------------------------------------------------------------------
		$ISPswScheme['elid'] = $elid;
		#-------------------------------------------------------------------------------
		# меняем IP лицензии
		if(BillManager_Change_IP($Settings,$ISPswScheme)){
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('ISPswLicenses',Array('UpdateDate'=>Time(),'IsUsed'=>TRUE,'ip'=>$ISPswScheme['IP']),Array('Where'=>SPrintF('`elid` = %u',$elid)));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		# разблокируем
		if(!BillManager_UnLock($Settings,$ISPswScheme))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		# всё путём, лицензия создана
		$IsCreate = TRUE;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		# свободная лицензия не найдена, надо заказывать
		$IsCreate = BillManager_Create($Settings,$ISPswScheme);
		#-------------------------------------------------------------------------------
		if($IsCreate){
			#-------------------------------------------------------------------------------
			# помечаем старую лицензию как свободную
			$IsUpdate = DB_Update('ISPswLicenses',Array('IsUsed'=>'no','IsInternal'=>'yes','Flag'=>''),Array('ID'=>$LicenseID));
			#-------------------------------------------------------------------------------
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	# если лицензия внешняя, проверяем новый IP, и меняем адресок
	if(!BillManager_Check_ISPsystem_IP($Settings, $ISPswScheme))
		if(!$remoteip)
			return new gException('ISPsw_IP_ADDRESS_IN_USE',SPrintF('Для указанного IP адреса [%s] уже есть лицензия такого типа. За более подробной информацией, обратитесь в службу поддержки пользователей',$IP));
	#-------------------------------------------------------------------------------
	$ISPswScheme['elid'] = $ISPswLicense['elid'];
	#-------------------------------------------------------------------------------
	$IsCreate = BillManager_Change_IP($Settings,$ISPswScheme);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
switch(ValueOf($IsCreate)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return new gException('CANNOT_ORDER_LICENSE','При смене IP произошла непредвиденная ошибка. При повторении данного сообщения, обратитесь в службу поддержки пользователей, указав последовательность ваших действий.');
case 'true':
	break;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# меняем IP в заказе софта
$IsUpdate = DB_Update('ISPswOrders',Array('IP'=>$IP),Array('ID'=>$ISPswOrderID));
if(Is_Error($IsUpdate))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('www/API/StatusSet',Array('ModeID'=>'ISPswOrders','StatusID'=>'Active','RowsIDs'=>$ISPswOrder['ID'],'Comment'=>"IP адрес лицензии изменён [" . $ISPswOrder['IP'] . "->" . $IP . "]"));
#-------------------------------------------------------------------------------
switch(ValueOf($Comp)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$Event = Array(
		'UserID'	=> $ISPswOrder['UserID'],
		'PriorityID'	=> 'Hosting',
		'Text'		=> SPrintF('IP адрес лицензии изменён [%s->%s]',$ISPswOrder['IP'],$IP),
		);
$Event = Comp_Load('Events/EventInsert',$Event);
if(!$Event)
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(DB_Commit($TransactionID)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
