<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$IsInternal = IsSet($Args);
#-------------------------------------------------------------------------------
if(!IsSet($Args))
        $Args = Args();
#-------------------------------------------------------------------------------
$Orders		=   (array) @$Args['Orders'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!Is_Array($Orders))
	$Orders = Array($Orders);
#-------------------------------------------------------------------------------
/* раз в минуту? */
$UpdateInterval = 30;
#-------------------------------------------------------------------------------
// если это не внутренний запрос, надо проверить присланное, и добавить таймаут обновления
if(!$IsInternal){
	#-------------------------------------------------------------------------------
	if(SizeOf($Orders) < 1)
		return new gException('ACCOUNT_IS_EMPTY','Не указан аккаунт');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Cache = SPrintF('%s-s',Current($Orders),@$_SERVER['REMOTE_ADDR']);
	#-------------------------------------------------------------------------------
	$Result = CacheManager::get($Cache);
	#-------------------------------------------------------------------------------
	if($Result){
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Formats/Date/Remainder',$UpdateInterval + $Result - Time());
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		return new gException('STATISTIC_UPDATE_INTERVAL_NOT_EXPIRED', SPrintF("Статистика обновлятся не в режиме реального времени, следующий запрос на обновление вы сможете сделать через %s",$Comp));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Regulars = Regulars();
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		if(!Preg_Match($Regulars['Number'],$Order))
			return new gException('BAD_ACCOUNT', SPrintF("Неверный аккаунт: %s",$Order));
		#-------------------------------------------------------------------------------
		$Count = DB_Count('OrdersOwners',Array('ID'=>$Order));
		if(!$Count)
			return new gException('BAD_ORDER_ID', SPrintF("Неверный аккаунт: %s",$Order));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------

}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// определяем услугу по номеру заказа, достаём сервер
$Service = DB_Select('OrdersOwners',Array('ServerID','(SELECT `Code` FROM `Services` WHERE `Services`.`ID` = `OrdersOwners`.`ServiceID`) AS `Code`'),Array('Where'=>SPrintF('`OrderID` IN (%u)',Implode(',',$Orders)),'Limits'=>Array(0,1),'UNIQ'));
#-------------------------------------------------------------------------------
switch(ValueOf($Service)){
case 'error':
        return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
        break;
default:
        return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
/*
// у выделенных серверов IP адреса к тому же серверу относятся...
if(!In_Array($Service['Code'],Array('Hosting','VPS','DS'))){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/API/UpdateResourcesUsed]: неизвестный код Code = %s;',$Service['Code']));
	#-------------------------------------------------------------------------------
	return Array('Status'=>'Ok');
	#-------------------------------------------------------------------------------
}*/
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
//Debug(SPrintF('[comp/www/API/UpdateResourcesUsed]: Code = %s; ServerID = %u, Orders = %s',$Service['Code'],$Service['ServerID'],print_r($Orders,TRUE)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// загружаем класс этой услуги
if(Is_Error(System_Load('modules/Authorisation.mod',SPrintF('classes/%sServer.class.php',$Service['Code']))))
        return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// настройки графиков
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Tasks']['Types']['ServerAccountsResources'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// цепляем класс для этой услуги
$ClassName = SPrintF('%sServer',$Service['Code']);
#-------------------------------------------------------------------------------
$ClassServer = new $ClassName();
#-------------------------------------------------------------------------------
// если это выделенный сервер - достаём тариф
if($Service['Code'] == 'DS'){
	#-------------------------------------------------------------------------------
	$Scheme = DB_Select(SPrintF('%sOrdersOwners',$Service['Code']),'SchemeID',Array('Where'=>SprintF('`OrderID` = %u',Current($Orders)),'UNIQ'));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Scheme)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$IsSelected = $ClassServer->Select((integer)$Service['ServerID'],$Scheme['SchemeID']);
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$IsSelected = $ClassServer->Select((integer)$Service['ServerID']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
switch(ValueOf($IsSelected)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// достаём список аккаунтов на сервере
$Columns = Array('ID','OrderID','UserID');
$Columns[] = ($Service['Code'] != 'DS')?'Login':'`OrderID` AS `Login`';
$Accounts = DB_Select(SPrintF('%sOrdersOwners',$Service['Code']),$Columns,Array('Where'=>SPrintF('`OrderID` IN (%s)',Implode(',',$Orders))));
#-------------------------------------------------------------------------------
switch(ValueOf($Accounts)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	// исключение, просто возвращаем TRUE
	if(IsSet($Cache))
		CacheManager::add($Cache,Time(),$UpdateInterval);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// строим список пользователей, запрашиваем ресурсы
$Users = Array();
#-------------------------------------------------------------------------------
foreach($Accounts as $Account)
	$Users[] = $Account['Login'];
#-------------------------------------------------------------------------------
$Usage = $ClassServer->GetAccountUsage($Users);
#-------------------------------------------------------------------------------
switch(ValueOf($Usage)){
case 'error':
	# No more...
case 'exception':
	#-------------------------------------------------------------------------------
	// ошибка/исключение, просто возвращаем TRUE
	if(IsSet($Cache))
		CacheManager::add($Cache,Time(),$UpdateInterval);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#if($Service['Code'] == 'DS')
#	Debug(SPrintF('[comp/www/API/UpdateResourcesUsed]: Usage = %s',print_r($Usage,TRUE)));
#-------------------------------------------------------------------------------
// может не быть юзеров на сервере
if(SizeOf($Usage) < 1){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/API/UpdateResourcesUsed]: нет юзеров, Code = %s; ServerID = %u, Orders = %s',$Service['Code'],$Service['ServerID'],print_r($Orders,TRUE)));
	#-------------------------------------------------------------------------------
	return Array('Status'=>'Ok');
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// юзеры - эт строки, надо экраинировать
$Users = Array();
#-------------------------------------------------------------------------------
foreach(Array_Keys($Usage) as $User)
	$Users[] = SPrintF("'%s'",$User);
#-------------------------------------------------------------------------------
// достаём список заказов с этими номерами заказов
$Columns = Array(
		'ID','OrderID','UserID',
		SPrintF("(SELECT `Params` FROM `TmpData` USE INDEX(`AppID_Col1`) WHERE `AppID` = 'Order.Statistics' AND `%sOrdersOwners`.`OrderID` = `TmpData`.`Col1` LIMIT 1) AS `Params`",$Service['Code']),
		SPrintF("(SELECT `ID` FROM `TmpData` WHERE `AppID` = 'Order.Statistics' AND `%sOrdersOwners`.`OrderID` = `TmpData`.`Col1` LIMIT 1) AS `TmpDataID`",$Service['Code']),
		);
$Columns[] = ($Service['Code'] == 'DS')?'`OrderID` AS `Login`':'Login';
#-------------------------------------------------------------------------------
// у выделенных по номеру заказа выбираем
$Where = ($Service['Code'] == 'DS')?SPrintF('`OrderID` IN (%s)',Implode(',',Array_Keys($Usage))):SPrintF('`Login` IN (%s)',Implode(',',$Users));
$Accounts = DB_Select(SPrintF('%sOrdersOwners',$Service['Code']),$Columns,Array('Where'=>$Where,'SortOn'=>'TmpDataID'));
#-------------------------------------------------------------------------------
switch(ValueOf($Accounts)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	#-------------------------------------------------------------------------------
	// исключение, просто возвращаем TRUE
	if(IsSet($Cache))
		CacheManager::add($Cache,Time(),$UpdateInterval);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// массив с описанием графиков
$Graphs = $Config['Other']['Graphs'];
#-----------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// перебирем заказы
foreach($Accounts as $Account){
	#-------------------------------------------------------------------------------
	$iParams = Array();
	#-------------------------------------------------------------------------------
	// статистики нет, делаем пустые массивы
	if(!Is_Array($Account['Params']))
		$iParams = Array('Last'=>Array(),'Graphs'=>Array());
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// вариантов всего два - прилетели графики, или прилетели последние покзания
	if(IsSet($Usage[$Account['Login']]['Last'])){
		#-------------------------------------------------------------------------------
		// перебираем последние данные, вносим их и добавляем к графикам
		foreach(Array_Keys($Usage[$Account['Login']]['Last']) as $Key){
			#-------------------------------------------------------------------------------
			// Вносим последний лимит, при необходимости
			if(In_Array($Key,Explode(',',$Settings['Last'])))
				$iParams['Last'][$Key] = $Usage[$Account['Login']]['Last'][$Key];
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			// если такого графика в списке нет - пропускаем
			if(!In_Array($Key,Explode(',',$Settings['Graphs'])))
				continue;
			#-------------------------------------------------------------------------------
			if(!IsSet($iParams['Graphs']))
				$iParams['Graphs'] = Array();
			#-------------------------------------------------------------------------------
			if(!IsSet($iParams['Graphs'][$Key]))
				$iParams['Graphs'][$Key] = Array();
			#-------------------------------------------------------------------------------
			// вносим предыдущие значения
			if(IsSet($Account['Params']['Graphs'][$Key]['Data']))
				$iParams['Graphs'][$Key]['Data'] = $Account['Params']['Graphs'][$Key]['Data'];
			#-------------------------------------------------------------------------------
			// добавляем текущие значения, время округляем до минуты
			$iParams['Graphs'][$Key]['Data'][Round(Time()/60)*60] = $Usage[$Account['Login']]['Last'][$Key]['Used'];
			#-------------------------------------------------------------------------------
			// добавляем аттрибуты графиков
			$iParams['Graphs'][$Key]['Limit'] = $Usage[$Account['Login']]['Last'][$Key]['Limit'];
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		// перебираем графики
		foreach(Array_Keys($Usage[$Account['Login']]['Graphs']) as $Key){
			#-------------------------------------------------------------------------------
			// если необходимо, вносим графики
			if(In_Array($Key,Explode(',',$Settings['Graphs']))){
				#-------------------------------------------------------------------------------
				// если есть старые графики, надо к ним добавить новые значения
				// проверяем по наличию хоть каких-то данных в массиве с графиками
				if(IsSet($Account['Params']['Graphs'][$Key]['Data']) && SizeOf($Account['Params']['Graphs'][$Key]['Data']) > 0){
					#-------------------------------------------------------------------------------
					// графики есть, надо объединить старые и новые
					// вносим в выходной массив старые данные
					$iParams['Graphs'][$Key] = $Account['Params']['Graphs'][$Key];
					#-------------------------------------------------------------------------------
					#-------------------------------------------------------------------------------
					// ключи старого массива, для проверки ключей из свежих данных
					$OldKeys = Array_Keys($iParams['Graphs'][$Key]['Data']);
					#-------------------------------------------------------------------------------
					// перебираем новый массив, проверяем наличие графика за такое время в старом
					// если нет - добавляем данные в выходной массив
					foreach(Array_Keys($Usage[$Account['Login']]['Graphs'][$Key]['Data']) as $KeyNew)
						if(!In_Array($KeyNew,Array_Keys($iParams['Graphs'][$Key]['Data'])))
							$iParams['Graphs'][$Key]['Data'][$KeyNew] = $Usage[$Account['Login']]['Graphs'][$Key]['Data'][$KeyNew];
					#-------------------------------------------------------------------------------
				}else{
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[comp/www/API/UpdateResourcesUsed]: нет графиков для %s',$Key));
					#-------------------------------------------------------------------------------
					// графиков нет, просто вносим массив что пришёл из опроса
					$iParams['Graphs'][$Key] = $Usage[$Account['Login']]['Graphs'][$Key];
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				// обновляем лимиты - больше по идее ничего не приходит из библиотеки
				$iParams['Graphs'][$Key]['Limit'] = $Usage[$Account['Login']]['Graphs'][$Key]['Limit'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// вносим последний лимит, если необходимо
			if(In_Array($Key,Explode(',',$Settings['Last']))){
				#-------------------------------------------------------------------------------
				// вносим график
				$iParams['Last'][$Key] = $Usage[$Account['Login']]['Graphs'][$Key];
				#-------------------------------------------------------------------------------
				// удаляем Data
				UnSet($iParams['Last'][$Key]['Data']);
				#-------------------------------------------------------------------------------
				// прописываем последнее значение из тех что в графиках
				$iParams['Last'][$Key]['Used'] = Round(End($Usage[$Account['Login']]['Graphs'][$Key]['Data']),2);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем параметры в iParams['Graphs'], удаляем самые старые записи если их более.... ну 10k
	if(IsSet($iParams['Graphs']) && SizeOf($iParams['Graphs'])> 0){
		#-------------------------------------------------------------------------------
		foreach(Array_Keys($iParams['Graphs']) as $Key){
			#-------------------------------------------------------------------------------
			if(SizeOf($iParams['Graphs'][$Key]) < 10000)
				continue;
			#-------------------------------------------------------------------------------
			// разворачиваем массив в обратную сторону - не нашёл способа не побив индексы удалить элементы из начала
			$Array = Array_Reverse($iParams['Graphs'][$Key],TRUE);
			#-------------------------------------------------------------------------------
			// удаляем последние элементы пока не дойдём до лимита
			while(10000 <= SizeOf($Array))
				Array_Pop($Array);
			#-------------------------------------------------------------------------------
			// разворачиваем обратно и кладём на место
			$iParams['Graphs'][$Key] = Array_Reverse($Array,TRUE);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$iParams['UpdateDate'] = Date('Y-m-d H:i:s');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(Is_Numeric($Account['TmpDataID'])){
		#-------------------------------------------------------------------------------
		// обновляем
		$IsUpdate = DB_Update('TmpData',Array('Params'=>$iParams,'Col2'=>$Service['ServerID']),Array('ID'=>$Account['TmpDataID']));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		// вставляем
		$IsInsert = DB_Insert('TmpData',Array('AppID'=>'Order.Statistics','Col1'=>$Account['OrderID'],'Col2'=>$Service['ServerID'],'Params'=>$iParams));
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Cache))
	CacheManager::add($Cache,Time(),$UpdateInterval);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

