<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$IsSensors	= (boolean) @$Args['IsSensors'];
$OrderID	= (integer) @$Args['OrderID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','libs/IPMI.SuperMicro.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// список колонок которые юзеру не показываем
$Config = Config();
#-------------------------------------------------------------------------------
$Exclude = Array_Keys($Config['APIv2ExcludeColumns']);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = Array(SPrintF('`UserID` = %u',$GLOBALS['__USER']['ID']),SPrintF('`OrderID` = %u',$OrderID));
#-------------------------------------------------------------------------------
$Columns = Array(
		'ID','OrderID','StatusID',
		'(SELECT `Name` FROM `DSSchemes` WHERE `DSSchemes`.`ID` = `DSOrdersOwners`.`SchemeID`) as `Scheme`',
		'(SELECT `DSuser` FROM `DSSchemes` WHERE `DSSchemes`.`ID` = `DSOrdersOwners`.`SchemeID`) as `DSuser`',
		'(SELECT `DSpass` FROM `DSSchemes` WHERE `DSSchemes`.`ID` = `DSOrdersOwners`.`SchemeID`) as `DSpass`',
		'(SELECT `ILOaddr` FROM `DSSchemes` WHERE `DSSchemes`.`ID` = `DSOrdersOwners`.`SchemeID`) as `ILOaddr`',
		'(SELECT `ILOuser` FROM `DSSchemes` WHERE `DSSchemes`.`ID` = `DSOrdersOwners`.`SchemeID`) as `ILOuser`',
		'(SELECT `ILOpass` FROM `DSSchemes` WHERE `DSSchemes`.`ID` = `DSOrdersOwners`.`SchemeID`) as `ILOpass`',
		);
#-------------------------------------------------------------------------------
$DSOrder = DB_Select('DSOrdersOwners',$Columns,Array('Where'=>$Where,'UNIQ'));
#-------------------------------------------------------------------------------
switch(ValueOf($DSOrder)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $Out;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$DSOrder['IPMI']	= Array();
$DSOrder['IPMI.Sensors']= Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// выпиливаем колонки
foreach(Array_Keys($DSOrder) as $Column)
	if(In_Array($Column,$Exclude))
		UnSet($DSOrder[$Column]);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(In_Array($DSOrder['StatusID'],Array('Active','Suspended'))){
	#-------------------------------------------------------------------------------
	// достаём IPMI информацию о сервере, если он оплачен и данные введены
	if(!$DSOrder['ILOaddr'] || !$DSOrder['ILOuser'] || !$DSOrder['ILOpass']){
		// нихрена
	}else{
		#-------------------------------------------------------------------------------
		// надо либо сенсоры либо IPMI
		if($IsSensors){
			#-------------------------------------------------------------------------------
			// сенсоры
			$Sensors = IPMI_SDR($DSOrder);
			#-------------------------------------------------------------------------------
			if(Is_Exception($Sensors) || Is_Error($Sensors)){
				// нихрена
			}else{
				#-------------------------------------------------------------------------------
				$DSOrder['IPMI.Sensors'] = $Sensors;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			// общая информация
			$IPMI = IPMI_StatusGet($DSOrder);
			#-------------------------------------------------------------------------------
			if(Is_Exception($IPMI) || Is_Error($IPMI)){
				// нихрена
			}else{
				#-------------------------------------------------------------------------------
				$DSOrder['IPMI'] = $IPMI;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// ещё выпливаем тоже колонки
$Deleted = Array('DSuser','DSpass','ILOaddr','ILOuser','ILOpass');
#-------------------------------------------------------------------------------
foreach(Array_Keys($DSOrder) as $Column)
	if(In_Array($Column,$Deleted))
		UnSet($DSOrder[$Column]);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $DSOrder;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

