<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$OrderID	= (integer) @$Args['OrderID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// список колонок которые юзеру не показываем
$Config = Config();
#-------------------------------------------------------------------------------
$Exclude = Array_Keys($Config['APIv2ExcludeColumns']);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out = Array();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Where = Array(SPrintF('`UserID` = %u',$GLOBALS['__USER']['ID']));
#-------------------------------------------------------------------------------
if($OrderID > 0)
	$Where[] = SPrintF('`OrderID` = %u',$OrderID);
#-------------------------------------------------------------------------------
$Columns = Array(	'*',
			'(SELECT `Customer` FROM `Contracts` WHERE `Contracts`.`ID` = `HostingOrdersOwners`.`ContractID`) AS `Customer`','(SELECT `ServerID` FROM `OrdersOwners` WHERE `OrdersOwners`.`ID` = `HostingOrdersOwners`.`OrderID`) AS `ServerID`',
			'(SELECT `IsPayed` FROM `OrdersOwners` WHERE `OrdersOwners`.`ID` = `HostingOrdersOwners`.`OrderID`) AS `IsPayed`',
			'(SELECT `Comment` FROM `HostingSchemes` WHERE `HostingSchemes`.`ID` = `HostingOrdersOwners`.`SchemeID`) AS `Message`',
			"(SELECT `Params` FROM `TmpData` WHERE `AppID` = 'Order.Statistics' AND `HostingOrdersOwners`.`OrderID` = `TmpData`.`Col1` LIMIT 1) AS `Params`",
			);
$HostingOrders = DB_Select('HostingOrdersOwners',$Columns,Array('Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($HostingOrders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return $Out;
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
$Servers = Array();
#-------------------------------------------------------------------------------
foreach($HostingOrders as $HostingOrder){
	#-------------------------------------------------------------------------------
	$ServerID = $HostingOrder['ServerID'];
	#-------------------------------------------------------------------------------
	// чтоб не делать запрросы на каждый тариф, храним сервера в массиве
	if(!IsSet($Servers[$ServerID])){
		#-------------------------------------------------------------------------------
		$Server = DB_Select('ServersOwners',Array('Address','Params'),Array('UNIQ','ID'=>$ServerID));
		#-------------------------------------------------------------------------------
		if(!Is_Array($Server))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Servers[$ServerID] = $Server;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// добавляем сервер
	$HostingOrder['Address'] = $Servers[$ServerID]['Address'];
	#-------------------------------------------------------------------------------
	// добавляем ДНС
	for($i = 1; $i <= 4; $i++){
		#-------------------------------------------------------------------------------
		$NsName = SPrintF('Ns%sName',$i);
		#-------------------------------------------------------------------------------
		$HostingOrder[$NsName] = $Servers[$ServerID]['Params'][$NsName];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// меняем формат графиков на выходе
	$Comp = Comp_Load('Formats/GraphOut',Array('Params'=>$HostingOrder['Params'],'StatusID'=>$HostingOrder['StatusID']));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$HostingOrder['Graphs'] = $Comp;
	#-------------------------------------------------------------------------------
	UnSet($HostingOrder['Params']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// выпиливаем колонки
	foreach(Array_Keys($HostingOrder) as $Column)
		if(In_Array($Column,$Exclude))
			UnSet($HostingOrder[$Column]);
	#-------------------------------------------------------------------------------
	$Out[$HostingOrder['ID']] = $HostingOrder;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return ($OrderID > 0)?Current($Out):$Out;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

