<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('modules/Authorisation.mod')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$ServersGroupID	= (integer) @$Args['ServersGroupID'];
$Name		=  (string) @$Args['Name'];
$ServiceID	= (integer) @$Args['ServiceID'];
$IsCheckUsers	= (boolean) @$Args['IsCheckUsers'];
$FunctionID	=  (string) @$Args['FunctionID'];
$Comment	=  (string) @$Args['Comment'];
$SortID		= (integer) @$Args['SortID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Count		= (integer) @$Args['Count'];
$OldCount	= (integer) @$Args['OldCount'];
#-------------------------------------------------------------------------------
$Params = Array('Count'=>$Count);
#-------------------------------------------------------------------------------
if($Count){
	#-------------------------------------------------------------------------------
	if($Count > 8)
		return new gException('COUNT_TOO_LARGE',SPrintF('Слишком большое автоматически заказываемых услуг (%u), ограничение: 8 шт.',$Count));
	#-------------------------------------------------------------------------------
	for($i = 1; $i <= $Count; $i++){
		#-------------------------------------------------------------------------------
		$Status				= SPrintF('Status%u',$i);
		$Scheme				= SPrintF('Scheme%u',$i);
		$Service			= SPrintF('Service%u',$i);
		$AdditionalParams		= SPrintF('AdditionalParams%u',$i);
		$IsZeroPriceOrder		= SPrintF('IsZeroPriceOrder%u',$i);
		$IsZeroPricePay			= SPrintF('IsZeroPricePay%u',$i);
		$IsNoDuplicate			= SPrintF('IsNoDuplicate%u',$i);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Params[$Status]		= (@$Args[$Status])?((string)@$Args[$Status]):'OnCreate';
		#-------------------------------------------------------------------------------
		$Params[$Service]		= (integer) @$Args[$Service];
		#-------------------------------------------------------------------------------
		$Params[$Scheme]		= (integer) @$Args[$Scheme];
		#-------------------------------------------------------------------------------
		$Params[$AdditionalParams]	=  (string) @$Args[$AdditionalParams];
		#-------------------------------------------------------------------------------
		$Params[$IsZeroPriceOrder]	= (boolean) @$Args[$IsZeroPriceOrder];
		#-------------------------------------------------------------------------------
		$Params[$IsZeroPricePay]	= (boolean) @$Args[$IsZeroPricePay];
		#-------------------------------------------------------------------------------
		$Params[$IsNoDuplicate]		= (boolean) @$Args[$IsNoDuplicate];
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		# проверяем что не всунули любой сервис или любой тариф
		if(!$Params[$Service] || !$Params[$Scheme])
			if($OldCount >= $Count)
				return new gException('NOT_SELECTED_SERVICE_OR_SCHEME',SPrintF('Нельзя заказать любую услугу или любой тариф - необходимо конкретное указание заказываемого',$Count));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$Name)
	return new gException('NAME_IS_EMPTY','Не указано название группы');
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Functions = $Config['Servers']['Balancing']['Functions'];
#-------------------------------------------------------------------------------
if(!IsSet($Functions[$FunctionID]))
	return new gException('WRONG_FUNCTION_ID','Неверная функция балансировки');
#-------------------------------------------------------------------------------
if(!$Comment)
	return new gException('COMMENT_IS_EMPTY','Не указан комментарий');
#-------------------------------------------------------------------------------
$Answer = Array('Status'=>'Ok');
#-------------------------------------------------------------------------------
$IServersGroup = Array(
			'Name'		=> $Name,
			'ServiceID'	=> ($ServiceID)?$ServiceID:NULL,
			'FunctionID'	=> $FunctionID,
			'IsCheckUsers'	=> $IsCheckUsers,
			'Params'	=> $Params,
			'Comment'	=> $Comment,
			'SortID'	=> $SortID
			);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($ServersGroupID){
	#-------------------------------------------------------------------------------
	$IsUpdate = DB_Update('ServersGroups',$IServersGroup,Array('ID'=>$ServersGroupID));
	if(Is_Error($IsUpdate))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$ServersGroupID = DB_Insert('ServersGroups',$IServersGroup);
	if(Is_Error($ServersGroupID))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Answer['ServersGroupID'] = $ServersGroupID;
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return $Answer;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
