<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$CollationID	= (integer) @$Args['CollationID'];
$Window		=  (string) @$Args['Window'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php','libs/Tree.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($CollationID){
	#-------------------------------------------------------------------------------
	$Collation = DB_Select('PaymentSystemsCollation',Array('*'),Array('UNIQ','ID'=>$CollationID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Collation)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Collation = Array(
			'IsActive'		=> TRUE,
			'SortID'		=> 99999,
			'Source'		=> 'PayMaster',
			'Destination'		=> 'EuroSet',
			'Image'			=> 'EuroSet.png',
			'Description'		=> 'ЕвроСеть',
			'Prompt'		=> "Оплата через салуны евросеть.\nВарианты оплаты - все возможные, в этих самых салунах.",
			'AdminNotice'		=> 'Просто заметка для себя... Зачем этот вариант оплаты добавлен, например...'
			);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'PaymentSystemsCollationEditForm','onsubmit'=>'return false;'));
#-------------------------------------------------------------------------------
if($Window){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('name'=>'Window','type'=>'hidden','value'=>$Window));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddText('Title',SPrintF('%s сопоставления платёжной системы',($CollationID)?'Редактирование':'Добавление'));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table = Array();
#-------------------------------------------------------------------------------
$Table[] = 'Общие параметры';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$PaymentSystems = $Config['Invoices']['PaymentSystems'];
#-------------------------------------------------------------------------------
$Options = Array();
#-------------------------------------------------------------------------------
foreach(Array_Keys($PaymentSystems) as $PaymentSystemID){
	#-------------------------------------------------------------------------------
	$PaymentSystem = $PaymentSystems[$PaymentSystemID];
	#-------------------------------------------------------------------------------
	#if(!$PaymentSystem['IsActive'])
	#	continue;
	#-------------------------------------------------------------------------------
	$Options[$PaymentSystemID] = SPrintF('%s / %s',$PaymentSystemID,$PaymentSystem['Name']);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
if(!Count($Options))
	return new gException('PAYMENT_SYSTEMS_NOT_DEFINED','Платежные системы не определены');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Select',Array('name'=>'Source','style'=>'width: 100%;','prompt'=>'Платёжная система на которую ссылаемся. Через неё будет производится фактическая оплата.'),$Options,$Collation['Source']);
#-------------------------------------------------------------------------------
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Исходная платежная система',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',	Array('type'=>'text','name'=>'Destination','style'=>'width: 100%;','value'=>$Collation['Destination'],'prompt'=>'Поле сделано с заделом на будущее, с расчётом передавать это параметр при оплате.... Пока не используется.'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Итоговая платёжная система',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',	Array('type'=>'text','name'=>'Image','style'=>'width: 100%;','value'=>$Collation['Image'],'prompt'=>SPrintF("Имя файла с логотипом платёжной системы. (135x70, прозрачный фон)\nВсе имеющиеся изображения можно посмотреть по пути: %s/styles/billing/Images/PaymentSystems/\nсвои собственные изображеня следует выкладывать по пути: %s/styles/%s/Images/PaymentSystems/",SYSTEM_PATH,SYSTEM_PATH,HOST_ID)));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Логотип',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',	Array('type'=>'text','name'=>'Description','style'=>'width: 100%;','value'=>$Collation['Description'],'prompt'=>'Строка текста, под логотипом платёжной системы'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Название способа оплаты',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/TextArea',Array('rows'=>4,'name'=>'Prompt','style'=>'width: 100%;','prompt'=>'Описание способа оплаты. Выводится при наведении курсора на логотип'),$Collation['Prompt']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Описание',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'IsActive','id'=>'IsActive','type'=>'checkbox','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($Collation['IsActive'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsActive'),'Активен'),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'SortID','style'=>'width: 100%;','value'=>$Collation['SortID'],'prompt'=>'В каком порядке сортировать группы, при отображении'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Порядок сортировки',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Заметка';
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/TextArea',Array('name'=>'AdminNotice','style'=>'width:100%;','rows'=>5,'prompt'=>'Информация о сервере, "чисто для себя"'),$Collation['AdminNotice']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'    => 'button',
			'onclick' => SPrintF("FormEdit('/Administrator/API/PaymentSystemsCollationEdit','PaymentSystemsCollationEditForm','%s');",($CollationID?'Сохранение настроек':'Добавление сопоставления')),
			'value'   => ($CollationID?'Сохранить':'Добавить сопоставление')
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table,Array('style'=>'width:500px;'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($CollationID){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('name'=>'CollationID','type'=>'hidden','value'=>$Collation['ID'],'style'=>'width: 100%;',));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
