<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Null($Args))
	if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
		return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$ServerID = (integer) @$Args['ServerID'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
$Settings = $Config['Interface']['Administrator']['Servers'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Server = DB_Select('Servers',Array('*','(SELECT `Name` FROM `Services` WHERE `Services`.`ID` = (SELECT `ServiceID` FROM `ServersGroups` WHERE `ServersGroups`.`ID` = `Servers`.`ServersGroupID`)) AS `ServiceName`','(SELECT `Name` FROM `ServersGroups` WHERE `ServersGroups`.`ID` = `Servers`.`ServersGroupID`) AS `GroupName`'),Array('UNIQ','ID'=>$ServerID));
#-------------------------------------------------------------------------------
switch(ValueOf($Server)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
$IsPermission = Permission_Check('ServerRead',(integer)$__USER['ID'],100);
#-------------------------------------------------------------------------------
switch(ValueOf($IsPermission)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'false':
	return ERROR | @Trigger_Error(700);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
#-------------------------------------------------------------------------------
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddText('Title',SPrintF('Сервер %s',$Server['Address']));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table = Array('Общие параметры');
#-------------------------------------------------------------------------------
$Table[] = Array('Сервис',Is_Null($Server['ServiceName'])?'-':$Server['ServiceName']);
#-------------------------------------------------------------------------------
$Table[] = Array('Группа серверов',Is_Null($Server['GroupName'])?'-':$Server['GroupName']);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Formats/Logic',$Server['IsActive']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Активен',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Formats/Logic',$Server['IsDefault']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Основной в группе',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = Array('Порядок сортировки',$Server['SortID']);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Параметры соединения';
#-------------------------------------------------------------------------------
$Table[] = Array('Протокол',$Server['Protocol']);
#-------------------------------------------------------------------------------
$Table[] = Array('Адрес сервера',$Server['Address']);
#-------------------------------------------------------------------------------
$Table[] = Array('Порт',$Server['Port']);
#-------------------------------------------------------------------------------
$Table[] = Array('Логин',$Server['Login']);
#-------------------------------------------------------------------------------
# TODO проверять опцию конфига - показывать или нет
#$Table[] = Array('Пароль',$Server['Password']);
$Table[] = Array('Пароль',($Settings['PasswordShow'])?$Server['Password']:'************');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Template = System_XML(SPrintF('servers/%s.xml',$Server['TemplateID']));
if(Is_Error($Template))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(IsSet($Template['Attribs'])){
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Template['Attribs']) as $AttribID){
		#-------------------------------------------------------------------------------
		$Attrib = $Template['Attribs'][$AttribID];
		#-------------------------------------------------------------------------------
		switch($Template['Attribs'][$AttribID]['Type']){
		case 'Input':
			# No more...
		case 'Hidden':
			# No more...
		case 'TextArea':
			#-------------------------------------------------------------------------------
			$Value = $Server['Params'][$AttribID];
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'Select':
			#-------------------------------------------------------------------------------
			$Value = $Template['Attribs'][$AttribID]['Options'][$Server['Params'][$AttribID]];
			#-------------------------------------------------------------------------------
			break;
				#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(SPrintF('[ServerInfo]: тип атрибута не определён: %s',$Template['Attribs'][$AttribID]['Type']));
		}
		#-------------------------------------------------------------------------------
		if(IsSet($Template['Attribs'][$AttribID]['Attribs']['type']) && $Template['Attribs'][$AttribID]['Attribs']['type'] == 'checkbox'){
			#-------------------------------------------------------------------------------
			$Value = Comp_Load('Formats/Logic',$Value);
			if(Is_Error($Value))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		if(IsSet($Template['Attribs'][$AttribID]['Title']))
			$Table[] = $Template['Attribs'][$AttribID]['Title'];
		#-------------------------------------------------------------------------------
		$Comment = Comp_Load('Formats/String',IsSet($Template['Attribs'][$AttribID]['Comment'])?$Template['Attribs'][$AttribID]['Comment']:'-',30);
		if(Is_Error($Comment))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = Array(
					'Comment'	=> $Comment,
					'Value'		=> new Tag('PRE',Array('class'=>'Standard','style'=>'width:260px; overflow:hidden;'),($Value)?$Value:'-')
				);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = 'Служба мониторинга';
#-------------------------------------------------------------------------------
$Table[] = Array('Сервисы',new Tag('PRE',Array('class'=>'Standard','style'=>'width:260px; overflow:hidden;'),$Server['Monitoring']));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($Server['AdminNotice'] && $GLOBALS['__USER']['IsAdmin']){
	#-------------------------------------------------------------------------------
	$Table[] = 'Примечания к заказу';
	#-------------------------------------------------------------------------------
	if($Server['AdminNotice'] && $GLOBALS['__USER']['IsAdmin'])
		$Table[] = Array('Примечание администратора',new Tag('PRE',Array('class'=>'Standard','style'=>'width:260px; overflow:hidden;'),$Server['AdminNotice']));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>SPrintF("ShowWindow('/Administrator/ServerEdit',{ServerID:'%u'});",$Server['ID']),'value'=>'Редактировать'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Div = new Tag('DIV',Array('align'=>'right'),$Comp);
#-------------------------------------------------------------------------------
$Table[] = $Div;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
