<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php','classes/VPSServer.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Args = Args();
#-------------------------------------------------------------------------------
$VPSSchemeID	= (integer) @$Args['VPSSchemeID'];
$ServersGroupID = (integer) @$Args['ServersGroupID'];
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($VPSSchemeID){
	#-------------------------------------------------------------------------------
	// достаём данныне тарифа
	$VPSScheme = DB_Select('VPSSchemes','*',Array('UNIQ','ID'=>$VPSSchemeID));
	#-------------------------------------------------------------------------------
	switch(ValueOf($VPSScheme)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return ERROR | @Trigger_Error(400);
	case 'array':
		# No more...
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	if(!$ServersGroupID){
		#-------------------------------------------------------------------------------
		$Title = 'Группа серверов нового тарифа';
		#-------------------------------------------------------------------------------
		$DOM->AddText('Title',$Title);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$ServersGroups = DB_Select('ServersGroups','*',Array('Where'=>'`ServiceID` = 30000'));
		#-------------------------------------------------------------------------------
		switch(ValueOf($ServersGroups)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			return new gException('SERVERS_GROUPS_NOT_FOUND','Группы серверов не найдены. Необходимо добавить группу серверов для сервиса "VPS", в разделе "Дополнения -> Мастера настройки -> Сервера"');
			#-------------------------------------------------------------------------------
		case 'array':
			# No more...
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		$Options = Array();
		#-------------------------------------------------------------------------------
		foreach($ServersGroups as $ServersGroup)
			$Options[$ServersGroup['ID']] = $ServersGroup['Name'];
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Form/Select',Array('name'=>'ServersGroupID','style'=>'width: 240px',),$Options);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table = Array('Группа серверов',$Comp);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Div = new Tag('DIV',Array('align'=>'right'));
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>"ShowWindow('/Administrator/VPSSchemeEdit',FormGet(form));",'value'=>'Продолжить'));
//		$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick' => SPrintF("FormEdit('/Administrator/VPSSchemeEdit','VPSSchemeEditForm','%s');",$Title),'value'=>'Продолжить'));
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Div->AddChild($Comp);
		#-------------------------------------------------------------------------------
		$Table[] = $Div;
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Tables/Standard',$Table);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Form = new Tag('FORM',Array('name'=>'VPSSchemeEditForm','onsubmit'=>'return false;'),$Comp);
		#-------------------------------------------------------------------------------
		$DOM->AddChild('Into',$Form);
		#-------------------------------------------------------------------------------
		if(Is_Error($DOM->Build(FALSE)))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return Array('Status'=>'Ok','DOM'=>$DOM->Object);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$VPSScheme = Array(
				'GroupID'		=> 1,
				'UserID'		=> 1,
				'Name'			=> 'default1',
				'PackageID'		=> 'MB500',
				'CostDay'		=> 40,
				'CostMonth'		=> 1200,
				'CostInstall'		=> 100,
				'Discount'		=> -1,
				'ServersGroupID'	=> $ServersGroupID,
				'Node'			=> '',
				'Comment'		=> 'Идеальный тариф для ...',
				'IsActive'		=> TRUE,
				'IsProlong'		=> TRUE,
				'IsSchemeChangeable'	=> TRUE,
				'IsSchemeChange'	=> TRUE,
				'MinDaysPay'		=> 31,
				'MinDaysProlong'	=> 14,
				'MaxDaysPay'		=> 1460,
				'MaxOrders'		=> 0,
				'MinOrdersPeriod'	=> 0,
				'SortID'		=> 10,
				'SchemeParams'		=> Array()
			);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Messages = Messages();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Title = ($VPSSchemeID?SPrintF('Редактирование тарифа VPS: %s',$VPSScheme['Name']):'Добавление нового тарифа виртуального сервера');
#-------------------------------------------------------------------------------
$DOM->AddText('Title',$Title);
#-------------------------------------------------------------------------------
$Table = Array('Общая информация');
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Owner','Владелец тарифа',$VPSScheme['GroupID'],$VPSScheme['UserID']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input', Array('type'=>'text','name'=>'Name','value'=>$VPSScheme['Name']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Название тарифного плана',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'PackageID','value'=>$VPSScheme['PackageID']),'Точное имя пакета в панели управления');
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Идентификатор пакета в панели',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Summ',Array('name'=>'CostDay','value'=>SPrintF('%01.2f',$VPSScheme['CostDay'])));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('NOBODY',new Tag('SPAN','Стоимость дня'),new Tag('BR'),new Tag('SPAN',Array('class'=>'Comment'),'Используется в расчетах стоимости')),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Summ',Array('name'=>'CostMonth','value'=>SPrintF('%01.2f',$VPSScheme['CostMonth'])));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('NOBODY',new Tag('SPAN','Стоимость месяца'),new Tag('BR'),new Tag('SPAN',Array('class'=>'Comment'),'Используется для отображения')),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Summ',Array('name'=>'CostInstall','value'=>SPrintF('%01.2f',$VPSScheme['CostInstall'])));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
$Table[] = Array(new Tag('NOBODY',new Tag('SPAN','Стоимость подключения'),new Tag('BR'),new Tag('SPAN',Array('class'=>'Comment'),'Цена за инсталляцию')),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'  => 'text',
			'name'  => 'Discount',
			'value' => SPrintF('%01.0f',$VPSScheme['Discount']),
			'prompt'=> 'Если указано число от нуля до 100, то при оплате используется именно указанная скидка, все глобальные скидки и бонусы игнорируются. При указании отрицательного числа - используются глобальные скидки и бонусы',
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('NOBODY',new Tag('SPAN','Скидка'),new Tag('BR'),new Tag('SPAN',Array('class'=>'Comment'),'Скидка на этот тариф')),$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsActive','id'=>'IsActive','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($VPSScheme['IsActive'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsActive'),'Тариф активен'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsProlong','id'=>'IsProlong','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($VPSScheme['IsProlong'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsProlong'),'Возможность продления'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsSchemeChangeable','id'=>'IsSchemeChangeable','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($VPSScheme['IsSchemeChangeable'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsSchemeChangeable'),'Возможность перехода на тариф'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','name'=>'IsSchemeChange','id'=>'IsSchemeChange','value'=>'yes'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if($VPSScheme['IsSchemeChange'])
	$Comp->AddAttribs(Array('checked'=>'yes'));
#-------------------------------------------------------------------------------
$Table[] = Array(new Tag('LABEL',Array('for'=>'IsSchemeChange'),'Возможность перехода с тарифа'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'MinDaysPay','value'=>$VPSScheme['MinDaysPay'],'style'=>'width: 100%;'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Минимальное кол-во дней оплаты',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'MinDaysProlong','value'=>$VPSScheme['MinDaysProlong'],'prompt'=>'Минимальное число дней, на которое можно продлевать заказ','style'=>'width: 100%;'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Минимальное кол-во дней продления',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'MaxDaysPay','value'=>$VPSScheme['MaxDaysPay'],'style'=>'width: 100%;'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Максимальное кол-во дней оплаты',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'MaxOrders','value'=>$VPSScheme['MaxOrders'],'prompt'=>$Messages['Prompts']['MaxOrders'],'style'=>'width: 100%;'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Максимальное кол-во заказов',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'MinOrdersPeriod','value'=>$VPSScheme['MinOrdersPeriod'],'prompt'=>$Messages['Prompts']['MinOrdersPeriod'],'style'=>'width: 100%;'));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Минимальный период между заказами',$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'text','name'=>'SortID','value'=>$VPSScheme['SortID'],'style'=>'width: 100%;'));
if(Is_Error($Comp))
  return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = Array('Порядок сортировки',$Comp);
#-------------------------------------------------------------------------------
$Table[] = 'Ноды';
#-------------------------------------------------------------------------------
// выбор ноды кластера
$Servers = DB_Select('Servers',Array('ID','Address','Params'),Array('Where'=>Array(SPrintF('`ServersGroupID` = %u',$VPSScheme['ServersGroupID']),'(SELECT `ServiceID` FROM `ServersGroups` WHERE `ServersGroups`.`ID` = `Servers`.`ServersGroupID`) = 30000'),'SortOn'=>'Address'));
#-------------------------------------------------------------------------------
//Debug(print_r($Servers,true));
switch(ValueOf($Servers)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	$Options = Array(''=>'Автоматический выбор');
	#-------------------------------------------------------------------------------
	// перебираем сервера, перебираем ноды у серверов
	foreach($Servers as $Server){
		#-------------------------------------------------------------------------------
		if($Server['Params']['NodeList']){
			#-------------------------------------------------------------------------------
			foreach(Explode("\n",$Server['Params']['NodeList']) as $Node)
				$Options[$Node] = $Node;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$SystemID = $Server['Params']['SystemID'];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// серверов более одного (параметр автовыбор + 2 ноды)
	if(SizeOf($Options) > 2){
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Form/Select',Array('name'=>'Node[]','multiple'=>'','size'=>SizeOf($Options),'style'=>'width: 240px','prompt'=>'На каких нодах кластера должен находится этот тариф. Если нода не совпадает - будет выполнена автоматическая миграция. Если стоит автовыбор - миграция происходит только в том случае, если на ноде запрещено создание новых виртуальных машин - тогда происходит миграция туда где можно. Подробности и примеры использования - смотрите в документации'),$Options,Explode(',',$VPSScheme['Node']));
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = Array('Нода кластера',$Comp);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
        break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = SPrintF('Ограничения тарифа / %s',$SystemID);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// загружаем XML
$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$SystemID));
if(Is_Error($Fields))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/www/Administrator/VPSSchemeEdit]: %s',print_r($VPSScheme['SchemeParams'],true)));
foreach(Array_Keys($Fields) as $Key){
	#-------------------------------------------------------------------------------
	$Field = $Fields[$Key];
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/Administrator/VPSSchemeEdit]: Key = %s; Field = %s',$Key,print_r($Field,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(IsSet($Field['Type'])){
		#-------------------------------------------------------------------------------
		$Type = $Field['Type'];
		#-------------------------------------------------------------------------------
		$Text = new Tag('LABEL',Array('for'=>$Key),$Field['Name']);
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$Type = 'Input';
		#-------------------------------------------------------------------------------
		$Text = IsSet($Field['Unit'])?SPrintF('%s, %s',$Field['Name'],$Field['Unit']):$Field['Name'];
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	// если параметр задан - используем его, иначе - дефолт
	$Value = IsSet($VPSScheme['SchemeParams'][$Key])?$VPSScheme['SchemeParams'][$Key]:$Field['Value'];
	#-------------------------------------------------------------------------------
	// лимиты в подсказку
	$Description = (IsSet($Field['Min']))?SPrintF('%s Лимит: %s<%s',$Field['Description'],$Field['Min'],$Field['Max']):$Field['Description'];
	#-------------------------------------------------------------------------------
	switch($Type){
	case 'Input':
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load(
				'Form/Input',
				Array(
					'type'  => $Type,
					'name'  => $Key,
					'id'	=> $Key,
					'value' => $Value,
					'prompt'=> $Description,
					'style' => 'width: 100%;',
					)
				);
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'CheckBox':
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load(
				'Form/Input',
				Array(
					'type'  => $Type,
					'name'  => $Key,
					'id'	=> $Key,
					'value' => 'yes',
					'prompt'=> $Description,
					)
				);
		#-------------------------------------------------------------------------------
		# для чекбоксов - у них дополнительный параметр "checked", если задано значение
		if($Value)
			$Comp->AddAttribs(Array('checked'=>'yes'));
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'Select':
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load(
				'Form/Select',
				Array(
					'type'  => $Type,
					'name'  => $Key,
					'id'	=> $Key,
					'value' => $Value,
					'prompt'=> $Description,
					'style' => 'width: 100%;',
					),
					$Field['Options'],
					$Value
				);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(101);
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Table[] = Array($Text,$Comp);
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/TextArea',Array('name'=>'Comment','style'=>'width:100%;','rows'=>3),$VPSScheme['Comment']);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Table[] = 'Описание тарифа';
#-------------------------------------------------------------------------------
$Table[] = $Comp;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Div = new Tag('DIV',Array('align'=>'right'));
#-------------------------------------------------------------------------------
if($VPSSchemeID){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('type'=>'checkbox','onclick'=>'form.VPSSchemeID.value = (checked?0:value);','value'=>$VPSSchemeID,'id'=>'IsCreateNewScheme'));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Div->AddChild($Comp);
	#-------------------------------------------------------------------------------
	$Div->AddChild(new Tag('LABEL',Array('class'=>'Comment','for'=>'IsCreateNewScheme'),'создать новый тариф'));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('type'=>'button','onclick'=>SPrintF("FormEdit('/Administrator/API/VPSSchemeEdit','VPSSchemeEditForm','%s');",$Title),'value'=>($VPSSchemeID?'Сохранить':'Добавить')));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Div->AddChild($Comp);
#-------------------------------------------------------------------------------
$Table[] = $Div;
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'VPSSchemeEditForm','onsubmit'=>'return false;'),$Comp);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'VPSSchemeID','type'=>'hidden','value'=>$VPSSchemeID));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'SystemID','type'=>'hidden','value'=>$SystemID));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Form/Input',Array('name'=>'ServersGroupID','type'=>'hidden','value'=>$VPSScheme['ServersGroupID']));
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
