<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
$DSOrderID	= (integer) @$Args['DSOrderID'];
$OrderID	= (integer) @$Args['OrderID'];
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php','libs/IPMI.SuperMicro.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// возможно задан номер заказа
$Where = ($OrderID)?SPrintF('`OrderID` = %u',$OrderID):SPrintF('`ID` = %u',$DSOrderID);
#-------------------------------------------------------------------------------
$DSOrder = DB_Select('DSOrdersOwners',Array('ID','UserID','StatusID','SchemeID'),Array('UNIQ','Where'=>$Where));
#-------------------------------------------------------------------------------
switch(ValueOf($DSOrder)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
        break;
default:
        return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if($DSOrder['StatusID'] != 'Active' && !$__USER['IsAdmin'])
	return new gException('DS_ORDER_NOT_ACTIVE','Заказ выделенного сервера не активен');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DSScheme = DB_Select('DSSchemes','*',Array('UNIQ','ID'=>$DSOrder['SchemeID']));
#-------------------------------------------------------------------------------
switch(ValueOf($DSScheme)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'array':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$IsPermission = Permission_Check('DSManage',(integer)$__USER['ID'],(integer)$DSOrder['UserID']);
#-------------------------------------------------------------------------------
switch(ValueOf($IsPermission)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	return ERROR | @Trigger_Error(400);
case 'false':
	return ERROR | @Trigger_Error(700);
case 'true':
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$DSScheme['ILOaddr'] || !$DSScheme['ILOuser'] || !$DSScheme['ILOpass'])
	return new gException('NO_IPMI_USER_PASS','Для этого сервера не указаны данные для подключения к IPMI, управление невозможно');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// надо достать реальный статус сервера и по нему менять надписи и их цвет
$Status = IPMI_PowerGet($DSScheme);
if(Is_Exception($Status))
	return new gException('IPMI_PowerGet',$Status->String);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Window')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Title = SPrintF('Питание сервера %s',$DSScheme['Name']);
#-------------------------------------------------------------------------------
$DOM->AddText('Title',$Title);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'  => 'hidden',
			'name'  => 'DSOrderID',
			'value' => $DSOrder['ID']
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'DSRebootForm','onsubmit'=>'return false;'),/*new Tag('BR'),new Tag('BR'),*/$Comp);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table = Array();
#-------------------------------------------------------------------------------
$Table[] = new Tag('TR',new Tag('TD','Текущий статус'),new Tag('TD',Array('class'=>'Head','style'=>SPrintF('background:%s;',($Status == 'on')?'lightgreen':'orange'),'align'=>'center'),new Tag('B',($Status == 'on')?'Включён':'Выключен')));
#-------------------------------------------------------------------------------
$Table[] = 'Выбор команды';
#-------------------------------------------------------------------------------
$Commands = Array(
		'on'	=> Array('Включить','Включить сервер'),
		'off'	=> Array('Выключить','Жёстко выключить сервер (нажать и держать кнопку питания пока не выключится)'),
		'soft'	=> Array('Корректно выключить','Корректное выключение - эмуляция кратковременного нажатия кнопки питания. Большинство операционных систем корректно завершают работу и выключают сервер. В некоторых случаях, возможны проблемы - операционная система гасит и сетевой интерфейс, как итог - невозможность включить сервер удалённо, только физически - кнопкой на нём самом.'),
		'cycle'	=> Array('Выключить/включить','Выключить, затем включить сервер по питанию'),
		'reset'	=> Array('RESET','Нажать кнопку RESET на сервере'),
		'mc'	=> Array('Перезагрузить IPMI','Перезагрузить контроллер удалённого управления сервером. Необходимо если сервер перестал реагировать на попытки включения/выключения'),
		);
#-------------------------------------------------------------------------------
foreach(Array_Keys($Commands) as $Key){
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Input',Array('name'=>'Command','type'=>'radio','value'=>$Key,'id'=>$Key,'prompt'=>$Commands[$Key][1]));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	if(In_Array($Key,Array('off','soft','reset','cycle')) && $Status == 'off')
		$Comp->AddAttribs(Array('disabled'=>'true'));
	#-------------------------------------------------------------------------------
	if(In_Array($Key,Array('on')) && $Status == 'on')
		$Comp->AddAttribs(Array('disabled'=>'true'));
	#-------------------------------------------------------------------------------
	$Table[] = new Tag('TR',new Tag('TD',new Tag('LABEL',Array('for'=>$Key,'title'=>$Commands[$Key][1]),$Commands[$Key][0])),new Tag('TD',$Comp));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Text = new Tag('SPAN',SPrintF('Вы действительно хотите перезагрузить виртуальный сервер %s?',$DSScheme['Name']));
#-------------------------------------------------------------------------------
$Comp = Comp_Load(
		'Form/Input',
		Array(
			'type'		=> 'button',
			'onclick'	=> SPrintF("FormEdit('/API/DSReboot','DSRebootForm','%s');;setTimeout(function(){location.href = '/DSOrders';},6000);",$Title),
			'value'		=> 'Выполнить'
			)
		);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Table[] = new Tag('TD',new Tag('TD',Array('colspan'=>2,'align'=>'right'),$Comp));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Tables/Standard',$Table);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------	
#-------------------------------------------------------------------------------
$Form->AddChild($Comp);
#-------------------------------------------------------------------------------
$DOM->AddChild('Into',$Form);
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Build(FALSE)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
