<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = Args();
#-------------------------------------------------------------------------------
$ContractID	=  (string) @$Args['ContractID'];
$ISPswSchemeID	= (integer) @$Args['ISPswSchemeID'];
$StepID		= (integer) @$Args['StepID'];
$DependOrderID	= (integer) @$Args['DependOrderID'];	# номер заказа к которому цепляем лицензию
$IP		=  (string) @$Args['IP'];		# IP адрес на который заказывается внешняя лицензия
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('modules/Authorisation.mod','classes/DOM.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$__USER = $GLOBALS['__USER'];
#-------------------------------------------------------------------------------
$UniqID = UniqID('ISPswSchemes');
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# узнаём, есть ли возможность заказа внешних лицензий
$UniqID2 = SPrintF('%s_2',$UniqID);
#-------------------------------------------------------------------------------
$Comp = Comp_Load('Services/Schemes','ISPswSchemes',$__USER['ID'],Array('Name'),$UniqID2);
if(Is_Error($Comp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------
$Columns = Array('ID','Name','Comment','CostMonth');
#-------------------------------------------------------------------------
$ISPswSchemes = DB_Select($UniqID2,$Columns,Array('SortOn'=>Array('SortID'),'Where'=>"`IsActive` = 'yes' AND `IsInternal` = 'no'"));
#-------------------------------------------------------------------------
switch(ValueOf($ISPswSchemes)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	$AllowExternalOrder = 1;
	break;
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$DOM = new DOM();
#-------------------------------------------------------------------------------
$Links = &Links();
# Коллекция ссылок
$Links['DOM'] = &$DOM;
#-------------------------------------------------------------------------------
if(Is_Error($DOM->Load('Base')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$DOM->AddAttribs('MenuLeft',Array('args'=>'User/Services'));
#-------------------------------------------------------------------------------
$DOM->AddText('Title','Заказ лицензии ISPsystem');
#-------------------------------------------------------------------------------
$Script = new Tag('SCRIPT',Array('type'=>'text/javascript','src'=>'SRC:{Js/Pages/Order.js}'));
#-------------------------------------------------------------------------------
$DOM->AddChild('Head',$Script);
#-------------------------------------------------------------------------------
$Form = new Tag('FORM',Array('name'=>'ISPswOrderForm','onsubmit'=>'return false;'));
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!$StepID){
	#-------------------------------------------------------------------------------
	// выбираем все активные заказы на лицензии - будем их использовать для определения,
	// к каким заказам виртуальных/выделенных серверов не надо лицензию
	// TODO посомтреть вариант убрать юезра из условия - может быть у друого юзера лицензия на этот IP
	$Orders = Array();
	#-------------------------------------------------------------------------------
	$ISPswOrders = DB_Select('ISPswOrdersOwners',Array('ID','IP','StatusID'),Array('Where'=>Array(SPrintF('`UserID` = %u',$__USER['ID']),'`StatusID` = "Active"')));
	#-------------------------------------------------------------------------------
	switch(ValueOf($ISPswOrders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		foreach($ISPswOrders as $ISPswOrder)
			$Orders[] = $ISPswOrder['IP'];
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Contracts = DB_Select('Contracts',Array('ID','Customer'),Array('Where'=>SPrintF("`UserID` = %u AND `TypeID` != 'NaturalPartner' AND `IsHidden` = 'no'",$__USER['ID'])));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Contracts)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return new gException('CONTRACTS_NOT_FOUND','Система не обнаружила у Вас ни одного активного договора. Пожалуйста, перейдите в раздел [Мой офис - Договоры] и сформируйте/активируйте хотя бы один договор.');
	case 'array':
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Options = Array();
	#-------------------------------------------------------------------------------
	foreach($Contracts as $Contract){
		#-------------------------------------------------------------------------------
		$Customer = $Contract['Customer'];
		#-------------------------------------------------------------------------------
		$Number = Comp_Load('Formats/Contract/Number',$Contract['ID']);
		if(Is_Error($Number))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		if(Mb_StrLen($Customer) > 20)
			$Customer = SPrintF('%s...',Mb_SubStr($Customer,0,20));
		#-------------------------------------------------------------------------------
		$Options[$Contract['ID']] = SPrintF('#%s / %s',$Number,$Customer);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Select',Array('name'=>'ContractID'),$Options,$ContractID);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$NoBody = new Tag('NOBODY',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Window = JSON_Encode(Array('Url'=>'/ISPswOrder','Args'=>Array()));
	#-------------------------------------------------------------------------------
	$A = new Tag('A',Array('href'=>SPrintF("javascript:ShowWindow('/ContractMake',{Window:'%s'});",Base64_Encode($Window))),'[новый]');
	#-------------------------------------------------------------------------------
	$NoBody->AddChild($A);
	#-------------------------------------------------------------------------------
	$Table = Array(Array('Базовый договор',$NoBody));
	#-------------------------------------------------------------------------------
	$Table[] = new Tag('TD',Array('colspan'=>2,'width'=>300,'class'=>'Standard','style'=>'background-color:#FDF6D3;'),'Необходимо выбрать заказ VPS или выделенного сервера, к которому будет прикреплена заказанная лицензия');
	#-------------------------------------------------------------------------------
	$OrderCount = 0;
	#-------------------------------------------------------------------------------
	$Options = Array('Не использовать');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# create select, using UserID for VPSOrders
	$Columns = Array('ID','Login','IP','OrderID','(SELECT `Address` FROM `Servers` WHERE `Servers`.`ID` = (SELECT `ServerID` FROM `OrdersOwners` WHERE `OrdersOwners`.`ID` = `VPSOrdersOwners`.`OrderID`)) AS `Address`');
	#-------------------------------------------------------------------------------
	$VPSOrders = DB_Select('VPSOrdersOwners',$Columns,Array('Where'=>SPrintF('`UserID` = %u AND `StatusID` = "Active"',$__USER['ID'])));
	#-------------------------------------------------------------------------------
	switch(ValueOf($VPSOrders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		foreach($VPSOrders as $VPSOrder){
			#-------------------------------------------------------------------------------
			if(In_Array($VPSOrder['IP'],$Orders))
				continue;
			#-------------------------------------------------------------------------------
			$DependOrderID		= $VPSOrder['OrderID'];
			$Options[$DependOrderID]= SPrintF('VPS: %s / %s',$VPSOrder['IP'],$VPSOrder['Login']);
			#-------------------------------------------------------------------------------
			$OrderCount++;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# create select, using UserID for DSOrders
	$Columns = Array('ID','IP','OrderID','(SELECT `Name` FROM `DSSchemes` WHERE `DSSchemes`.`ID` = `SchemeID`) as `Name`');
	#-------------------------------------------------------------------------------
	$DSOrders = DB_Select('DSOrdersOwners',$Columns,Array('Where'=>SPrintF('`UserID` = %u AND `StatusID` = "Active"',$__USER['ID'])));
	#-------------------------------------------------------------------------------
	switch(ValueOf($DSOrders)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		foreach($DSOrders as $DSOrder){
			#-------------------------------------------------------------------------------
			if(In_Array($DSOrder['IP'],$Orders))
				continue;
			#-------------------------------------------------------------------------------
			$DependOrderID		= $DSOrder['OrderID'];
			$Options[$DependOrderID]= SPrintF('Сервер: %s / %s',$DSOrder['Name'],$DSOrder['IP']);
			#-------------------------------------------------------------------------------
			$OrderCount++;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Form/Select',Array('name'=>'DependOrderID','style'=>'width: 240px;'),$Options,$DependOrderID);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	// если лицензии есть НЕ на все VPS / выделенные серера, добавляем поле
	if(SizeOf($Options) > 1)
		$Table[] = Array('Заказ сервера',$Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# проверяем, есть ли услуги для которых можно заказать
	if($OrderCount < 1)
		if(!IsSet($AllowExternalOrder))
			return new gException('ISPsw_OWNER_NOT_HAVE_ACTIVE_ORDERS','Выбранный профиль не имеет активных заказанных услуг. Выберите другой, или, закажите услугу хостинга, VPS или выделенного сервера. После этого, вы сможете заказать лицензию на программное обеспечение ISPsystem.');
	#---------------------------------------------------------------------------
	#---------------------------------------------------------------------------
	if(IsSet($AllowExternalOrder)){
		# окошко для ввода IP
		$Comp = Comp_Load(
				'Form/Input',
				Array(
					'name'   => 'IP',
					'size'   => 25,
					'type'   => 'text',
					'prompt' => 'IP адрес для заказываемой лицензии. Будте внимательны, адрес можно менять лишь раз в месяц.',
					'value'  => '0.0.0.0'
				)
			);
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------
		$Table[] = 'Для лицензий, заказываемых не к нашим услугам - для ваших нужд';
		#-------------------------------------------------------------------------
		$Table[] = Array('IP адрес лицензии',$Comp);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'type'    => 'button',
				'name'    => 'Submit',
				'onclick' => "ShowWindow('/ISPswOrder',FormGet(form));",
				'value'   => 'Продолжить'
				)
			);
	#---------------------------------------------------------------------
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#---------------------------------------------------------------------
	$Table[] = $Comp;
	#---------------------------------------------------------------------
	$Comp = Comp_Load('Tables/Standard',$Table);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#---------------------------------------------------------------------
	$Form->AddChild($Comp);
	#---------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'name'  => 'StepID',
				'value' => 2,
				'type'  => 'hidden',
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#---------------------------------------------------------------------
	$Form->AddChild($Comp);
	#---------------------------------------------------------------------
	$DOM->AddChild('Into',$Form);
	#-------------------------------------------------------------------------------
}else{ # $StepID is not set -> is set
	#-------------------------------------------------------------------------------
	// тупая проверка IP на валидность - на этом этапе больше ничего не проверить
	$IP = Long2IP(IP2Long($IP));
	#-----------------------------------------------------------------------------
	Debug(SPrintF('[comp/www/ISPswOrder]: IP = %s',$IP));
	#-----------------------------------------------------------------------------
	# если не задан ИП и не задан зависимый заказ - вертаем ошибку
	if($IP == '0.0.0.0' && !$DependOrderID)
		return new gException('ISPsw_NO_DEPEND_ORDER_OR_VALID_IP','Укажите заказ к которому вы заказываете лицензию, или, корректный IP адрес');
	#-----------------------------------------------------------------------------
	// select IP for order - если он не задан явно
	if($IP == '0.0.0.0'){
		#-----------------------------------------------------------------------------
		// достаём код услуги которая была выбрана
		$DependOrder = DB_Select('OrdersOwners',Array('ID','ServerID','ContractID','(SELECT `Code` FROM `Services` WHERE `ID` = `OrdersOwners`.`ServiceID`) AS `Code`'),Array('UNIQ','ID'=>$DependOrderID));
		#-------------------------------------------------------------------------------
		switch(ValueOf($DependOrder)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return new gException('ORDER_NOT_FOUND',SPrintF('Заказ (#%u) не найден. Обратитесь в службу поддержки пользователей.',$DependOrderID));
		case 'array':
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-----------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$OrderInfo = DB_Select(SPrintF('%sOrdersOwners',$DependOrder['Code']),'IP',Array('Where'=>Array(SPrintF('`OrderID` = %u',$DependOrderID)),'UNIQ'));
		#-------------------------------------------------------------------------------
		switch(ValueOf($OrderInfo)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			Debug(SPrintF("[comp/www/ISPswOrder]: OrderInfo found, IP = %s",$OrderInfo['IP']));
			break;
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
	}else{
		#-----------------------------------------------------------------------------
		# проверяем, не введён ли IP от VPS/DS юзера
		$Columns = Array('`Login` AS `IP`','`ID` AS `DependOrderID`',"'VPS' AS `OrderType`");
		#-----------------------------------------------------------------------------
		$OrderInfo = DB_Select('VPSOrdersOwners',$Columns,Array('Where'=>SPrintF('`Login` = "%s" AND `UserID` = %u',$IP,$__USER['ID']),'UNIQ'));
		#-----------------------------------------------------------------------------
		switch(ValueOf($OrderInfo)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-----------------------------------------------------------------------------
			$OrderInfo = Array('IP' => $IP);
			#-----------------------------------------------------------------------------
			break;
			#-----------------------------------------------------------------------------
		case 'array':
			#-----------------------------------------------------------------------------
			$IsInternal = TRUE;
			#-----------------------------------------------------------------------------
			break;
			#-----------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-----------------------------------------------------------------------------
	}
	#-----------------------------------------------------------------------------
	# IP заказа к которому надо прицепить лицензию
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'name'  => 'IP',
				'type'  => 'hidden',
				'value' => $OrderInfo['IP']
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	# номер заказа к которому надо прицепить лицензию
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'name'  => 'DependOrderID',
				'type'  => 'hidden',
				'value' => $DependOrderID
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-----------------------------------------------------------------------------
	#-----------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'name'  => 'ContractID',
				'type'  => 'hidden',
				'value' => $ContractID
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Services/Schemes','ISPswSchemes',$__USER['ID'],Array('Name'),$UniqID);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------
	$Columns = Array('ID','Name','Comment','CostMonth');
	#-------------------------------------------------------------------------
	Debug("[comp/www/ISPswOrder]: IP before WherePart = " . $IP);
	#-----------------------------------------------------------------------------
	$Where  = Array('`IsActive` = "yes"');
	#-----------------------------------------------------------------------------
	$Where[]= SPrintF('`IsInternal` = "%s"',((IsSet($IsInternal) || $IP == '0.0.0.0' || $IP == '')?'yes':'no'));
	#-------------------------------------------------------------------------------	
	$ISPswSchemes = DB_Select($UniqID,$Columns,Array('SortOn'=>Array('SortID'),'Where'=>$Where));
	#-----------------------------------------------------------------------------
	switch(ValueOf($ISPswSchemes)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return new gException('ISPsw_SCHEMES_NOT_FOUND','Для указанного заказа нет возможности приобретения ПО ISPsystem. Обратитесь в службу поддержки пользователей.');
	case 'array':
		#-------------------------------------------------------------------------------
		$NoBody = new Tag('NOBODY');
		#-------------------------------------------------------------------------------
		$Tr = new Tag('TR');
		#-------------------------------------------------------------------------------
		$Tr->AddChild(new Tag('TD',Array('class'=>'Head','colspan'=>2),'Тариф'));
		#-------------------------------------------------------------------------------
		$Tr->AddChild(new Tag('TD',Array('class'=>'Head','align'=>'center'),'Цена в месяц'));
		#-------------------------------------------------------------------------------
		$Rows = Array($Tr);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		foreach($ISPswSchemes as $ISPswScheme){
			#-------------------------------------------------------------------------------
			$Comp = Comp_Load(
					'Form/Input',
					Array(
						'name'  => 'ISPswSchemeID',
						'type'  => 'radio',
						'value' => $ISPswScheme['ID']
						)
					);
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			if($ISPswScheme['ID'] == $ISPswSchemeID || (!$ISPswSchemeID && !IsSet($IsChecked))){
				#-------------------------------------------------------------------------------
				$Comp->AddAttribs(Array('checked'=>'true'));
				#-------------------------------------------------------------------------------
				$IsChecked = TRUE;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$Comment = $ISPswScheme['Comment'];
			#-------------------------------------------------------------------------------
			if($Comment)
				$Rows[] = new Tag('TR',new Tag('TD',Array('colspan'=>2)),new Tag('TD',Array('colspan'=>2,'class'=>'Standard','style'=>'background-color:#FDF6D3;'),$Comment));
			#-------------------------------------------------------------------------------
			$CostMonth = Comp_Load('Formats/Currency',$ISPswScheme['CostMonth']);
			if(Is_Error($CostMonth))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Rows[] = new Tag(
					'TR',Array('OnClick'=>SPrintF('document.forms[\'ISPswOrderForm\'].ISPswSchemeID.value=%s',$ISPswScheme['ID'])),
					new Tag('TD',Array('width'=>20),$Comp),
					new Tag('TD',Array('class'=>'Comment'),$ISPswScheme['Name']),
					new Tag('TD',Array('class'=>'Standard','align'=>'right'),$CostMonth)
					);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		$Comp = Comp_Load('Tables/Extended',$Rows,Array('align'=>'center'));
		if(Is_Error($Comp))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$Table[] = $Comp;
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	$Div = new Tag('DIV',Array('align'=>'right'),'');
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load(
			'Form/Input',
			Array(
				'type'    => 'button',
				'onclick' => 'Order("ISPsw");',
				'value'   => 'Продолжить'
				)
			);
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Div->AddChild($Comp);
	#-------------------------------------------------------------------------------
	$Table[] = $Div;
	#-------------------------------------------------------------------------------
	$Comp = Comp_Load('Tables/Standard',$Table,Array('width'=>400));
	if(Is_Error($Comp))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Form->AddChild($Comp);
	#-------------------------------------------------------------------------------
	$DOM->AddChild('Into',$Form);
	#-------------------------------------------------------------------------------
}	# end of $StepID is set
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Out = $DOM->Build(FALSE);
#-------------------------------------------------------------------------------
if(Is_Error($Out))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return Array('Status'=>'Ok','DOM'=>$DOM->Object);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
