<?php
/**
 *
 *  Joonte Billing System
 *
 *  Copyright © 2012 Vitaly Velikodnyy
 *
 */

class DomainOrdersOnRegisterMsg extends Message {
	#-------------------------------------------------------------------------------
	public function __construct(array $params, $toUser){
		#-------------------------------------------------------------------------------
		parent::__construct('DomainOrdersOnRegister', $toUser);
		#-------------------------------------------------------------------------------
		$this->setParams($params);
		#-------------------------------------------------------------------------------
	}
	
	#-------------------------------------------------------------------------------
	public function getParams() {
		#-------------------------------------------------------------------------------
		$Server = new DomainServer();
		#-------------------------------------------------------------------------------
		$IsSelected = $Server->Select((integer)$this->params['ServerID']);
		#-------------------------------------------------------------------------------
		switch(ValueOf($IsSelected)){
		#-------------------------------------------------------------------------------
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'true':
			#-------------------------------------------------------------------------------
			$DomainZone = $this->params['Name'];
			#-------------------------------------------------------------------------------
			// For RegRu only
			if($Server->Settings['Params']['SystemID'] == 'RegRu' && In_Array($DomainZone,Array('ru','su','рф'))){
				#-------------------------------------------------------------------------------
				$Domain = SprintF("%s.%s",$this->params['DomainName'],$DomainZone);
				#-------------------------------------------------------------------------------
				$Result = $Server->GetUploadID($Domain);
				#-------------------------------------------------------------------------------
				switch(ValueOf($Result)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'array':
					#-------------------------------------------------------------------------------
					$UploadID = $Result['UploadID'];
					#-------------------------------------------------------------------------------
					$this->params['UploadID'] = $UploadID;
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[system/classes/DomainOrdersOnRegisterMsg.class.php]: UploadID = %s',$UploadID));
					#-------------------------------------------------------------------------------
					break;
					#-------------------------------------------------------------------------------
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// сообщение добавляемое к письму о регистрации домена. пока есть только у .pro доменов, из-за особенностей регистрации
			$DomainZones = Comp_Load('Formats/DomainOrder/DomainZones',FALSE,FALSE);
			if(Is_Error($DomainZones))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			if(IsSet($DomainZones[$DomainZone]['RegistrationMessage']))
				$this->params['RegistrationMessage'] = $DomainZones[$DomainZone]['RegistrationMessage'];
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		return $this->params;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
