<?php
/**
 *
 *  Joonte Billing System
 *
 *  Copyright © 2020 Alex Keda, for www.host-food.ru
 *
 */

class DomainOrdersSuspendedMsg extends Message {
	#-------------------------------------------------------------------------------
	public function __construct(array $params, $toUser) {
		#-------------------------------------------------------------------------------
		parent::__construct('DomainOrdersSuspended', $toUser, $params);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	public function getParams() {
		#-------------------------------------------------------------------------------
		$DomainScheme = DB_Select('DomainSchemes', Array('*'), Array('UNIQ', 'Where' => SPrintF('`ID` = %u',$this->params['SchemeID'])));
		#-------------------------------------------------------------------------------
		if(!Is_Array($DomainScheme))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		$this->params['DomainScheme'] = $DomainScheme;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// ссылка на продление заказа
		$this->params['ProlongLink'] = SPrintF('%s://%s/v2/DomainOrderPay/%u/',URL_SCHEME,HOST_ID,$this->params['OrderID']);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		return $this->params;
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}

