<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for crazych */
#-------------------------------------------------------------------------------
if(Is_Error(System_Load('libs/HTTP.php','classes/Net_IDNA.class.php')))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Logon($Settings,$Params){
	/******************************************************************************/
	$__args_types = Array('array','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	return Array('Url'=>SPrintF('%s/auth.php',$Settings['Params']['Url']),'Args'=>Array('lan'=>'/','lang'=>$Settings['Params']['Language'],'login'=>$Params['Login'],'password'=>$Params['Password']));
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Get_Domains($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	#-----------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	// для PunyCode
	$IDNA = new Net_IDNA();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'listuseracc';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// нет юзеров
	if($Doc['error'] == 1)
		return Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// ошибка какая-то
	if($Doc['error'] > 1)
		return new gException('GET_USERS_ERROR',SPrintF('%s:%s',$Doc['error'],$Doc['mess']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Users = Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем юзеров, достаём их домены
	foreach($Doc['data'] as $User){
		#-------------------------------------------------------------------------------
		// общая часть запроса
		$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
		#-------------------------------------------------------------------------------
		// достаём www домены
		$Request['module']	= 'apacserver';
		$Request['subdo']	= 'list_http';
		$Request['user_edit']	= $User;
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
		$Doc = Json_Decode(Trim($Response['Body']),TRUE);
		#-------------------------------------------------------------------------------
		// может доменов-то и нету? или ошибка
		if(!IsSet($Doc['code']) || $Doc['code'] == 100){
			#-------------------------------------------------------------------------------
			// нечего делать
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			foreach($Doc['detail'] as $Domain){
				#-------------------------------------------------------------------------------
				// выпиливаем www
				if(Preg_Match('/^www\.(.+)$/',$Domain,$Matches))
					$Domain = Next($Matches);
				#-------------------------------------------------------------------------------
				// создаём массив под домены, если он не существует
				if(!IsSet($Users[$User]))
					$Users[$User] = Array();
				#-------------------------------------------------------------------------------
				$Users[$User][] = $Domain;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// достаём ДНС домены
		// общая часть запроса
		$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
		#-------------------------------------------------------------------------------
		// достаём www домены
		$Request['module']	= 'bindserver';
		$Request['subdo']	= 'list_zones';
		$Request['user_edit']	= $User;
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
		$Doc = Json_Decode(Trim($Response['Body']),TRUE);
		#-------------------------------------------------------------------------------
		// может доменов-то и нету? или ошибка
		if(!IsSet($Doc['code']) || $Doc['code'] == 100){
			#-------------------------------------------------------------------------------
			// нечего делать
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			foreach($Doc['zones'] as $Domain){
				#-------------------------------------------------------------------------------
				// конвертим домен из PunyCode, панель какого-то хрена отдаёт без ковертации
				// https://community.brainycp.com/viewtopic.php?f=7&t=3933
				if($Domain['domain_decode'] != $IDNA->decode($Domain['domain_decode']))
					$Domain['domain_decode'] = $IDNA->decode($Domain['domain_decode']);
				#-------------------------------------------------------------------------------
				// выпиливаем www
				if(Preg_Match('/^www\.(.+)$/',$Domain['domain_decode'],$Matches))
					$Domain['domain_decode'] = Next($Matches);
				#-------------------------------------------------------------------------------
				// создаём массив под домены, если он не существует
				if(!IsSet($Users[$User]))
					$Users[$User] = Array();
				#-------------------------------------------------------------------------------
				if(!In_Array($Domain['domain_decode'],$Users[$User]))
					$Users[$User][] = $Domain['domain_decode'];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		// почтовые домены
		// общая часть запроса
		$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
		#-------------------------------------------------------------------------------
		$Request['module']	= 'mailclient';
		$Request['subdo']	= 'getlistmail';
		$Request['panel_user']	= $User;
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
		$Doc = Json_Decode(Trim($Response['Body']),TRUE);
		#-------------------------------------------------------------------------------
		if(!IsSet($Doc['error']) || $Doc['error'] > 0){
			// ничего, нет ящиков или ошибка
		}else{
			#-------------------------------------------------------------------------------
			foreach($Doc['data'] as $Email){
				#-------------------------------------------------------------------------------
				$Array = Explode('@',$Email);
				$Domain = $Array[1];
				#-------------------------------------------------------------------------------
				// создаём массив под домены, если он не существует
				if(!IsSet($Users[$User]))
					$Users[$User] = Array();
				#-------------------------------------------------------------------------------
				if(!In_Array($Domain,$Users[$User]))
					$Users[$User][] = $Domain;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[system/libs/Brainy.php]: UsersList = %s',print_r($Users,true)));
	return $Users;
	#-----------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Get_Users($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'listuseracc';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	// нет юзеров
	if($Doc['error'] == 1)
		return Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// ошибка какая-то
	if($Doc['error'] > 1)
		return new gException('GET_USERS_ERROR',SPrintF('%s:%s',$Doc['error'],$Doc['mess']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Users = $Doc['data'];
	#-------------------------------------------------------------------------------
	$Result = Array();
	#-------------------------------------------------------------------------------
	foreach($Users as $User){
		#-------------------------------------------------------------------------------
		// TODO по уму надо и владельцев проверять, но пока лень
		$Result[] = $User;
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#Debug(SPrintF('[Brainy_Get_Get_Users]: after func=user, Result = %s',print_r($Result,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Result;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Create($Settings,$Login,$Password,$Domain,$IP,$HostingScheme,$Email,$PersonID = 'Default',$Person = Array()){
	/******************************************************************************/
	$__args_types = Array('array','string','string','string','string','array','string','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	$IsReselling = $HostingScheme['IsReselling'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	# JBS-543, проверяем наличие такого юзера
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'getlistacc';
	$Request['panel_user']	= $Login;
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	// пользователь существует
	if(IsSet($Doc['error']) && $Doc['error'] == 0)
		return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем наличие тарифа
	if(!$Out = Brainy_Add_Scheme($Settings,$HostingScheme))
		return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'adduseracc';
	$Request['lg']		= $Login;
	$Request['ps']		= $Password;
	$Request['plan']	= Brainy_SchemeName($HostingScheme);
	$Request['ip']		= $IP;
	$Request['group']	= 'auto_JBS';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[Brainy_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	// костыль, бля: https://community.brainycp.com/viewtopic.php?f=7&t=3921
	if(IsSet($Doc['err']))
		$Doc['error'] = $Doc['err'];
	#-------------------------------------------------------------------------------
	// 16:Хост аккаунт успешно добавлен. Значение ip, в поле тарифа пустое. Проверьте корректность данного параметра
	// х.з. что за ошибка...
	if(!IsSet($Doc['error']) || ($Doc['error'] > 0 && $Doc['error'] != 16 ))
		return new gException('ACCOUNT_CREATE_ERROR',SPrintF('Не удалось создать заказ хостинга: %s:%s',$Doc['error'],$Doc['mess']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// добавляем домен на аккаунт
	$IDNA = new Net_IDNA();
	#-------------------------------------------------------------------------------
	$Domain = $IDNA->encode($Domain);
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	# https://community.brainycp.com/viewtopic.php?f=7&t=505&p=9083#p8620
	$Request['module']	= 'server_control';
	$Request['subdo']	= 'add_domain';
	$Request['domains']	= $Domain;
	$Request['ip']		= $IP;
	$Request['dir']		= $Domain;
	$Request['bridge']	= 'mod_php';
	$Request['php_version']	= 'php56w';
	$Request['user_edit']	= $Login;
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[Brainy_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	if(!IsSet($Doc['code']) || $Doc['code'] != 200)
		Debug(SPrintF('[Brainy_Create]: не удалось добавить www домен, сервер вернул: %s',Print_R($Doc,TRUE)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Active($Settings,$Login,$IsReseller = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','string','boolean');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'unsuspendacc';
	$Request['panel_user']	= $Login;
	$Request['action']	= 'unsuspend_full';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[Brainy_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['code']) && $Doc['code'] == 0){
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		return new gException('ACCOUNT_ACTIVATE_ERROR','Не удалось активировать заказ хостинга');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Suspend($Settings,$Login,$IsReseller = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','string','boolean');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'suspendacc';
	$Request['panel_user']	= $Login;
	$Request['action']	= 'suspend_full';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[Brainy_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['code']) && $Doc['code'] == 0){
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		return new gException('ACCOUNT_SUSPEND_ERROR','Не удалось заблокировать заказ хостинга');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Delete($Settings,$Login,$IsReseller = FALSE){
	/******************************************************************************/
	$__args_types = Array('array','string','boolean');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'deluseracc';
	$Request['panel_user']	= $Login;
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[Brainy_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	if(IsSet($Doc['error']) && ($Doc['error'] == 0 || $Doc['error'] == 1001)){
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		return new gException('ACCOUNT_DELETE_ERROR','Не удалось удалить заказ хостинга');
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Scheme_Change($Settings,$Login,$HostingScheme){
	/******************************************************************************/
	$__args_types = Array('array','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	// проверяем наличие тарифа
	if(!$Out = Brainy_Add_Scheme($Settings,$HostingScheme))
		return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// достаём то что юзером сейчас используется
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'getlistacc';
	$Request['panel_user']	= $Login;
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[Brainy_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	#Debug(print_r($Doc,true));
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$HostingScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		$r_Value = IsSet($HostingScheme['SchemeParams'][$Key])?$HostingScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$r_Key = SPrintF('r_%s',$Key);
		#-------------------------------------------------------------------------------
		// сравниваем цифровые значения
		if(IsSet($Field['Min']))
			if(IsSet($Doc['data'][$r_Key]))
				if($Doc['data'][$r_Key] > $HostingScheme['SchemeParams'][$Key])
					return new gException('TOO_MANY_VALUE',SPrintF('Превышен лимит %s: %s',$Key,$Field['Name']));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'edituseracc';
	// https://community.brainycp.com/viewtopic.php?f=7&t=3926&p=9092#p9092
	$Request['panel_user']	= $Login;	// они сами не знают как оно называется
	$Request['lg']		= $Login;	// они сами не знают как оно называется
	$Request['plan']	= Brainy_SchemeName($HostingScheme);
	$Request['group']	= '';
	#-------------------------------------------------------------------------------
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$HostingScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		//if(!$Field['IsSchemeChange'])
		//	continue;
		#-------------------------------------------------------------------------------
		$Value = IsSet($HostingScheme['SchemeParams'][$Key])?$HostingScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?'y':'n';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Request['shell_access']= $Request['shell'];
	$Request['lang']	= 'ru';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[Brainy_Create]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// костыль, бля: https://community.brainycp.com/viewtopic.php?f=7&t=3921
	if(IsSet($Doc['err']))
		$Doc['error'] = $Doc['err'];
	#-------------------------------------------------------------------------------
	if(!IsSet($Doc['error']) || $Doc['error'] > 0 )
		return new gException('SCHEME_CHANGE_ERROR',SPrintF('%s:%s',$Doc['error'],$Doc['mess']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Password_Change($Settings,$Login,$Password,$Params){
	/******************************************************************************/
	$__args_types = Array('array','string','string','array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	# JBS-543, проверяем наличие такого юзера
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'getlistacc';
	$Request['panel_user']	= $Login;
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// параметры запроса, суём то что достали
	$Request = $Doc['data'];
	#-------------------------------------------------------------------------------
	// удаляем ненужное
	UnSet($Request['passhash']);
	// диск/полоса(которая на самом деле траффик) почему-то в байтах передаётся, а обратно надо в мегабайтах
	$Request['disk']	= $Request['disk'] / (1024*1024);
	$Request['bandwidth']	= $Request['bandwidth'] / (1024*1024);
	// test
	$Request['ctl_max_user_task'] = 10;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Request['login']	= $Settings['Login'];
	$Request['pass']	= $Settings['Password'];
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'edituseracc';
	// https://community.brainycp.com/viewtopic.php?f=7&t=3926&p=9092#p9092
	$Request['panel_user']	= $Login;	// они сами не знают как оно называется
	$Request['lg']		= $Login;	// они сами не знают как оно называется
	$Request['ps']		= $Password;
	//$Request['plan']	= Brainy_SchemeName($HostingScheme);
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return ERROR | @Trigger_Error('[Brainy_Password_Change]: не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	if(!IsSet($Doc['err']) || $Doc['err'] > 0)
		return new gException('PASSWORD_CHANGE_ERROR',SPrintF('%s:%s',$Doc['err'],$Doc['mess']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Get_Email_Boxes($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/

	// панель не рассказывает про квоту и про текущий размер ящика
	return Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------

	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'listuseracc';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	// нет юзеров
	if($Doc['error'] == 1)
		return Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// ошибка какая-то
	if($Doc['error'] > 1)
		return new gException('GET_USERS_ERROR',SPrintF('%s:%s',$Doc['error'],$Doc['mess']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Users = $Doc['data'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем юзеров, достаём их почтовые ящики
	foreach($Users as $User){
		#-------------------------------------------------------------------------------
		// общая часть запроса
		$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
		#-------------------------------------------------------------------------------
		$Request['module']	= 'mailclient';
		$Request['subdo']	= 'getlistmail';
		$Request['panel_user']	= $User;
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
		$Doc = Json_Decode(Trim($Response['Body']),TRUE);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// панель не рассказывает про квоту и про текущий размер ящика
	return Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


# added by lissyara 2014-01-16 in 10:46 MSK, for JBS-764
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Get_Disk_Usage($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	// общая часть запроса, список юзеров
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'listuseracc';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	// нет юзеров
	if($Doc['error'] == 1)
		return Array();
	#-------------------------------------------------------------------------------
	// ошибка какая-то
	if($Doc['error'] > 1)
		return new gException('GET_USERS_ERROR',SPrintF('%s:%s',$Doc['error'],$Doc['mess']));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Out = Array();
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// перебираем юзеров, достаём их использование диска
	foreach($Doc['data'] as $User){
		#-------------------------------------------------------------------------------
		// общая часть запроса
		$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
		#-------------------------------------------------------------------------------
		// достаём то что юзером сейчас используется
		$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
		#-------------------------------------------------------------------------------
		$Request['module']	= 'hostacc';
		$Request['subdo']	= 'getlistacc';
		$Request['panel_user']	= $User;
		#-------------------------------------------------------------------------------
		$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
		if(Is_Error($Response))
			return ERROR | @Trigger_Error('[Brainy_Create]: не удалось соедениться с сервером');
		#-------------------------------------------------------------------------------
		$Doc = Json_Decode(Trim($Response['Body']),TRUE);
		#-------------------------------------------------------------------------------
		$Disabled = (IsSet($Doc['data']['suspended_full']) && $Doc['data']['suspended_full'])?TRUE:FALSE;
		#-------------------------------------------------------------------------------
		// непонятно почему - но бывает что нет лимита, ставим большой
		$Limit = IsSet($Doc['data']['disk'])?($Doc['data']['disk']/(1024*1024)):1000000;
		#-------------------------------------------------------------------------------
		$Out[$User] = Array('Limit'=>$Limit,'Used'=>$Doc['data']['h_r_disk'],'Disabled'=>$Disabled);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	//Debug(SPrintF('[Brainy_Get_Disk_Usage]: %s',print_r($Out,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------




#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# Функции используемые для внутреннего употребления =)
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

function Brainy_Add_Scheme($Settings,$HostingScheme){
	/******************************************************************************/
	$__args_types = Array('array','array');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем наличие группы, нужна при смене тарифа:
	// https://community.brainycp.com/viewtopic.php?f=7&t=3923
	if(!$Out = Brainy_Add_Group($Settings))
		return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$SchemeName = Brainy_SchemeName($HostingScheme);
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем наличие такого тарифа
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'viewplanacc';
	$Request['plan']	= $SchemeName;
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	// костыль, бля: https://community.brainycp.com/viewtopic.php?f=7&t=3921
	if(IsSet($Doc['err']))
		$Doc['error'] = $Doc['err'];
	#-------------------------------------------------------------------------------
	// определяем что дальше делаем - редактируем или добавляем новый
	$SubDo = ($Doc['error'] == 0)?'editplanacc':'addplanacc';
	#-------------------------------------------------------------------------------
	// считываем XML и составляем запрос
	$Fields = System_XML(SPrintF('config/Schemes.%s.xml',$HostingScheme['SchemeParams']['SystemID']));
	if(Is_Error($Fields))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	foreach(Array_Keys($Fields) as $Key){
		#-------------------------------------------------------------------------------
		$Field = $Fields[$Key];
		#-------------------------------------------------------------------------------
		$Value = IsSet($HostingScheme['SchemeParams'][$Key])?$HostingScheme['SchemeParams'][$Key]:$Field['Value'];
		#-------------------------------------------------------------------------------
		$Request[$Key] = $Value;
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Min']))
			$Request[$Key] = IntVal($Value);
		#-------------------------------------------------------------------------------
		if(IsSet($Field['Type']) && $Field['Type'] == 'CheckBox')
			$Request[$Key] = ($Request[$Key])?'y':'n';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= $SubDo;
	$Request['plan']	= $SchemeName;
	$Request['lang']	= 'ru';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	// костыль, бля: https://community.brainycp.com/viewtopic.php?f=7&t=3921
	if(IsSet($Doc['err']))
		$Doc['error'] = $Doc['err'];
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($Doc['error'] == 0){
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		return new gException('CANNOT_CREATE_OR_MODIFY_SCHEME',SPrintF('%s:%s',$Doc['error'],$Doc['mess']));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Add_Group($Settings){
	/******************************************************************************/
	$__args_types = Array('array','array');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Brainy_Build_HTTP($Settings);
	#-------------------------------------------------------------------------------
	// общая часть запроса
	$Request = Array('login'=>$Settings['Login'],'pass'=>$Settings['Password']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// проверяем наличие такой группы
	$Request['module']	= 'hostacc';
	$Request['subdo']	= 'viewgroupacc';
	$Request['group']	= 'auto_JBS';
	$Request['apifull']	= 'n';		// оно по дефолту создаётся с полным доступом...
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// определить результат запроса не представляется возможным:
	// https://community.brainycp.com/viewtopic.php?f=7&t=3927&p=9094#p9094
	#return TRUE;
	#-------------------------------------------------------------------------------
	// определяем что дальше делаем - редактируем или добавляем новую
	#$SubDo = ($Doc['error'] == 0)?'editgroupacc':'addgroupacc';
	$SubDo = 'addgroupacc';
	#-------------------------------------------------------------------------------
	$Request['module']	= 'hostacc';
	$Request['subdo']	= $SubDo;
	$Request['group']	= 'auto_JBS';
	#-------------------------------------------------------------------------------
	$Response = HTTP_Send('/api/api.php',$HTTP,Array(),$Request);
	if(Is_Error($Response))
		return new gException('NOT_CONNECTED_TO_SERVER','Не удалось соедениться с сервером');
	#-------------------------------------------------------------------------------
	$Doc = Json_Decode(Trim($Response['Body']),TRUE);
	#-------------------------------------------------------------------------------
	// определить результат запроса не представляется возможным:
	// https://community.brainycp.com/viewtopic.php?f=7&t=3927&p=9094#p9094
	return TRUE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($Doc['error'] == 0){
		#-------------------------------------------------------------------------------
		return TRUE;
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		return new gException('CANNOT_CREATE_OR_MODIFY_GROUP',SPrintF('%s:%s',$Doc['error'],$Doc['mess']));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// генерация имени тарифа, чтобы в одном месте было
function Brainy_SchemeName($HostingScheme){
	/******************************************************************************/
	$__args_types = Array('array');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	return SPrintF('auto_%s',$HostingScheme['PackageID']);
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Brainy_Build_HTTP($Settings){
	/******************************************************************************/
	$__args_types = Array('array');
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$HTTP = Array(
			'Address'	=> $Settings['Params']['IP'],
			'Port'		=> $Settings['Port'],
			'Host'		=> $Settings['Address'],
			'Protocol'	=> $Settings['Protocol'],
			'Hidden'	=> $Settings['Password'],
			'IsLogging'	=> $Settings['Params']['IsLogging']
			);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $HTTP;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}


?>
