<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
#-------------------------------------------------------------------------------
function WhoIs_Parse($Domain){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[system/libs/WhoIs]: run function WhoIs_Parse, Domain = %s',$Domain));
	#-------------------------------------------------------------------------------
	// проверяем домен на регулярку
	$Regulars = Regulars();
	#-------------------------------------------------------------------------------
	$Domain = Mb_StrToLower($Domain,'UTF-8');
	#-------------------------------------------------------------------------------
	if(!Preg_Match($Regulars['Domain'],$Domain))
		return FALSE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	// достаём зону
	$DomainName = SPrintF('%s.',$Domain);
	#-------------------------------------------------------------------------------
	$SubDomains = Explode('.',$DomainName);
	#-------------------------------------------------------------------------------
	$DomainZone = $SubDomains[SizeOf($SubDomains) - 2 ];
	#-------------------------------------------------------------------------------
	if(!$DomainZone)
		return FALSE;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# достаём список серверов на которых есть такой тариф
	$Zones = DB_Select('DomainSchemes',Array('Name','ServerID'),Array('Where'=>Array('`IsActive` = "yes"',SPrintF('`Name` = "%s"',$DomainZone))));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Zones)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		return FALSE;
	case 'array':
		#-------------------------------------------------------------------------------
		foreach($Zones as $Zone)
			#if(Preg_Match(SPrintF('/^([0-9a-zабвгдеёжзийклмнопрстуфхцчшщьыъэюя\-]+)\.%s$/',Str_Replace('.','\.',$Zone['Name'])),$Domain,$Matches))
			if(Preg_Match(SPrintF('/^([0-9\p{Cyrillic}\p{Latin}\p{Han}\-]+)\.%s$/u',Str_Replace('.','\.',$Zone['Name'])),$Domain,$Matches))
				return Array('DomainName'=>Next($Matches),'DomainZone'=>$DomainZone);
		#-------------------------------------------------------------------------------
		// не нашлось. странно, но вернём FALSE
		return FALSE;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function WhoIs_Check($DomainName,$ZoneName,$IsAvalible = FALSE){
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[system/libs/WhoIs]: run function WhoIs_Check, Domain = %s.%s',$DomainName,$ZoneName));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$CacheID1 = SPrintF('WhoIs-%s.%s',$DomainName,$ZoneName);
	$CacheID2 = SPrintF('WhoIs-%s-%s.%s',($IsAvalible)?1:0,$DomainName,$ZoneName);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if($Out = CacheManager::get($CacheID2))
		return $Out;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Answer = CacheManager::get($CacheID1);
	#-------------------------------------------------------------------------------
	if(!$Answer){
		#-------------------------------------------------------------------------------
		$DomainZone = Comp_Load('Formats/DomainOrder/DomainZones',$ZoneName,FALSE);
		if(Is_Error($DomainZone))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		if(!$DomainZone['IsSupported'] || $DomainZone['IsUseRegistratorWhoIs']){
			#-------------------------------------------------------------------------------
			if(!$DomainZone['IsSupported'])
				Debug(SPrintF('[system/libs/WhoIs]: доменная зона не поддерживается'));
			#-------------------------------------------------------------------------------
			if($DomainZone['IsSupported'] && $DomainZone['IsUseRegistratorWhoIs'])
				Debug(SPrintF('[system/libs/WhoIs]: принудительное использование WhoIs регистратора'));
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			# чекаем доменную зону
			$Regulars = Regulars();
			#-------------------------------------------------------------------------------
			if(!Preg_Match($Regulars['DomainZone'],$ZoneName))
				return ERROR | @Trigger_Error(SPrintF('[system/libs/WhoIs]: неверная доменная зона (%s)',$ZoneName));
			#-------------------------------------------------------------------------------
			# достаём список серверов на которых есть такой тариф
			$Servers = DB_Select('DomainSchemes',Array('ServerID'),Array('Where'=>Array(SPrintF('`Name` = "%s"',$ZoneName),'`IsActive` = "yes" OR `IsProlong` = "yes" OR `IsTransfer` = "yes"')));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Servers)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return new gException('REGISTRATOR_SERVER_NOT_FOUND','Не найдены активные сервера регистраторов');
			case 'array':
				#-------------------------------------------------------------------------------
				$Array = Array();
				#-------------------------------------------------------------------------------
				foreach($Servers as $Server)
					$Array[] = $Server['ServerID'];
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			# достаём список активных серверов регистраторов
			$Servers = DB_Select('Servers',Array('ID','Address','Params'),Array('Where'=>Array(SPrintF('`ID` IN (%s)',Implode(',',$Array)),'`IsActive` = "yes"'),'SortOn'=>'Address'));
			#-------------------------------------------------------------------------------
			switch(ValueOf($Servers)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return new gException('REGISTRATOR_SERVER_NOT_FOUND','Не найдены активные сервера регистраторов');
			case 'array':
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			# перебираем регистраторов
			$UseServer = FALSE;
			#-------------------------------------------------------------------------------
			foreach($Servers as $iServer){
				#-------------------------------------------------------------------------------
				# если это не проверка доступности и в настройках сервера не стоит галка про получение WhoIs - пропускаем
				if(!$IsAvalible)
					if(!$iServer['Params']['IsFetchWhoIs'])
						continue;
				#-------------------------------------------------------------------------------
				# достаём использованные запросы к регистратору, на данную минуту
				$RatelimitID = SPrintF('ratelimit-%s-%s-00',$iServer['Address'],Date('H-i'));
				#-------------------------------------------------------------------------------
				$Ratelimit = CacheManager::get($RatelimitID);
				#-------------------------------------------------------------------------------
				# если из кэша что-то досталось и оно больше разрешённой частоты запросов - пропускаем цикл
				if($Ratelimit && $Ratelimit >= $iServer['Params']['RatelimitAPI']){
					#-------------------------------------------------------------------------------
					Debug(SPrintF('[system/libs/WhoIs]: превышена частота запросов к серверу %s (разрешено %u, использовано %u)',$iServer['Address'],$iServer['Params']['RatelimitAPI'],$Ratelimit));
					#-------------------------------------------------------------------------------
					continue;
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				# сохраняем, на пару минут, в кэш новое число запросов к регистратору
				CacheManager::add($RatelimitID,(IntVal($Ratelimit) + 1),120);
				#-------------------------------------------------------------------------------
				$UseServer = $iServer;
				#-------------------------------------------------------------------------------
				break;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			# если не задан сервер - частота превышена для всех серверов
			if(!$UseServer)
				return new gException('REGISTRATOR_SERVER_RATELIMIT','Превышена максимальная частота запросов к интерфейсу регистратора');
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			# выбираем сервер регистратора
			if(Is_Error(System_Load('classes/DomainServer.class.php')))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			$Server = new DomainServer();
			#-------------------------------------------------------------------------------
			$IsSelected = $Server->Select((integer)$UseServer['ID']);
			#-------------------------------------------------------------------------------
			switch(ValueOf($IsSelected)){
			case 'error':
				return ERROR | @Trigger_Error(500);
			case 'exception':
				return new gException('CANNOT_SELECT_REGISTRATOR','Не удалось выбрать регистратора');
			case 'true':
				break;
			default:
				return ERROR | @Trigger_Error(101);
			}
			#-------------------------------------------------------------------------------
			# делаем запрос к API - функция в зависимости от $IsAvalible
			if($IsAvalible){
				#-------------------------------------------------------------------------------
				$DomainCheck = $Server->DomainCheck($DomainName,$ZoneName);
				#-------------------------------------------------------------------------------
				switch(ValueOf($DomainCheck)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'exception':
					return ERROR | @Trigger_Error(400);
				case 'true':
					return TRUE;
				case 'false':
					return Array();
				case 'array':
					break;
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$DomainWhoIs = $Server->DomainWhoIs($DomainName,$ZoneName);
				#-------------------------------------------------------------------------------
				switch(ValueOf($DomainWhoIs)){
				case 'error':
					return ERROR | @Trigger_Error(500);
				case 'exception':
					# a функции нет ... вылезаем на обычную проверку whois
					break;
				case 'true':
					return TRUE;
				case 'string':
					#-------------------------------------------------------------------------------
					CacheManager::add($CacheID1,$DomainWhoIs,1800);
					#-------------------------------------------------------------------------------
					break;
					#-------------------------------------------------------------------------------
				default:
					return ERROR | @Trigger_Error(101);
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$Config = Config();
	#-------------------------------------------------------------------------------
	$UseSystemApplication = $Config['Other']['Libs']['WhoIs']['UseSystemApplication'];
	#-------------------------------------------------------------------------------
	$Regulars = Regulars();
	#-------------------------------------------------------------------------------
	if(!Preg_Match($Regulars['DomainName'],$DomainName))
		return new gException('WRONG_DOMAIN_NAME','Неверное доменное имя');
	#-------------------------------------------------------------------------------
	$DomainZone = Comp_Load('Formats/DomainOrder/DomainZones',$ZoneName,FALSE);
	if(Is_Error($DomainZone))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(!$DomainZone['IsSupported'] && !IsSet($DomainWhoIs))
		return FALSE;
	#-------------------------------------------------------------------------------
	if(Mb_StrLen($DomainName) < ($MinChars = $DomainZone['MinChars']))
		return new gException('WRONG_DOMAIN_NAME_LENGTH',SPrintF('Длина доменного имени должна быть не менее %u символа(ов)',$MinChars));
	#-------------------------------------------------------------------------------
	$IDNA = new Net_IDNA();
	#-------------------------------------------------------------------------------
	if(Mb_StrLen($IDNA->encode($DomainName)) > 63)
		return new gException('WRONG_DOMAIN_NAME_LENGTH',SPrintF('Длина доменного имени должна быть менее 64 символа(ов)'));
	#-------------------------------------------------------------------------------
	$Domain = SPrintF('%s.%s',$DomainName,$DomainZone['Name']);
	#-------------------------------------------------------------------------------
	$Answer = CacheManager::get($CacheID1);
	#-------------------------------------------------------------------------------
	if(!$Answer){
		#-------------------------------------------------------------------------------
		if($UseSystemApplication){
			#-------------------------------------------------------------------------------
			$IsExec = Exec(SPrintF('whois %s',$IDNA->encode($Domain)),$Answer);
			#-------------------------------------------------------------------------------
			$Answer = Implode("\n",$Answer);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			$Socket = @FsockOpen($DomainZone['Server'],43,$nError,$sError,5);
			#-------------------------------------------------------------------------------
			if(!$Socket)
				return ERROR | @Trigger_Error('[WhoIs_Check]: ошибка соединения с сервером WhoIs');
			#-------------------------------------------------------------------------------
			if(!@Fputs($Socket,SPrintF("%s\r\n",$IDNA->encode($Domain))))
				return ERROR | @Trigger_Error('[WhoIs_Check]: ошибка работы с серверов WhoIs');
			#-------------------------------------------------------------------------------
			$Answer = '';
			#-------------------------------------------------------------------------------
			do{
				#-------------------------------------------------------------------------------
				$Line = @Fgets($Socket,10);
				#-------------------------------------------------------------------------------
				$Answer .= $Line;
				#-------------------------------------------------------------------------------
			}while($Line);
			#-------------------------------------------------------------------------------
			Fclose($Socket);
			#-------------------------------------------------------------------------------
			CacheManager::add($CacheID1,$Answer,1800);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/WhoIs.php]: Answer = %s',print_r($Answer,true)));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if(Preg_Match(SPrintF('/%s/',$DomainZone['Available']),$Answer))
		return TRUE;
	#-------------------------------------------------------------------------------
	if(Preg_Match(SPrintF('/%s/',$DomainZone['NotAvailable']),$Answer))
		return new gException('DOMAIN_NOT_AVAILABLE','Доменное имя не доступно для регистрации');
	#-------------------------------------------------------------------------------
	$Result = Array('Info'=>Preg_Replace('/\n\s+\n/sU',"\n",Preg_Replace('/\%.+\n/sU','',$Answer)),'ExpirationDate'=>0);
	#-------------------------------------------------------------------------------
	$ExpirationDate = $DomainZone['ExpirationDate'];
	#-------------------------------------------------------------------------------
	if($ExpirationDate){
		#-------------------------------------------------------------------------------
		if(Preg_Match(SPrintF('/%s/',$ExpirationDate),$Answer,$Mathes)){
			#-------------------------------------------------------------------------------
			if(Count($Mathes) < 2)
				return ERROR | @Trigger_Error('[WhoIs_Check]: шаблон поиска даты окончания задан неверно');
			#-------------------------------------------------------------------------------
			$ExpirationDate = $Mathes[1];
			#-------------------------------------------------------------------------------
			$Months = Array('jan','feb','mar','apr','may','jun','jul','aug','sep','oct','nov','dec');
			#-------------------------------------------------------------------------------
			if(Preg_Match('/^[0-9]{4}\.[0-9]{2}\.[0-9]{2}$/',$ExpirationDate)){
				#-------------------------------------------------------------------------------
				$Date = Array_Combine(Array('Year','Month','Day'),Explode('.',$ExpirationDate));
				#-------------------------------------------------------------------------------
				$ExpirationDate = MkTime(0,0,0,$Date['Month'],$Date['Day'],$Date['Year']);
				#-------------------------------------------------------------------------------
			}elseif(Preg_Match('/^[0-9]{4}\-[0-9]{2}\-[0-9]{2}$/',$ExpirationDate)){
				#-------------------------------------------------------------------------------
				$Date = Array_Combine(Array('Year','Month','Day'),Explode('-',$ExpirationDate));
				#-------------------------------------------------------------------------------
				$ExpirationDate = MkTime(0,0,0,$Date['Month'],$Date['Day'],$Date['Year']);
				#-------------------------------------------------------------------------------
			}elseif(Preg_Match('/^[0-9]{2}\-[a-zA-Z]{3}\-[0-9]{4}$/',$ExpirationDate)){
				#-------------------------------------------------------------------------------
				$Date = Array_Combine(Array('Day','Month','Year'),Explode('-',$ExpirationDate));
				#-------------------------------------------------------------------------------
				$Month = Array_Search(StrToLower($Date['Month']),$Months);
				#-------------------------------------------------------------------------------
				$ExpirationDate = MkTime(0,0,0,$Month+1,$Date['Day'],$Date['Year']);
				#-------------------------------------------------------------------------------
			}elseif(Preg_Match('/^[0-9]{2}\s[a-zA-Z]{2,10}\s[0-9]{4}$/',$ExpirationDate)){
				#-------------------------------------------------------------------------------
				$Months = Array('january','february','march','april','may','june','july','august','september','octember','november','decemeber');
				#-------------------------------------------------------------------------------
				$Date = Array_Combine(Array('Day','Month','Year'),Preg_Split('/\s+/',$ExpirationDate));
				#-------------------------------------------------------------------------------
				$Month = Array_Search(StrToLower($Date['Month']),$Months);
				#-------------------------------------------------------------------------------
				$ExpirationDate = MkTime(0,0,0,$Month+1,$Date['Day'],$Date['Year']);
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$Date = Array_Combine(Array('Week','Month','Day','Time','GMT','Year'),Preg_Split('/\s+/',$ExpirationDate));
				#-------------------------------------------------------------------------------
				$Month = Array_Search(StrToLower($Date['Month']),$Months);
				#-------------------------------------------------------------------------------
				$ExpirationDate = MkTime(0,0,0,$Month+1,$Date['Day'],$Date['Year']);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$Result['ExpirationDate'] = $ExpirationDate;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$NsName = $DomainZone['NsName'];
	#-------------------------------------------------------------------------------
	if($NsName){
		#-------------------------------------------------------------------------------
		if(Preg_Match_All(SPrintF('/%s/',$NsName),$Answer,$Mathes)){
			#-------------------------------------------------------------------------------
			if(Count($Mathes) < 2)
				return ERROR | @Trigger_Error('[WhoIs_Check]: шаблон поиска именных серверов задан неверно');
			#-------------------------------------------------------------------------------
			$NsNames = $Mathes[1];
			#-------------------------------------------------------------------------------
			for($i=0;$i<Count($NsNames);$i++){
				#-------------------------------------------------------------------------------
				$NsName = Trim(StrToLower($NsNames[$i]),'.');
				#-------------------------------------------------------------------------------
				$Result[SPrintF('Ns%uName',$i+1)] = $NsName;
				#-------------------------------------------------------------------------------
				if($NsName){
					#-------------------------------------------------------------------------------
					if(Mb_SubStr($NsName,-Mb_StrLen($Domain)) == $Domain){
						#-------------------------------------------------------------------------------
						$IP = GetHostByName($NsName);
						#-------------------------------------------------------------------------------
						if($IP != $NsName)
							$Result[SPrintF('Ns%uIP',$i+1)] = $IP;
						#-------------------------------------------------------------------------------
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Registrar = $DomainZone['Registrar'];
	#-------------------------------------------------------------------------------
	if($Registrar){
		#-------------------------------------------------------------------------------
		if(Preg_Match(SPrintF('/%s/',$Registrar),$Answer,$Mathes)){
			#-------------------------------------------------------------------------------
			if(Count($Mathes) < 2)
				return ERROR | @Trigger_Error('[WhoIs_Check]: шаблон поиска регистратора серверов задан неверно');
			#-------------------------------------------------------------------------------
			$Registrar = Next($Mathes);
			#-------------------------------------------------------------------------------
			$Result['Registrar'] = $Registrar;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	CacheManager::add($CacheID2,$Result,3600);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Result;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
