<?php

#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
/******************************************************************************/
/******************************************************************************/
$__args_list = Array('Args');
/******************************************************************************/
Eval(COMP_INIT);
/******************************************************************************/
/******************************************************************************/
$Args = IsSet($Args)?$Args:Args();
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Config = Config();
#-------------------------------------------------------------------------------
$Settings = $Config['Other']['Upload'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(!IsSet($_FILES['Upload']))
	return ERROR | @Trigger_Error(201);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Debug(SPrintF('[comp/www/API/Upload]: _FILES = %s',print_r($_FILES,true)));
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$File = $_FILES['Upload'];
#-------------------------------------------------------------------------------
switch($File['error']){
case UPLOAD_ERR_OK:
	Debug('[Upload]: ошибок не возникало, файл был успешно загружен на сервер');
	break;
case UPLOAD_ERR_INI_SIZE:
	return ERROR | @Trigger_Error('[Upload]: размер принятого файла превысил максимально допустимый размер, который задан директивой upload_max_filesize конфигурационного файла php.ini');
	break;
case UPLOAD_ERR_FORM_SIZE:
	return ERROR | @Trigger_Error('[Upload]: размер загружаемого файла превысил значение MAX_FILE_SIZE, указанное в HTML-форме');
case UPLOAD_ERR_PARTIAL:
	return ERROR | @Trigger_Error('[Upload]: загружаемый файл был получен только частично');
case UPLOAD_ERR_NO_FILE:
	return ERROR | @Trigger_Error('[Upload]: файл не был загружен');
case UPLOAD_ERR_NO_TMP_DIR:
	return ERROR | @Trigger_Error('[Upload]: в php.ini не прописанно значение upload_tmp_dir');
case UPLOAD_ERR_CANT_WRITE:
	return ERROR | @Trigger_Error('[Upload]: ошибка записи на диск');
case UPLOAD_ERR_EXTENSION:
	return ERROR | @Trigger_Error('[Upload]: загрузка файла была остановлена расширением');
default:
	return ERROR | @Trigger_Error(SPrintF('[Upload]: не известный код ошибки (%s)',$File['error']));
}
#-------------------------------------------------------------------------------
if(!$File['size'] && IsSet($GLOBALS['IsCron']))
	return ERROR | @Trigger_Error('[Upload]: загружаемый файл имеет нулевой размер');
#-------------------------------------------------------------------------------
if($File['size'] > $Settings['MaxFileSize'] * 1024 * 1024 && !IsSet($GLOBALS['IsCron']))
	return new gException('FILE_TOO_BIG',SPrintF('Файл превышает максимально допустимый размер (%uMb > %uMb)',$File['size']/(1024*1024),$Settings['MaxFileSize']));
#-------------------------------------------------------------------------------
$Tmp = System_Element('tmp');
if(Is_Error($Tmp))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Path = $File['tmp_name'];
#-------------------------------------------------------------------------------
$Hash = Md5(MicroTime());
#-------------------------------------------------------------------------------
$Uploads = SPrintF('%s/uploads',$Tmp);
#-------------------------------------------------------------------------------
if(!File_Exists($Uploads))
	if(!@MkDir(SPrintF('%s/uploads',$Tmp),0777,TRUE))
		return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!Copy($Path,SPrintF('%s/%s',$Uploads,$Hash)))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Name = $File['name'];
#-------------------------------------------------------------------------------
$NamesPath = SPrintF('%s/names.txt',$Uploads);
#-------------------------------------------------------------------------------
$Names = (Is_Error($Names = IO_Read($NamesPath))?Array():JSON_Decode($Names,true));
#-------------------------------------------------------------------------------
$Names[$Hash] = $Name;
#-------------------------------------------------------------------------------
$IsWrite = IO_Write($NamesPath,JSON_Encode($Names),TRUE);
if(Is_Error($IsWrite))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$Size = Round($File['size']/1024);
#-------------------------------------------------------------------------------
# вывод для JS в браузере...
if(!IsSet($GLOBALS['IsCron']))
	echo SPrintF('%s^%s^%s^',$Name,$Size,$Hash);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// чистим директорию с загруженными файлами от старых
$Files = IO_Scan($Uploads);
if(Is_Error($Files))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
foreach($Files as $File){
	#-------------------------------------------------------------------------------
	if($File == 'names.txt')
		continue;
	#-------------------------------------------------------------------------------
	$Path = SPrintF('%s/%s',$Uploads,$File);
	#-------------------------------------------------------------------------------
	// если более суток файл лежит - удаляем
	if(Time() - FileMTime($Path) > 24 * 60 * 60){
	#-------------------------------------------------------------------------------
	if(IsSet($Names[$File]))
		UnSet($Names[$File]);
	#-------------------------------------------------------------------------------
	if(File_Exists($Path))
		if(!UnLink($Path))
			return ERROR | @Trigger_Error(SPrintF('Не удалось удалить файл (%s)',$Path));
	#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
// перебираем хэши, если файла нет, то удаляем его из массива
foreach(Array_Keys($Names) as $Key)
	if(!File_Exists(SPrintF('%s/%s',$Uploads,$Key)))
		UnSet($Names[$Key]);
#-------------------------------------------------------------------------------
$IsWrite = IO_Write($NamesPath,JSON_Encode($Names),TRUE);
if(Is_Error($IsWrite))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return($Hash);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
