<?php


#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
$Socket = Socket_Create(AF_INET,SOCK_STREAM,SOL_TCP);
if(!$Socket)
  return ERROR | @Trigger_Error('[Debugger]: не создать сокет');
#-------------------------------------------------------------------------------
if(!Socket_Bind($Socket,'127.0.0.1',9000))
  return ERROR | @Trigger_Error('[Debugger]: не удалось построить сокет');
#-------------------------------------------------------------------------------
if(!Socket_Listen($Socket))
  return ERROR | @Trigger_Error('[Debugger]: не удалось установить сокет на прослушивание');
#-------------------------------------------------------------------------------
class Client{
  # Ссылка на поток
  public $Stream = NULL;
  #-----------------------------------------------------------------------------
  public function Connect(&$Stream){
    #---------------------------------------------------------------------------
    $this->Stream = $Stream;
  }
  #-----------------------------------------------------------------------------
  public function Disconnect(){
    #---------------------------------------------------------------------------
    $this->Stream = NULL;
  }
}
#-------------------------------------------------------------------------------
# Массив клиентов
$Clients = Array();
#-------------------------------------------------------------------------------
for($i=0;$i<20;$i++)
  $Clients[] = new Client();
#-------------------------------------------------------------------------------
Debug('Отладчик начал работу');
#-------------------------------------------------------------------------------
while(TRUE){
  #-----------------------------------------------------------------------------
  USleep(200);
  #-----------------------------------------------------------------------------
  $Read = Array($Socket);
  #-----------------------------------------------------------------------------
  for($ClientID=0;$ClientID<Count($Clients);$ClientID++){
    #---------------------------------------------------------------------------
    $Stream = &$Clients[$ClientID]->Stream;
    #---------------------------------------------------------------------------
    if(Is_Resource($Stream))
      $Read[] = $Stream;
  }
  #-----------------------------------------------------------------------------
  $IsChange = Socket_Select($Read,$Write,$Except,5);
  #-----------------------------------------------------------------------------
  if($IsChange){
    #---------------------------------------------------------------------------
    if(In_Array($Socket,$Read)){
      #-------------------------------------------------------------------------
      for($ClientID=0;$ClientID<Count($Clients);$ClientID++){
        #-----------------------------------------------------------------------
        $Client = &$Clients[$ClientID];
        #-----------------------------------------------------------------------
        if(!Is_Resource($Client->Stream)){
          #---------------------------------------------------------------------
          $Link = Socket_Accept($Socket);
          #---------------------------------------------------------------------
          $Client = new Client();
          #---------------------------------------------------------------------
          $Clients[$ClientID]->Connect($Link);
          #---------------------------------------------------------------------
          Debug('[Debugger]: соединение принято');
          #---------------------------------------------------------------------
          break;
        }else{
          #---------------------------------------------------------------------
          if($ClientID == Count($Clients) - 1)
            Debug('[Debugger]: слишком много подключений');
        }
      }
    }
    #---------------------------------------------------------------------------
    for($ClientID=0;$ClientID<Count($Clients);$ClientID++){
      #-------------------------------------------------------------------------
      $Client = &$Clients[$ClientID];
      #-------------------------------------------------------------------------
      if(!Is_Resource($Client->Stream))
        continue;
      #-------------------------------------------------------------------------
      if(In_Array($Client->Stream,$Read)){
        #-----------------------------------------------------------------------
        $Input = @Socket_Read($Client->Stream,64);
        #-----------------------------------------------------------------------
        if(!$Input){
          #---------------------------------------------------------------------
          $Client->Disconnect();
          #---------------------------------------------------------------------
          Debug('[Debugger]: соединение закрыто');
        }else
          echo $Input;
      }
    }
  }
}
#-------------------------------------------------------------------------------

?>
