<?php
#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
class Tag{
	#-------------------------------------------------------------------------------
	# Название
	public $Name = '';
	# Атрибуты
	public $Attribs = Array();
	# Дети
	public $Childs = Array();
	# Текстовое содержимое
	public $Text = '';
	#-------------------------------------------------------------------------------
	function __construct($Name = ''){
		/******************************************************************************/
		$__args_types = Array('string','integer,double,string,array,object');
		#-------------------------------------------------------------------------------
		$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
		/******************************************************************************/
		$this->Name = $Name;
		#-------------------------------------------------------------------------------
		if($Name == 'FORM'){
			#-------------------------------------------------------------------------------
			#Debug(SPrintF('[system/classes/auto/Tag]: before __args__ = %s',print_r($__args__,true)));
			$Comp = Comp_Load('Form/Input',Array('name'=>'CSRF','style'=>'display:none;','type'=>'hidden','value'=>$GLOBALS['CSRF']));
			if(Is_Error($Comp))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			if(IsSet($__args__[2])){
				#-------------------------------------------------------------------------------
				$__args__[2]->AddChild($Comp);
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$__args__[2] = $Comp;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#Debug(SPrintF('[system/classes/auto/Tag]: after __args__ = %s',print_r($__args__,true)));
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		if(Count($__args__) > 1){
			#-------------------------------------------------------------------------------
			Array_Shift($__args__);
			#-------------------------------------------------------------------------------
			foreach($__args__ as $__arg__){
				#-------------------------------------------------------------------------------
				$TypeID = GetType($__arg__);
				#-------------------------------------------------------------------------------
				if(In_Array($TypeID,Array('integer','double','float','string'))){
					#-------------------------------------------------------------------------------
					$__arg__ = (string)$__arg__;
					#-------------------------------------------------------------------------------
					if(!Mb_StrLen($__arg__))
						continue;
					#-------------------------------------------------------------------------------
					$Function = 'AddText';
					#-------------------------------------------------------------------------------
				}else{
					#-------------------------------------------------------------------------------
					switch($TypeID){
					case 'object':
						#-------------------------------------------------------------------------------
						$Function = 'AddChild';
						#-------------------------------------------------------------------------------
						break;
						#-------------------------------------------------------------------------------
					case 'array':
						#-------------------------------------------------------------------------------
						$Function = 'AddAttribs';
						#-------------------------------------------------------------------------------
						break;
					default:
						continue 2;
					}
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
				$this->$Function($__arg__);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
function AddAttribs($Attribs,$IsRewrite = FALSE){
  /****************************************************************************/
  $__args_types = Array('array','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  foreach(Array_Keys($Attribs) as $AttribID){
    #---------------------------------------------------------------------------
    $Attrib = (string)$Attribs[$AttribID];
    #---------------------------------------------------------------------------
    if($IsRewrite || !IsSet($this->Attribs[$AttribID]))
      $this->Attribs[$AttribID] = $Attrib;
    else
      $this->Attribs[$AttribID] .= $Attrib;
  }
}
#-------------------------------------------------------------------------------
function &AddChild($Child,$IsAfter = FALSE){
  /****************************************************************************/
  $__args_types = Array('object','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $Function = ($IsAfter?'Array_Unshift':'Array_Push');
  #-----------------------------------------------------------------------------
  $Function($this->Childs,$Child);
  #-----------------------------------------------------------------------------
  return $this->Childs[$IsAfter?0:Count($this->Childs)-1];
}
#-------------------------------------------------------------------------------
function AddHTML($Html,$IsAfter = FALSE){
  /****************************************************************************/
  $__args_types = Array('string','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $Object = String_XML_Parse($Html);
  if(Is_Exception($Object))
    return ERROR | Trigger_Error('[Tag->AddHTML]: не удалось преобразовать объект');
  #-----------------------------------------------------------------------------
  $Childs = ($IsAfter?Array_Reverse($Object->Childs):$Object->Childs);
  #-----------------------------------------------------------------------------
  $Result = Array();
  #-----------------------------------------------------------------------------
  foreach($Childs as $Child)
    $Result[] = &$this->AddChild($Child,$IsAfter);
  #-----------------------------------------------------------------------------
  return $Result;
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function AddText($Text,$IsRewrite = FALSE){
	/******************************************************************************/
	$__args_types = Array('string,integer,double','boolean');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$this->Text = ($IsRewrite?$Text:$this->Text.$Text);
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function NamesToUpper(){
	#-------------------------------------------------------------------------------
	$this->Name = StrToUpper($this->Name);
	#-------------------------------------------------------------------------------
	$Childs = $this->Childs;
	#-------------------------------------------------------------------------------
	for($i=0;$i<Count($Childs);$i++)
		$Childs[$i]->NamesToUpper();
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function ToArray(){
	/******************************************************************************/
	$__args_types = Array('string,array');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$Names = Array_Merge($__args__,Array('ListElement'));
	#-------------------------------------------------------------------------------
	$AttribsIDs = Array();
	#-------------------------------------------------------------------------------
	foreach($__args__ as $__arg__){
		#-------------------------------------------------------------------------------
		if(Is_Array($__arg__))
			$AttribsIDs = Array_Merge($AttribsIDs,$__arg__);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	$Childs = $this->Childs;
	#-------------------------------------------------------------------------------
	if(Count($Childs) > 0){
		#-------------------------------------------------------------------------------
		$j = 1;
		#-------------------------------------------------------------------------------
		$Result = Array();
		#-------------------------------------------------------------------------------
		foreach($Childs as $Child){
			#-------------------------------------------------------------------------------
			$Name = $Child->Name;
			#-------------------------------------------------------------------------------
			if(In_Array($Name,$Names))
				$Name = SPrintF('%s%06u',$Name,$j++);
			#-------------------------------------------------------------------------------
			$Name = ($Name != 'UniqID'?$Name:UniqID('UniqID'));
			#-------------------------------------------------------------------------------
			$Result[$Name] = Call_User_Func_Array(Array($Child,'ToArray'),$__args__);
			#-------------------------------------------------------------------------------
			foreach(Array_Keys($Child->Attribs) as $AttribID){
				#-------------------------------------------------------------------------------
				if(In_Array($AttribID,$AttribsIDs)){
					#-------------------------------------------------------------------------------
					if(!Is_Array($Result[$Name]))
						$Result[$Name] = Array();
					#-------------------------------------------------------------------------------
					$Result[$Name][$AttribID] = $Child->Attribs[$AttribID];
					#-------------------------------------------------------------------------------
				}
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$Result = ($this->Text != ''?$this->Text:NULL);
		#-------------------------------------------------------------------------------
		$Type = 'string';
		#-------------------------------------------------------------------------------
		if(IsSet($this->Attribs['type']))
			$Type = $this->Attribs['type'];
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[system/classes/auto/Tag]: Type = %s',$Type));
		#-------------------------------------------------------------------------------
		// c php 8 падает если тип несуществующий. ISPsystem/ISPmanager таким балуются
		// у них есть тип "ok" например...
		if(!In_Array($Type,Array('boolean','bool','integer','int','float','double','string','array','object','null')))
			$Type = 'string';
		#-------------------------------------------------------------------------------
		@SetType($Result,$Type);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Result;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function ToXMLString($Level = 0,$IsFormat = TRUE){
  /****************************************************************************/
  $__args_types = Array('integer','boolean');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  $Name = $this->Name;
  #-----------------------------------------------------------------------------
  $Result = SPrintF('<%s',$Name);
  #-----------------------------------------------------------------------------
  if($IsFormat)
    $Result = SPrintF('%s%s',$Level?Str_Pad(' ',$Level):'',$Result);
  #-----------------------------------------------------------------------------
  $Attribs = $this->Attribs;
  #-----------------------------------------------------------------------------
  foreach(Array_Keys($Attribs) as $AttribID)
    $Result .= SPrintF(' %s="%s"',$AttribID,HtmlSpecialChars((string)$Attribs[$AttribID],ENT_COMPAT));
  #-----------------------------------------------------------------------------
  $Childs = $this->Childs;
  #-----------------------------------------------------------------------------
  if(Count($Childs)){
    #---------------------------------------------------------------------------
    $Result .= '>';
    #---------------------------------------------------------------------------
    $IsNoCData = TRUE;
    #---------------------------------------------------------------------------
    foreach($Childs as $Child){
      #-------------------------------------------------------------------------
      if(In_Array($Child->Name,Array('CDATA'))){
        #-----------------------------------------------------------------------
        $IsNoCData = FALSE;
        #-----------------------------------------------------------------------
        break;
      }
    }
    #---------------------------------------------------------------------------
    $Nodes = '';
    #---------------------------------------------------------------------------
    foreach($Childs as $Child)
      $Nodes .= (In_Array($Child->Name,Array('CDATA'))?HtmlSpecialChars($Child->Text,ENT_COMPAT):$Child->ToXMLString($Level + 1,$IsNoCData));
    #---------------------------------------------------------------------------
    $Result .= ($IsNoCData?SPrintF("\n%s%s",$Nodes,$Level?Str_Pad(' ',$Level):''):$Nodes);
  }else{
    #---------------------------------------------------------------------------
    $Text = (IsSet($Attribs['force-escape'])?$this->Text:HtmlSpecialChars($this->Text,ENT_COMPAT));
    #---------------------------------------------------------------------------
    $IsShort = ((!Mb_StrLen($Text)) && !In_Array($Name,Array('TEXTAREA','BUTTON','TITLE','SCRIPT','TABLE','TD','TR')));
    #---------------------------------------------------------------------------
    if($IsShort){
      #-------------------------------------------------------------------------
      $Result .= ' />';
      #-------------------------------------------------------------------------
      if($IsFormat)
        $Result .= "\n";
      #-------------------------------------------------------------------------
      return $Result;
    }else
      $Result .= SPrintF('>%s',$Text);
  }
  #-----------------------------------------------------------------------------
  $Result .= SPrintF('</%s>',$Name);
  #-----------------------------------------------------------------------------
  if($IsFormat)
    $Result .= "\n";
  #-----------------------------------------------------------------------------
  return $Result;
}
#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
?>
