<?php
#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
function Image_Resize($Source,$Width,$Height){
  /****************************************************************************/
  $__args_types = Array('string','integer');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  if(!Function_Exists('ImageCreateFromString'))
    return ERROR | Trigger_Error('[Image_Resize]: модуль работы с изображениями не установлен');
  #-----------------------------------------------------------------------------
  $Real = @ImageCreateFromString($Source);
  if(!Is_Resource($Real))
    return ERROR | @Trigger_Error("[Image_Resize]: не возможно создать изображение");
  #-----------------------------------------------------------------------------
  if(Function_Exists('imageantialias'))
    ImageAntiAlias($Real,TRUE);
  #-----------------------------------------------------------------------------
  $Result = ImageCreateTrueColor($Width,$Height);
  if(!$Result)
    return ERROR | @Trigger_Error('[Image_Resize]: не удалось создать пустое изображение');
  #-----------------------------------------------------------------------------
  $White = ImageColorAllocate($Result,230,230,230);
  #-----------------------------------------------------------------------------
  if(!ImageFill($Result,0,0,$White))
    return ERROR | @Trigger_Error('[Image_Resize]: не удалось закрасить изображение');
  #-----------------------------------------------------------------------------
  $Sx = @ImageSx($Real);
  if(!$Sx)
    return ERROR | @Trigger_Error("[Image_Resize]: не возможно получить ширину изображения");
  #-----------------------------------------------------------------------------
  $Sy = @ImageSy($Real);
  if(!$Sy)
    return ERROR | @Trigger_Error("[Image_Resize]: не возможно получить высоту изображения");
  #-----------------------------------------------------------------------------
  $Folder = System_Element('tmp');
  if(Is_Error($Folder))
    return ERROR | @Trigger_Error('[Image_Resize]: не удалось найти временную папку');
  #-----------------------------------------------------------------------------
  if($Width < $Sx || $Height < $Sy){
    #---------------------------------------------------------------------------
    $HW = $Sy / $Sx;
    $WH = $Sx / $Sy;
    #---------------------------------------------------------------------------
    $WNew = $Width;
    $HNew = $Height;
    #---------------------------------------------------------------------------
    if($Sx < $Sy)
      $HNew = (int)($WNew*$HW);
    else
      $WNew = (int)($HNew*$WH);
    #---------------------------------------------------------------------------
    if(!Preg_Match('/no\sconvert/',Exec('which convert'))){
      #-------------------------------------------------------------------------
      $File = SPrintF('%s/%s',$Folder,UniqID('Image'));
      #-------------------------------------------------------------------------
      if(!ImageJpeg($Real,$File,100))
        return ERROR | @Trigger_Error('[Image_Resize]: не удалось сохранить временное изображение');
      #-------------------------------------------------------------------------
      $Command = SPrintF('convert %s -thumbnail %ux%u^ -gravity North -extent %ux%u %s',$File,$Width,$Height,$Width,$Height,$File);
      #-------------------------------------------------------------------------
      Debug($Command);
      #-------------------------------------------------------------------------
      if(Exec($Command,$Log))
        return ERROR | @Trigger_Error(SPrintF("[Image_Resize]: ошибка выполнения команды:\n%s",Implode("\n",$Log)));
      #-------------------------------------------------------------------------
      $Result = IO_Read($File);
      if(Is_Error($Result))
        return ERROR | @Trigger_Error('[Image_Resize]: не удалось прочитать изображение');
      #-------------------------------------------------------------------------
      if(!UnLink($File))
        return ERROR | @Trigger_Error('[Image_Resize]: не удалось удалить временный файл');
      #-------------------------------------------------------------------------
      return $Result;
    }else{
      #-------------------------------------------------------------------------
      if(!ImageCopyResized($Result,$Real,0,0,0,0,$WNew,$HNew,$Sx,$Sy))
        return ERROR | @Trigger_Error('[Image_Resize]: не удалось уменьшить изображение');
    }
  }else{
    #---------------------------------------------------------------------------
    if(!ImageCopy($Result,$Real,($Width-$Sx)/2,($Height-$Sy)/2,0,0,$Sx,$Sy))
      return ERROR | @Trigger_Error('[Image_Resize]: не удалось уменьшить изображение');
  }
  #-----------------------------------------------------------------------------
  $File = SPrintF('%s/%s',$Folder,UniqID('Image'));
  #-----------------------------------------------------------------------------
  if(!ImageJpeg($Result,$File,95))
    return ERROR | @Trigger_Error('[Image_Resize]: не удалось сохранить временное изображение');
  #-----------------------------------------------------------------------------
  if(!ImageDestroy($Result))
    return ERROR | @Trigger_Error('[Image_Resize]: не удалось освободить ресурс изображения');
  #-----------------------------------------------------------------------------
  $Result = IO_Read($File);
  if(Is_Error($Result))
    return ERROR | @Trigger_Error('[Image_Resize]: не удалось прочитать изображение');
  #-----------------------------------------------------------------------------
  if(!UnLink($File))
    return ERROR | @Trigger_Error('[Image_Resize]: не удалось удалить временный файл');
  #-----------------------------------------------------------------------------
  return $Result;
}
#-------------------------------------------------------------------------------
function Image_Get_Size($Source){
  /****************************************************************************/
  $__args_types = Array('string');
  #-----------------------------------------------------------------------------
  $__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
  /****************************************************************************/
  if(!Function_Exists('ImageCreateFromString'))
    return ERROR | Trigger_Error('[Image_Get_Size]: модуль работы с изображениями не установлен');
  #-----------------------------------------------------------------------------
  $Real = @ImageCreateFromString($Source);
  if(!Is_Resource($Real))
    return ERROR | @Trigger_Error("[Image_Get_Size]: не возможно создать изображение");
  #-----------------------------------------------------------------------------
  $Sx = @ImageSx($Real);
  if(!$Sx)
    return ERROR | @Trigger_Error("[Image_Get_Size]: не возможно получить ширину изображения");
  #-----------------------------------------------------------------------------
  $Sy = @ImageSy($Real);
  if(!$Sy)
    return ERROR | @Trigger_Error("[Image_Get_Size]: не возможно получить высоту изображения");
  #-----------------------------------------------------------------------------
  return Array('Width'=>$Sx,'Height'=>$Sy);
}
#-------------------------------------------------------------------------------
?>