<?php
#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
#-------------------------------------------------------------------------------
if(!Extension_Loaded('openssl'))
	$GLOBALS['__MESSAGES'][] = 'Модуль openssl не установлен. Функции шифрования могут работать не правильно. Пожалуйста, исправьте ошибку.';
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Crypt_Encode($String, $Key = HOST_ID){
	/******************************************************************************/
	$__args_types = Array('string','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	//Debug(SPrintF('[system/libs/auto/Crypt]: String = %s; Key = %s',$String,$Key));
	if(Empty($String))
		return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(Extension_Loaded('openssl')){
		#-------------------------------------------------------------------------------
		$Cipher = 'AES-128-CBC';
		#-------------------------------------------------------------------------------
		$IVLen = OpenSSL_Cipher_IV_Length($Cipher);
		#-------------------------------------------------------------------------------
		$IV = OpenSSL_Random_Pseudo_Bytes($IVLen);
		#-------------------------------------------------------------------------------
		if(!$StringRaw = @OpenSSL_Encrypt($String,$Cipher,$Key,$Options = OPENSSL_RAW_DATA,$IV))
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось дешифровать данные');
		#-------------------------------------------------------------------------------
		$HMAC = Hash_HMAC('sha256',$StringRaw,$Key,$As_Binary = true);
		#-------------------------------------------------------------------------------
		$String = Base64_Encode(SPrintF('%s%s%s',$IV,$HMAC,$StringRaw));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Crypt_Decode($String, $Key = HOST_ID){
	/******************************************************************************/
	$__args_types = Array('string','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	//Debug(SPrintF('[system/libs/auto/Crypt]: String = %s; Key = %s',$String,$Key));
	$String = Base64_Decode($String);
	#-------------------------------------------------------------------------------
	if(Empty($String))
		return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(Extension_Loaded('openssl')){
		#-------------------------------------------------------------------------------
		$Cipher = 'AES-128-CBC';
		#-------------------------------------------------------------------------------
		$IVLen = OpenSSL_Cipher_IV_Length($Cipher);
		#-------------------------------------------------------------------------------
		$IV = SubStr($String,0,$IVLen);
		#-------------------------------------------------------------------------------
		$HMAC = SubStr($String,$IVLen,$SHA2Len = 32);
		#-------------------------------------------------------------------------------
		$StringRaw = SubStr($String,$IVLen+$SHA2Len);
		#-------------------------------------------------------------------------------
		if(!$String = @OpenSSL_Decrypt($StringRaw,$Cipher,$Key,$Options = OPENSSL_RAW_DATA,$IV))
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось дешифровать данные');
		#-------------------------------------------------------------------------------
		$String = Trim($String);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
