<?php
#-------------------------------------------------------------------------------
/** @author Великодный В.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

function Is_Error($Value){
	#-------------------------------------------------------------------------------
	return $Value === ERROR;
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function ValueOf($Value){
	#-------------------------------------------------------------------------------
	$Type = GetType($Value);
	#-------------------------------------------------------------------------------
	switch($Type){
	case 'integer':
		#-------------------------------------------------------------------------------
		if(Is_Error($Value))
			$Type = 'error';
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'boolean':
		#-------------------------------------------------------------------------------
		$Type = ($Value?'true':'false');
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	case 'object':
		#-------------------------------------------------------------------------------
		if(Get_Class($Value) == 'gException' || Get_Class($Value) == 'jException')
			return 'exception';
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	return $Type;
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
/**
 *
 * @param Object $Value
 * @return boolean Возвращает true, если $Value является исключением и false в противном случае
 */
function Is_Exception($Value){
	#-------------------------------------------------------------------------------
	return Is_Object($Value) && (Get_Class($Value) == 'gException');
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function GetTime($Data){
	#-------------------------------------------------------------------------------
	if(Preg_Match('/^[0-9]+$/',$Data))
		return $Data;
	#-------------------------------------------------------------------------------
	$Date = @Date_Parse($Data);
	#-------------------------------------------------------------------------------
	if(!Is_Array($Date))
		return ERROR | @Trigger_Error('[GetTime]: ошибка получения даты');
	#-------------------------------------------------------------------------------
	return MkTime($Date['hour'],$Date['minute'],$Date['second'],$Date['month'],$Date['day'],$Date['year']);
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function To_XML_String($Value,$Name = 'XML',$Level = 0){
	/******************************************************************************/
	$__args_types = Array('array,string,integer,double,boolean,NULL','string,integer','integer');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$Result = SPrintF('%s<%s',($Tab = $Level?Str_Pad("\t",$Level,"\t"):''),$Name);
	#-------------------------------------------------------------------------------
	if(Is_Array($Value)){
		#-------------------------------------------------------------------------------
		if(Count($Value) > 0){
			#-------------------------------------------------------------------------------
			$Result = SPrintF("%s>\n",$Result);
			#-------------------------------------------------------------------------------
			foreach(Array_Keys($Value) as $Key)
				$Result = SPrintF('%s%s',$Result,To_XML_String($Value[$Key],$Key,$Level + 1));
			#-------------------------------------------------------------------------------
			$Result = SPrintF('%s%s',$Result,$Tab);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			return SPrintF("%s type=\"array\" />\n",$Result);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}else{
		#-------------------------------------------------------------------------------
		$Type = GetType($Value);
		#-------------------------------------------------------------------------------
		if($Type != 'string')
			$Result = SPrintF('%s type="%s"',$Result,$Type);
		#-------------------------------------------------------------------------------
		if(StrLen($Value) > 0){
			#-------------------------------------------------------------------------------
			$Value = HtmlSpecialChars((string)$Value,ENT_COMPAT);
			#-------------------------------------------------------------------------------
			$Result = SPrintF('%s>%s',$Result,$Value);
			#-------------------------------------------------------------------------------
		}else{
			#-------------------------------------------------------------------------------
			return SPrintF("%s />\n",$Result);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	return SPrintF("%s</%s>\n",$Result,$Name);
	#-------------------------------------------------------------------------------
}

//****************************************************************************//

?>
