<?php
#-------------------------------------------------------------------------------
/** @author Бреславский А.В. (Joonte Ltd.) */
#-------------------------------------------------------------------------------
function Translit($String) {
	#-------------------------------------------------------------------------------
	$Template = Array('Москва'=>'Moscow','ОАО'=>'PC','ЗАО'=>'c.c.','ООО'=>'Ltd.','Ґ'=>'G','Ё'=>'Yo','Є'=>'E','Ї'=>'Yi','І'=>'I','і'=>'i','ґ'=>'g','ё'=>'yo','№'=>'#','є'=>'e','ї'=>'yi','А'=>'A','Б'=>'B','В'=>'V','Г'=>'G','Д'=>'D','Е'=>'E','Ж'=>'Zh','З'=>'Z','И'=>'I','Й'=>'Y','К'=>'K','Л'=>'L','М'=>'M','Н'=>'N','О'=>'O','П'=>'P','Р'=>'R','С'=>'S','Т'=>'T','У'=>'U','Ф'=>'F','Х'=>'H','Ц'=>'TS','Ч'=>'CH','Ш'=>'SH','Щ'=>'Sch','Ъ'=>'','Ы'=>'Yi','Ь'=>'','Э'=>'E','Ю'=>'Yu','Я'=>'Ya','а'=>'a','б'=>'b','в'=>'v','г'=>'g','д'=>'d','е'=>'e','ж'=>'zh','з'=>'z','и'=>'i','й'=>'y','к'=>'k','л'=>'l','м'=>'m','н'=>'n','о'=>'o','п'=>'p','р'=>'r','с'=>'s','т'=>'t','у'=>'u','ф'=>'f','х'=>'kh','ц'=>'ts','ч'=>'ch','ш'=>'sh','щ'=>'sch','ъ'=>'','ы'=>'yi','ь'=>'','э'=>'e','ю'=>'yu','я'=>'ya');
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return StrTr($String,$Template);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function String_Xml_Parse($String,$IsUseCache = TRUE){
	#-------------------------------------------------------------------------------
	# костыль для удаления не-UTF8 символов
	$String = @Iconv('UTF-8','UTF-8//IGNORE',$String);
	#-------------------------------------------------------------------------------
	$Length = Mb_StrLen($String);
	#-------------------------------------------------------------------------------
	$IsUseCache = ($IsUseCache && $Length > 1024);
	#-------------------------------------------------------------------------------
	if($IsUseCache){
		#-------------------------------------------------------------------------------
		$CacheID = SPrintF('String_XML_Parse[%s]',Md5(Crc32($String)));
		#-------------------------------------------------------------------------------
		$Result = CacheManager::get($CacheID);
		if($Result)
			return $Result;
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	Debug(SPrintF('[String_XML_Parse]: парсирование строки (%u bytes)',$Length));
	#-------------------------------------------------------------------------------
	$XmlParser = Xml_Parser_Create('UTF-8');
	#-------------------------------------------------------------------------------
	if(!Xml_Parser_Set_Option($XmlParser,XML_OPTION_CASE_FOLDING,FALSE))
		return ERROR | Trigger_Error('[String_Xml_Parse]: не удалось установить опцию парсирования (XML_OPTION_CASE_FOLDING)');
	#-------------------------------------------------------------------------------
	if(!Xml_Parser_Set_Option($XmlParser,XML_OPTION_SKIP_WHITE,FALSE))
		return ERROR | Trigger_Error('[String_Xml_Parse]: не удалось установить опцию парсирования (XML_OPTION_SKIP_WHITE)');
	#-------------------------------------------------------------------------------
	if(!Xml_Parse_Into_Struct($XmlParser,$String,$Nodes)){
		#-------------------------------------------------------------------------------
		$ByteIndex = Xml_Get_Current_Byte_Index($XmlParser);
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/auto/String.php]: xml_error_string = %s',Xml_Error_String(Xml_Get_Error_Code($XmlParser))));
		#-------------------------------------------------------------------------------
		Debug(SPrintF('[system/libs/auto/String.php]: %s',Mb_SubStr($String,$ByteIndex-100,$ByteIndex+100)));
		#-------------------------------------------------------------------------------
		$Buffer = Mb_SubStr($String,0,$ByteIndex);
		#-------------------------------------------------------------------------------
		$Line = Preg_Match_All("/(\r\n|\n)/sU",$Buffer,$Matches) + 1;
		#-------------------------------------------------------------------------------
		return new gException('XML_PARSE_ERROR',SPrintF('%s в линии %u',Xml_Error_String($XmlParser),$Line));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	Xml_Parser_Free($XmlParser);
	#-------------------------------------------------------------------------------
	$Root = new Tag('__ROOT__');
	#-------------------------------------------------------------------------------
	$Links = Array(&$Root);
	#-------------------------------------------------------------------------------
	foreach($Nodes as $Node){
		#-------------------------------------------------------------------------------
		$Current = $Links[Count($Links)-1];
		#-------------------------------------------------------------------------------
		switch($Node['type']){
		case 'open':
			#-------------------------------------------------------------------------------
			$Tag = new Tag($Node['tag']);
			#-------------------------------------------------------------------------------
			if(IsSet($Node['attributes']))
				$Tag->AddAttribs($Node['attributes']);
			#-------------------------------------------------------------------------------
			if(IsSet($Node['value'])){
				#-------------------------------------------------------------------------------
				$Value = $Node['value'];
				#-------------------------------------------------------------------------------
				if(Trim($Value))
					$Tag->AddChild(new Tag('CDATA',$Value));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			$Current->Childs[] = $Tag;
			#-------------------------------------------------------------------------------
			$Links[] = &$Current->Childs[Count($Current->Childs)-1];
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'cdata':
			#-------------------------------------------------------------------------------
			$Value = $Node['value'];
			#-------------------------------------------------------------------------------
			if(Trim($Value)){
				#-------------------------------------------------------------------------------
				$Tag = new Tag('CDATA',$Value);
				#-------------------------------------------------------------------------------
				$Current->Childs[] = $Tag;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'complete':
			#-------------------------------------------------------------------------------
			$Tag = new Tag($Node['tag']);
			#-------------------------------------------------------------------------------
			if(IsSet($Node['attributes']))
				$Tag->AddAttribs($Node['attributes']);
			#-------------------------------------------------------------------------------
			if(IsSet($Node['value']))
				$Tag->AddText($Node['value']);
			#-------------------------------------------------------------------------------
			$Current->Childs[] = $Tag;
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'close':
			#-------------------------------------------------------------------------------
			Array_Pop($Links);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			# No more...
		}
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	if($IsUseCache)
		CacheManager::add($CacheID,$Root);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $Root;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
