<?php
#-------------------------------------------------------------------------------
$ServicesFields = DB_Select('ServicesFields',Array('ID','TypeID','Options'),Array('Where'=>"`TypeID` = 'Select'"));
#-------------------------------------------------------------------------------
switch(ValueOf($ServicesFields)){
  case 'error':
    return ERROR | @Trigger_Error(500);
  case 'exception':
    # No more...
  break;
  case 'array':
    #---------------------------------------------------------------------------
    foreach($ServicesFields as $ServiceField){
      #-------------------------------------------------------------------------
      $Options = Explode("\n",$ServiceField['Options']);
      #-------------------------------------------------------------------------
      if(Count($Options)){
        #-----------------------------------------------------------------------
        $Array = Array();
        #-----------------------------------------------------------------------
        foreach($Options as $Option){
          #---------------------------------------------------------------------
          $Option = Explode("=",$Option);
          #---------------------------------------------------------------------
          if(Count($Option) < 3)
            $Option[] = 0;
          #--------------------------------------------------------------------
          Reset($Option);
          #---------------------------------------------------------------------
          $Array[] = SPrintF('%s=%s=%01.2f',Trim(Current($Option)),Trim(Next($Option)),Trim(Next($Option)));
        }
        #-----------------------------------------------------------------------
        $Options = Implode("\n",$Array);
        #-----------------------------------------------------------------------
        $IsUpdate = DB_Update('ServicesFields',Array('Options'=>$Options),Array('ID'=>$ServiceField['ID']));
        if(Is_Error($IsUpdate))
          return ERROR | @Trigger_Error(500);
      }
    }
  break;
  default:
    return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
?>