<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$ConfigPath = SPrintF('%s/hosts/%s/config/Config.xml',SYSTEM_PATH,HOST_ID);
#-------------------------------------------------------------------------------
if(File_Exists($ConfigPath)){
	#-------------------------------------------------------------------------------
	$File = IO_Read($ConfigPath);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($File);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Config = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Config = $Config['XML'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Config = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['Invoices']['PaymentSystems']['Yandex'])){
	#-------------------------------------------------------------------------------
	$Yandex = $Config['Invoices']['PaymentSystems']['Yandex'];
	#-------------------------------------------------------------------------------
	# номер магазина в другой переменной
	if(IsSet($Yandex['Send']['wbp_ShopKeyID'])){
		#-------------------------------------------------------------------------------
		$Yandex['Send']['ShopId'] = $Yandex['Send']['wbp_ShopKeyID'];
		#-------------------------------------------------------------------------------
		UnSet($Yandex['Send']['wbp_ShopKeyID']);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# адрес интерфейса задаётся включением/выключением деморежима
	if(IsSet($Yandex['Cpp']))
		Unset($Yandex['Cpp']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	# выключаем тестовый режим
	$Yandex['TestMode'] = 0;
	#-------------------------------------------------------------------------------
	# возвращаем массив взад
	$Config['Invoices']['PaymentSystems']['Yandex'] = $Yandex;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$File = IO_Write($ConfigPath,To_XML_String($Config),TRUE);
if(Is_Error($File))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$IsFlush = CacheManager::flush();
if(!$IsFlush)
	@Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
