<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$ConfigPath = SPrintF('%s/hosts/%s/config/Config.xml',SYSTEM_PATH,HOST_ID);
#-------------------------------------------------------------------------------
if(File_Exists($ConfigPath)){
	#-------------------------------------------------------------------------------
	$File = IO_Read($ConfigPath);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$XML = String_XML_Parse($File);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$Config = $XML->ToArray();
	#-------------------------------------------------------------------------------
	$Config = $Config['XML'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Config = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($Config['IspSoft'])){
	#-------------------------------------------------------------------------------
	$IspSoft = $Config['IspSoft'];
	Debug(SPrintF('[patches/hosting/files/1000015.php]: IspSoft = %s',print_r($IspSoft,true)));
	#-------------------------------------------------------------------------------
	UnSet($Config['IspSoft']);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(IsSet($IspSoft['Settings']['Password'])){
		#-------------------------------------------------------------------------------
		$ServersGroups = DB_Select('ServersGroups','ID',Array('Where'=>'`ServiceID` = 51000'));
		#-------------------------------------------------------------------------------
		switch(ValueOf($ServersGroups)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			return ERROR | @Trigger_Error(400);
		case 'array':
			#-------------------------------------------------------------------------------
			foreach($ServersGroups as $ServersGroup){
				#-------------------------------------------------------------------------------
				$IsDelete = DB_Delete('Servers',Array('Where'=>SPrintF('`ServersGroupID` = %u',$ServersGroup['ID'])));
				if(Is_Error($IsDelete))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				$IsDelete = DB_Delete('ServersGroups',Array('ID'=>$ServersGroup['ID']));
				if(Is_Error($IsDelete))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$ServersGroup = Array('Name'=>(IsSet($IspSoft['Settings']['VisibleName'])?$IspSoft['Settings']['VisibleName']:'ЗАО "ИСПсистем"'),'ServiceID'=>51000,'FunctionID'=>'NotDefined','Comment'=>'ПО ИСПсистем','SortID'=>51000);
		#-------------------------------------------------------------------------------
		$ServersGroupID = DB_Insert('ServersGroups',$ServersGroup);
		if(Is_Error($ServersGroupID))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		$Server = Array('TemplateID'=>'ISPsw','ServersGroupID'=>$ServersGroupID,'IsActive'=>TRUE,'IsDefault'=>TRUE,'Protocol'=>'ssl','Address'=>'my.ispsystem.com','Port'=>443,'Login'=>(IsSet($IspSoft['Settings']['Login'])?$IspSoft['Settings']['Login']:'root'),'Password'=>$IspSoft['Settings']['Password'],'Params'=>Array('BalanceLowLimit'=>(IsSet($IspSoft['Settings']['BalanceLowLimit'])?$IspSoft['Settings']['BalanceLowLimit']:'250'),'PrefixAPI'=>'/manager/billmgr'),'AdminNotice'=>'Используется специально созданная учётная запись','SortID'=>51000,'Monitoring'=>'HTTPS=443');
		#-------------------------------------------------------------------------------
		$IsInsert = DB_Insert('Servers',$Server);
		if(Is_Error($IsInsert))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ServersGroup = DB_Select('ServersGroups','ID',Array('UNIQ','Where'=>'`ServiceID` = 51000'));
#-------------------------------------------------------------------------------
switch(ValueOf($ServersGroup)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	$Server = DB_Select('Servers','ID',Array('UNIQ','Where'=>SPrintF('`ServersGroupID` = %u',$ServersGroup['ID'])));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Server)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$Orders = DB_Select('ISPswOrders','OrderID');
		#-------------------------------------------------------------------------------
		switch(ValueOf($Orders)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			break;
		case 'array':
			#-------------------------------------------------------------------------------
			foreach($Orders as $Order){
				#-------------------------------------------------------------------------------
				$IsUpdate = DB_Update('Orders',Array('ServerID'=>$Server['ID']),Array('ID'=>$Order['OrderID']));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);

				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$File = IO_Write($ConfigPath,To_XML_String($Config),TRUE);
if(Is_Error($File))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$IsFlush = CacheManager::flush();
if(!$IsFlush)
	@Trigger_Error(500);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>
