<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
$Count = DB_Count('Users');
if(Is_Error($Count))
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
if(!$Count)
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
for($i=0;$i<$Count;$i+=100){
	#-------------------------------------------------------------------------------
	$Users = DB_Select('Users',Array('*'),Array('Limits'=>Array('Start'=>$i,'Length'=>100)));
	#-------------------------------------------------------------------------------
	switch(ValueOf($Users)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		$Template = System_XML('xml/Params/Users.xml');
		if(Is_Error($Template))
			return new gException('ERROR_TEMPLATE_LOAD','Ошибка загрузки шаблона');
		#-------------------------------------------------------------------------------
		#-------------------------------------------------------------------------------
		foreach($Users as $User){
			#-------------------------------------------------------------------------------
			$Attribs = @$User['Params']['Settings'];
			#-------------------------------------------------------------------------------
			foreach(Array_Keys($Template['Settings']) as $AttribID)
				if(!IsSet($Attribs[$AttribID]))
					$Attribs[$AttribID] = $Template['Settings'][$AttribID]['Value'];
			#-------------------------------------------------------------------------------
			foreach(Array_Keys($Attribs) as $AttribID)
				if(!IsSet($Template['Settings'][$AttribID]))
					UnSet($Attribs[$AttribID]);
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$NotificationMethods = @$User['Params']['NotificationMethods'];
			#-------------------------------------------------------------------------------
			foreach(Array_Keys($Template['NotificationMethods']) as $Key){
				#-------------------------------------------------------------------------------
				if(!IsSet($NotificationMethods[$Key]))
					$NotificationMethods[$Key] = Array();
				#-------------------------------------------------------------------------------
				foreach(Array_Keys($Template['NotificationMethods'][$Key]) as $Value)
					if(!IsSet($NotificationMethods[$Key][$Value]))
						$NotificationMethods[$Key][$Value] = $Template['NotificationMethods'][$Key][$Value];
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$Params = Array();
			#-------------------------------------------------------------------------------
			$Params['Settings'] = $Attribs;
			#-------------------------------------------------------------------------------
			$Params['NotificationMethods'] = $NotificationMethods;
			#-------------------------------------------------------------------------------
			if(IsSet($User['Params']['IsAutoRegistered']) && $User['Params']['IsAutoRegistered']){
				#-------------------------------------------------------------------------------
				$Params['IsAutoRegistered'] = TRUE;
				#-------------------------------------------------------------------------------
			}else{
				#-------------------------------------------------------------------------------
				$Params['IsAutoRegistered'] = FALSE;
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			# дописываем контакты юзера в Params
			$Params['NotificationMethods']['SMS']['Address'] = $User['Mobile'];
			$Params['NotificationMethods']['SMS']['Confirmed'] = $User['MobileConfirmed'];
			#-------------------------------------------------------------------------------
			$Params['NotificationMethods']['ICQ']['Address'] = $User['ICQ'];
			$Params['NotificationMethods']['Jabber']['Address'] = $User['JabberID'];
			#-------------------------------------------------------------------------------
			#-------------------------------------------------------------------------------
			$IsUpdate = DB_Update('Users',Array('Email'=>StrToLower($User['Email']),'Params'=>$Params),Array('ID'=>$User['ID']));
			if(Is_Error($IsUpdate))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
		#-------------------------------------------------------------------------------
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
# Удаляем колонки
foreach(Array('ICQ','JabberID','Mobile','MobileConfirmed') as $Column){
	#-------------------------------------------------------------------------------
	$IsQuery = DB_Query(SPrintF('ALTER TABLE `Users` DROP `%s`',$Column));
	if(Is_Error($IsQuery))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$Event = Array('UserID'=>100,'PriorityID'=>'Billing','Text'=>SPrintF('Успешно перемещены контакты для %u пользователей',$Count));
$Event = Comp_Load('Events/EventInsert',$Event);
if(!$Event)
	return ERROR | @Trigger_Error(500);
#-------------------------------------------------------------------------------
$GLOBALS['TaskReturnInfo'] = SPrintF('Recovered: %u users',$Count);
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
if(IsSet($GLOBALS['IsCron']))
	return TRUE;
#-------------------------------------------------------------------------------
return $Count;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
