<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/

// достаём события о хостинге
$Events = DB_Select('Events',Array('*','(SELECT `Email` FROM `Users` WHERE `Users`.`ID` = `UserID`) AS `Email`'),Array('Where'=>'`Text` LIKE "Заказ хостинга логин (%), домен (%) %"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Events)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Events as $Event){
		#-------------------------------------------------------------------------------
		Preg_Match_All("/.*\((.*)\)\,.*\((.*)\).*/U",$Event['Text'],$Data);
		#-------------------------------------------------------------------------------
		$OrderID = Preg_Replace("/[^0-9]/",'',$Data[1][0]);
		$Domain  = $Data[2][0];
		#-------------------------------------------------------------------------------
		if(!$OrderID){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NO ORDER ID: %s',$Event['Text']));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$OrdersHistory = DB_Select('OrdersHistory',Array('Parked'),Array('UNIQ','Where'=>Array(SPrintF('`OrderID` = %u',$OrderID))));
		#-------------------------------------------------------------------------------
		switch(ValueOf($OrdersHistory)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			#Debug(SPrintF('[files/1000029]: NOT FOUND HISTORY: %s/%s',$Data[1][0],$Domain));
			#-------------------------------------------------------------------------------
			// готовим массив для вставки в БД
			$Array = Array(
					'StatusDate'	=> $Event['CreateDate'],
					'CreateDate'	=> $Event['CreateDate'],
					'UserID'	=> $Event['UserID'],
					'Email'		=> $Event['Email'],
					'ServiceID'	=> 10000,
					'ServiceName'	=> 'Заказ хостинга',
					'SchemeID'	=> 0,
					'SchemeName'	=> 'Неизвестно',
					'OrderID'	=> $OrderID,
					'Parked'	=> $Domain
					);
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('OrdersHistory',$Array);
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			$Parked = Explode(',',$OrdersHistory['Parked']);
			#-------------------------------------------------------------------------------
			if(!In_Array($Domain,$Parked)){
				#-------------------------------------------------------------------------------
				$Parked[] = $Domain;
				#-------------------------------------------------------------------------------
				$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>Implode(',',$Parked)),Array('Where'=>SPrintF('`OrderID` = %u',$OrderID)));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[files/1000029]: UPDATE hosting: %s; domain: %s',$Data[1][0],$Domain));
			}
			#-------------------------------------------------------------------------------
			// удаляем запись из таблицы событий
			$IsDelete = DB_Delete('Events',Array('ID'=>$Event['ID']));
			if(Is_Error($IsDelete))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// события хостинга, вариант 2
$Events = DB_Select('Events',Array('*','(SELECT `Email` FROM `Users` WHERE `Users`.`ID` = `UserID`) AS `Email`'),Array('Where'=>'`Text` LIKE "Заказ хостинга тариф (%), логин (%), домен (%) %"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Events)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Events as $Event){
		#-------------------------------------------------------------------------------
		Preg_Match_All("/.*\((.*)\)\,.*\((.*)\)\,.*\((.*)\).*/U",$Event['Text'],$Data);
		#-------------------------------------------------------------------------------
		$OrderID= Preg_Replace("/[^0-9]/",'',$Data[2][0]);
		$Domain	= $Data[3][0];
		$Scheme	= $Data[1][0];
		#-------------------------------------------------------------------------------
		if(!$OrderID){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NO ORDER ID: %s',$Event['Text']));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$OrdersHistory = DB_Select('OrdersHistory',Array('Parked'),Array('UNIQ','Where'=>Array(SPrintF('`OrderID` = %u',$OrderID))));
		#-------------------------------------------------------------------------------
		switch(ValueOf($OrdersHistory)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NOT FOUND HISTORY: %s/%s',$Data[1][0],$Domain));
			#-------------------------------------------------------------------------------
			// готовим массив для вставки в БД
			$Array = Array(
					'StatusDate'	=> $Event['CreateDate'],
					'CreateDate'	=> $Event['CreateDate'],
					'UserID'	=> $Event['UserID'],
					'Email'		=> $Event['Email'],
					'ServiceID'	=> 10000,
					'ServiceName'	=> 'Заказ хостинга',
					'SchemeID'	=> 0,
					'SchemeName'	=> $Scheme,
					'OrderID'	=> $OrderID,
					'Parked'	=> $Domain
					);
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('OrdersHistory',$Array);
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			$Parked = Explode(',',$OrdersHistory['Parked']);
			#-------------------------------------------------------------------------------
			if(!In_Array($Domain,$Parked)){
				#-------------------------------------------------------------------------------
				$Parked[] = $Domain;
				#-------------------------------------------------------------------------------
				$IsUpdate = DB_Update('OrdersHistory',Array('SchemeName'=>$Scheme,'Parked'=>Implode(',',$Parked)),Array('Where'=>SPrintF('`OrderID` = %u',$OrderID)));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[files/1000029]: UPDATE hosting: %s; domain: %s',$Data[1][0],$Domain));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// удаляем запись из таблицы событий
			$IsDelete = DB_Delete('Events',Array('ID'=>$Event['ID']));
			if(Is_Error($IsDelete))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// события хостинга, вариант 3
$Events = DB_Select('Events',Array('*','(SELECT `Email` FROM `Users` WHERE `Users`.`ID` = `UserID`) AS `Email`'),Array('Where'=>'`Text` LIKE "Заказ хостинга логин (%), домен (%), тариф (Эконом) %"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Events)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Events as $Event){
		#-------------------------------------------------------------------------------
		Preg_Match_All("/.*\((.*)\)\,.*\((.*)\)\,.*\((.*)\).*/U",$Event['Text'],$Data);
		#-------------------------------------------------------------------------------
		$OrderID= Preg_Replace("/[^0-9]/",'',$Data[1][0]);
		$Domain	= $Data[2][0];
		$Scheme	= $Data[3][0];
		#-------------------------------------------------------------------------------
		if(!$OrderID){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NO ORDER ID: %s',$Event['Text']));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$OrdersHistory = DB_Select('OrdersHistory',Array('Parked'),Array('UNIQ','Where'=>Array(SPrintF('`OrderID` = %u',$OrderID))));
		#-------------------------------------------------------------------------------
		switch(ValueOf($OrdersHistory)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NOT FOUND HISTORY: %s/%s',$Data[1][0],$Domain));
			#-------------------------------------------------------------------------------
			// готовим массив для вставки в БД
			$Array = Array(
					'StatusDate'	=> $Event['CreateDate'],
					'CreateDate'	=> $Event['CreateDate'],
					'UserID'	=> $Event['UserID'],
					'Email'		=> $Event['Email'],
					'ServiceID'	=> 10000,
					'ServiceName'	=> 'Заказ хостинга',
					'SchemeID'	=> 0,
					'SchemeName'	=> $Scheme,
					'OrderID'	=> $OrderID,
					'Parked'	=> $Domain
					);
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('OrdersHistory',$Array);
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			$Parked = Explode(',',$OrdersHistory['Parked']);
			#-------------------------------------------------------------------------------
			if(!In_Array($Domain,$Parked)){
				#-------------------------------------------------------------------------------
				$Parked[] = $Domain;
				#-------------------------------------------------------------------------------
				$IsUpdate = DB_Update('OrdersHistory',Array('SchemeName'=>$Scheme,'Parked'=>Implode(',',$Parked)),Array('Where'=>SPrintF('`OrderID` = %u',$OrderID)));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[files/1000029]: UPDATE hosting: %s; domain: %s',$Data[1][0],$Domain));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// удаляем запись из таблицы событий
			$IsDelete = DB_Delete('Events',Array('ID'=>$Event['ID']));
			if(Is_Error($IsDelete))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// события хостинга, вариант 4
$Events = DB_Select('Events',Array('*','(SELECT `Email` FROM `Users` WHERE `Users`.`ID` = `UserID`) AS `Email`'),Array('Where'=>'`Text` LIKE "Заказ хостинга логин [%], домен (%) успешно создан на сервере (%) с тарифным планом (%), идентификатор пакета (%)"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Events)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Events as $Event){
		#-------------------------------------------------------------------------------
		Preg_Match_All("/.*\[(.*)\]\,.*\((.*)\).*\((.*)\).*\((.*)\)\,.*\((.*)\).*/U",$Event['Text'],$Data);
		#-------------------------------------------------------------------------------
		$OrderID= Preg_Replace("/[^0-9]/",'',$Data[1][0]);
		$Domain	= $Data[2][0];
		$Scheme	= $Data[4][0];
		#-------------------------------------------------------------------------------
		if(!$OrderID){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NO ORDER ID: %s',$Event['Text']));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$OrdersHistory = DB_Select('OrdersHistory',Array('Parked'),Array('UNIQ','Where'=>Array(SPrintF('`OrderID` = %u',$OrderID))));
		#-------------------------------------------------------------------------------
		switch(ValueOf($OrdersHistory)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NOT FOUND HISTORY: %s/%s',$Data[1][0],$Domain));
			#-------------------------------------------------------------------------------
			// готовим массив для вставки в БД
			$Array = Array(
					'StatusDate'	=> $Event['CreateDate'],
					'CreateDate'	=> $Event['CreateDate'],
					'UserID'	=> $Event['UserID'],
					'Email'		=> $Event['Email'],
					'ServiceID'	=> 10000,
					'ServiceName'	=> 'Заказ хостинга',
					'SchemeID'	=> 0,
					'SchemeName'	=> $Scheme,
					'OrderID'	=> $OrderID,
					'Parked'	=> $Domain
					);
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('OrdersHistory',$Array);
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			$Parked = Explode(',',$OrdersHistory['Parked']);
			#-------------------------------------------------------------------------------
			if(!In_Array($Domain,$Parked)){
				#-------------------------------------------------------------------------------
				$Parked[] = $Domain;
				#-------------------------------------------------------------------------------
				$IsUpdate = DB_Update('OrdersHistory',Array('SchemeName'=>$Scheme,'Parked'=>Implode(',',$Parked)),Array('Where'=>SPrintF('`OrderID` = %u',$OrderID)));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[files/1000029]: UPDATE hosting: %s; domain: %s',$Data[1][0],$Domain));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// удаляем запись из таблицы событий
			$IsDelete = DB_Delete('Events',Array('ID'=>$Event['ID']));
			if(Is_Error($IsDelete))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// события хостинга, вариант 5
$Events = DB_Select('Events',Array('*','(SELECT `Email` FROM `Users` WHERE `Users`.`ID` = `UserID`) AS `Email`'),Array('Where'=>'`Text` LIKE "Заказ хостинга логин [%], домен (%), тариф (%) %"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Events)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Events as $Event){
		#-------------------------------------------------------------------------------
		Preg_Match_All("/.*\[(.*)\]\,.*\((.*)\).*\((.*)\).*\((.*)\).*/U",$Event['Text'],$Data);
		#-------------------------------------------------------------------------------
		$OrderID= Preg_Replace("/[^0-9]/",'',$Data[1][0]);
		$Domain	= $Data[2][0];
		$Scheme	= $Data[3][0];
		#-------------------------------------------------------------------------------
		if(!$OrderID){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NO ORDER ID: %s',$Event['Text']));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$OrdersHistory = DB_Select('OrdersHistory',Array('Parked'),Array('UNIQ','Where'=>Array(SPrintF('`OrderID` = %u',$OrderID))));
		#-------------------------------------------------------------------------------
		switch(ValueOf($OrdersHistory)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NOT FOUND HISTORY: %s/%s',$Data[1][0],$Domain));
			#-------------------------------------------------------------------------------
			// готовим массив для вставки в БД
			$Array = Array(
					'StatusDate'	=> $Event['CreateDate'],
					'CreateDate'	=> $Event['CreateDate'],
					'UserID'	=> $Event['UserID'],
					'Email'		=> $Event['Email'],
					'ServiceID'	=> 10000,
					'ServiceName'	=> 'Заказ хостинга',
					'SchemeID'	=> 0,
					'SchemeName'	=> $Scheme,
					'OrderID'	=> $OrderID,
					'Parked'	=> $Domain
					);
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('OrdersHistory',$Array);
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			$Parked = Explode(',',$OrdersHistory['Parked']);
			#-------------------------------------------------------------------------------
			if(!In_Array($Domain,$Parked)){
				#-------------------------------------------------------------------------------
				$Parked[] = $Domain;
				#-------------------------------------------------------------------------------
				$IsUpdate = DB_Update('OrdersHistory',Array('SchemeName'=>$Scheme,'Parked'=>Implode(',',$Parked)),Array('Where'=>SPrintF('`OrderID` = %u',$OrderID)));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[files/1000029]: UPDATE hosting: %s; domain: %s',$Data[1][0],$Domain));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// удаляем запись из таблицы событий
			$IsDelete = DB_Delete('Events',Array('ID'=>$Event['ID']));
			if(Is_Error($IsDelete))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// события хостинга, вариант 6
$Events = DB_Select('Events',Array('*','(SELECT `Email` FROM `Users` WHERE `Users`.`ID` = `UserID`) AS `Email`'),Array('Where'=>'`Text` LIKE "Успешно изменён тарифный план (%) заказа на хостинг [%], сервер (%)"'));
#-------------------------------------------------------------------------------
switch(ValueOf($Events)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Events as $Event){
		#-------------------------------------------------------------------------------
		Preg_Match_All("/.*\((.*)\-\>(.*)\).*\[(.*)\]\,.*\((.*)\).*/U",$Event['Text'],$Data);
		#-------------------------------------------------------------------------------
		$OrderID= Preg_Replace("/[^0-9]/",'',$Data[3][0]);
		$Domain	= '';
		$Scheme	= $Data[2][0];
		#-------------------------------------------------------------------------------
		if(!$OrderID){
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NO ORDER ID: %s',$Event['Text']));
			#-------------------------------------------------------------------------------
			continue;
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		// проверяем наличие такой записи в таблице истории заказов
		$OrdersHistory = DB_Select('OrdersHistory',Array('Parked'),Array('UNIQ','Where'=>Array(SPrintF('`OrderID` = %u',$OrderID))));
		#-------------------------------------------------------------------------------
		switch(ValueOf($OrdersHistory)){
		case 'error':
			return ERROR | @Trigger_Error(500);
		case 'exception':
			#-------------------------------------------------------------------------------
			Debug(SPrintF('[files/1000029]: NOT FOUND HISTORY: %s/%s',$Data[1][0],$Domain));
			#-------------------------------------------------------------------------------
			// готовим массив для вставки в БД
			$Array = Array(
					'StatusDate'	=> $Event['CreateDate'],
					'CreateDate'	=> $Event['CreateDate'],
					'UserID'	=> $Event['UserID'],
					'Email'		=> $Event['Email'],
					'ServiceID'	=> 10000,
					'ServiceName'	=> 'Заказ хостинга',
					'SchemeID'	=> 0,
					'SchemeName'	=> $Scheme,
					'OrderID'	=> $OrderID,
					'Parked'	=> $Domain
					);
			#-------------------------------------------------------------------------------
			$IsInsert = DB_Insert('OrdersHistory',$Array);
			if(Is_Error($IsInsert))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		case 'array':
			#-------------------------------------------------------------------------------
			$Parked = Explode(',',$OrdersHistory['Parked']);
			#-------------------------------------------------------------------------------
			if(!In_Array($Domain,$Parked)){
				#-------------------------------------------------------------------------------
				$Parked[] = $Domain;
				#-------------------------------------------------------------------------------
				$IsUpdate = DB_Update('OrdersHistory',Array('SchemeName'=>$Scheme,'Parked'=>Implode(',',$Parked)),Array('Where'=>SPrintF('`OrderID` = %u',$OrderID)));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
				Debug(SPrintF('[files/1000029]: UPDATE hosting: %s; domain: %s',$Data[1][0],$Domain));
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
			// удаляем запись из таблицы событий
			$IsDelete = DB_Delete('Events',Array('ID'=>$Event['ID']));
			if(Is_Error($IsDelete))
				return ERROR | @Trigger_Error(500);
			#-------------------------------------------------------------------------------
			break;
			#-------------------------------------------------------------------------------
		default:
			return ERROR | @Trigger_Error(101);
		}
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}


#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// где-то ошибся, пустой параметр в Parked воткнулся. надо убрать
$Orders = DB_Select('OrdersHistory',Array('ID','Parked'));
#-------------------------------------------------------------------------------
switch(ValueOf($Orders)){
case 'error':
	return ERROR | @Trigger_Error(500);
case 'exception':
	break;
case 'array':
	#-------------------------------------------------------------------------------
	foreach($Orders as $Order){
		#-------------------------------------------------------------------------------
		$Array = Array();
		#-------------------------------------------------------------------------------
		$Parked = Explode(',',$Order['Parked']);
		#-------------------------------------------------------------------------------
		foreach($Parked as $Domain)
			if($Domain)
				$Array[] = $Domain;
		#-------------------------------------------------------------------------------
		$IsUpdate = DB_Update('OrdersHistory',Array('Parked'=>Implode(',',$Array)),Array('ID'=>$Order['ID']));
		if(Is_Error($IsUpdate))
			return ERROR | @Trigger_Error(500);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	break;
	#-------------------------------------------------------------------------------
default:
	return ERROR | @Trigger_Error(101);
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

?>
