<?php

#-------------------------------------------------------------------------------
/** @author Alex Keda, for www.host-food.ru */
/******************************************************************************/
/******************************************************************************/
// тут обновлен
if(HOST_ID == 'manager.host-food.ru')
	return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$ConfigPath = SPrintF('%s/hosts/%s/config/Config.xml',SYSTEM_PATH,HOST_ID);
#-------------------------------------------------------------------------------
if(File_Exists($ConfigPath)){
	#-----------------------------------------------------------------------------
	$File = IO_Read($ConfigPath);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-----------------------------------------------------------------------------
	$XML = String_XML_Parse($File);
	if(Is_Exception($XML))
		return ERROR | @Trigger_Error(500);
	#-----------------------------------------------------------------------------
	$Config = $XML->ToArray();
	#-----------------------------------------------------------------------------
	$Config = $Config['XML'];
	#-------------------------------------------------------------------------------
}else{
	#-------------------------------------------------------------------------------
	$Config = Array();
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
// если ключ шифрования не задан, генерим т сохраняем новый
if(!IsSet($Config['EncryptionKey'])){
	#-------------------------------------------------------------------------------
	$Config['EncryptionKey'] = Md5(MicroTime().Rand(0,1000000));
	#-------------------------------------------------------------------------------
	Debug(SPrintF("[patches/hosting/files/1000034.php]: Config = %s",print_r($Config,true)));
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	$File = IO_Write($ConfigPath,To_XML_String($Config),TRUE);
	if(Is_Error($File))
		return ERROR | @Trigger_Error(500);
	#-------------------------------------------------------------------------------
	$IsFlush = CacheManager::flush();
	if(!$IsFlush)
		@Trigger_Error(500);
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
$EncryptionKey = $Config['EncryptionKey'];
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
$NoTypesDB = &Link_Get('NoTypesDB','boolean');
#-------------------------------------------------------------------------------
$NoTypesDB = TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
Debug(SPrintF("[patches/hosting/files/1000034.php]: EncryptionKey = %s",$EncryptionKey));
/*
 * manager# grep Crypt  hosts/ * /config/TypesDB.xml
 * hosts/hosting/config/TypesDB.xml:<Password>Crypt</Password>
 * hosts/hosting/config/TypesDB.xml:<DSpass>Crypt</DSpass>
 * hosts/hosting/config/TypesDB.xml:<ILOpass>Crypt</ILOpass>
 * */
$Tables = Array('Servers','HostingOrders','VPSOrders','ExtraIPOrders','DNSmanagerOrders','DSSchemes');
#-------------------------------------------------------------------------------
foreach($Tables as $Table){
	#-------------------------------------------------------------------------------
	$Columns = ($Table == 'DSSchemes')?Array('ID','DSpass','ILOpass'):Array('ID','Password');
	$Rows = DB_Select($Table,$Columns);
	#-------------------------------------------------------------------------------
	switch(ValueOf($Rows)){
	case 'error':
		return ERROR | @Trigger_Error(500);
	case 'exception':
		# No more...
		break;
	case 'array':
		#-------------------------------------------------------------------------------
		foreach($Rows as $Row){
			#-------------------------------------------------------------------------------
			// перебираем пароли
			foreach(Array('Password','DSpass','ILOpass') as $Key){
				#-------------------------------------------------------------------------------
				if(!IsSet($Row[$Key]))
					continue;
				#-------------------------------------------------------------------------------
				Debug(SPrintF("[patches/hosting/files/1000034.php]: Table = %s; ID = %s; Key = %s; Password = %s",$Table,$Row['ID'],$Key,$Row[$Key]));
				#-------------------------------------------------------------------------------
				$PasswordPlain = Crypt_Decode_Old($Row[$Key],$EncryptionKey);
				//Debug(SPrintF("[patches/hosting/files/1000034.php]: PasswordPlain = %s",$PasswordPlain));
				#-------------------------------------------------------------------------------
				$PasswordCryptNew = Crypt_Encode_New($PasswordPlain,$EncryptionKey);
				//Debug(SPrintF("[patches/hosting/files/1000034.php]: PasswordCryptNew = %s",$PasswordCryptNew));
				#-------------------------------------------------------------------------------
				//$PasswordPlainNew = Crypt_Decode_New($PasswordCryptNew,$EncryptionKey);
				//Debug(SPrintF("[patches/hosting/files/1000034.php]: PasswordPlainNew = %s",$PasswordPlainNew));
				#-------------------------------------------------------------------------
				$IsUpdate = DB_Update($Table,Array($Key=>$PasswordCryptNew),Array('ID'=>$Row['ID']));
				if(Is_Error($IsUpdate))
					return ERROR | @Trigger_Error(500);
				#-------------------------------------------------------------------------------
			}
			#-------------------------------------------------------------------------------
		}
		#-------------------------------------------------------------------------------
		break;
	default:
		return ERROR | @Trigger_Error(101);
	}
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Crypt_Encode_Old($String, $Key = HOST_ID){
	/******************************************************************************/
	$__args_types = Array('string','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	//Debug(SPrintF('[system/libs/auto/Crypt]: String = %s; Key = %s',$String,$Key));
	if(Extension_Loaded('openssl')){
		#-------------------------------------------------------------------------------
		if(StrLen($String) % 8)
			$String = Str_Pad($String,StrLen($String) + 8 - StrLen($String) % 8,"\0");
		#-------------------------------------------------------------------------------
		//Debug(SPrintF('[system/libs/auto/Crypt]: String = %s; Key = %s',$String,$Key));
		#-------------------------------------------------------------------------------
		$Cipher = 'des-ecb';
		if(!$String = @OpenSSL_Encrypt($String,$Cipher,$Key, OPENSSL_RAW_DATA | OPENSSL_NO_PADDING))
			return ERROR | @Trigger_Error(SPrintF('[Crypt_Encode]: не удалось зашифровать данные'));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return Base64_Encode($String);
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

function Crypt_Decode_Old($String,$Key = HOST_ID){
	/******************************************************************************/
	$__args_types = Array('string','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	$String = Base64_Decode($String);
	#-------------------------------------------------------------------------------
	if(Empty($String))
		return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	if(Extension_Loaded('openssl')){
		#-------------------------------------------------------------------------------
		$Cipher = 'des-ecb';
		if(!$String = @OpenSSL_Decrypt($String,$Cipher,$Key,OPENSSL_RAW_DATA | OPENSSL_NO_PADDING))
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось дешифровать данные');
		#-------------------------------------------------------------------------------
		$String = Trim($String);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------

function Crypt_Encode_New($String, $Key = HOST_ID){
	/******************************************************************************/
	$__args_types = Array('string','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	//Debug(SPrintF('[system/libs/auto/Crypt]: String = %s; Key = %s',$String,$Key));
	if(Empty($String))
		return $String;
	#-------------------------------------------------------------------------------
	if(Extension_Loaded('openssl')){
		#-------------------------------------------------------------------------------
		$Cipher = 'AES-128-CBC';
		#-------------------------------------------------------------------------------
		$IVLen = OpenSSL_Cipher_IV_Length($Cipher);
		#-------------------------------------------------------------------------------
		$IV = OpenSSL_Random_Pseudo_Bytes($IVLen);
		#-------------------------------------------------------------------------------
		if(!$StringRaw = @OpenSSL_Encrypt($String,$Cipher,$Key,$Options = OPENSSL_RAW_DATA,$IV))
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось дешифровать данные');
		#-------------------------------------------------------------------------------
		$HMAC = Hash_HMAC('sha256',$StringRaw,$Key,$As_Binary = true);
		#-------------------------------------------------------------------------------
		$String = Base64_Encode(SPrintF('%s%s%s',$IV,$HMAC,$StringRaw));
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
function Crypt_Decode_New($String, $Key = HOST_ID){
	/******************************************************************************/
	$__args_types = Array('string','string');
	#-------------------------------------------------------------------------------
	$__args__ = Func_Get_Args(); Eval(FUNCTION_INIT);
	/******************************************************************************/
	//Debug(SPrintF('[system/libs/auto/Crypt]: String = %s; Key = %s',$String,$Key));
	$String = Base64_Decode($String);
	#-------------------------------------------------------------------------------
	if(Empty($String))
		return $String;
	#-------------------------------------------------------------------------------
	if(Extension_Loaded('openssl')){
		#-------------------------------------------------------------------------------
		$Cipher = 'AES-128-CBC';
		#-------------------------------------------------------------------------------
		$IVLen = OpenSSL_Cipher_IV_Length($Cipher);
		#-------------------------------------------------------------------------------
		$IV = SubStr($String,0,$IVLen);
		#-------------------------------------------------------------------------------
		$HMAC = SubStr($String,$IVLen,$SHA2Len = 32);
		#-------------------------------------------------------------------------------
		$StringRaw = SubStr($String,$IVLen+$SHA2Len);
		#-------------------------------------------------------------------------------
		if(!$String = @OpenSSL_Decrypt($StringRaw,$Cipher,$Key,$Options = OPENSSL_RAW_DATA,$IV))
			return ERROR | @Trigger_Error('[Crypt_Decode]: не удалось дешифровать данные');
		#-------------------------------------------------------------------------------
		$String = Trim($String);
		#-------------------------------------------------------------------------------
	}
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
	return $String;
	#-------------------------------------------------------------------------------
	#-------------------------------------------------------------------------------
}
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
return TRUE;
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
?>

